%{
/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: text.l,v 2.1 91/06/18 22:02:34 dick Exp $
*/

/*
	Text front end for the similarity tester.
*/

#include	"private.h"
#include	"token.h"
#include	"stream.h"
#include	"lex.h"
#include	"idf.h"

/* Language-dependent Code */

InitLanguage()
{
}

/*ARGSUSED*/
int
MayBeStartOfRun(tk)
	TOKEN tk;
{
	/* any token is acceptable */
	return 1;
}

/*ARGSUSED*/
unsigned int
CheckRun(str, size)
	TOKEN *str;
	unsigned int size;
{
	/* any run is acceptable */
	return size;
}

/* Language-INdependent Code */

yystart() {
	BEGIN INITIAL;
}

PRIVATE int
yywrap() {
	return 1;
}

%}

Layout		([ \t])

%%

[^ \t\n]+	{			/* a word */
		/*	a word is defined as anything not containing
			layout
		*/
		return_tk(idf_hashed(yytext));
	}

{Layout}	{			/* ignore layout */
	}

\n	{				/* count newlines */
		return_eol();
	}

.	{				/* copy other text */
		if (!(yytext[0]&0200)) return_ch(yytext[0]);
	}

%%

