/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: pass3.c,v 2.2 92/06/30 15:23:26 dick Exp $
*/

#define		LINT_ARGS
#include	<stdio.h>

#include	"cport.h"
#include	"private.h"
#include	"params.h"
#include	"sim.h"
#include	"aiso.h"
#include	"debug.h"

extern char *malloc();

extern char options[];
extern int page_width;

PRIVATE FILE *open_chunk();
PRIVATE fill_line(), clear_line();
PRIVATE show_run(), show_2C_line(), show_1C_line();
PRIVATE int prhead(), prs(), pru(), unslen();
PRIVATE int maxline;			/* Actual maximum line length */
PRIVATE char *line0;			/* by malloc() */
PRIVATE char *line1;

pass3() {
	AisoIter iter;
	struct run *run;

	maxline = page_width / 2 - 2;
	line0 = malloc((unsigned int)((maxline + 1) * sizeof (char)));
	line1 = malloc((unsigned int)((maxline + 1) * sizeof (char)));
	if (!line0 || !line1) fatal("out of memory");

	OpenIter(&iter);
	while (GetAisoItem(&iter, &run)) {
#ifdef	DB_RUN
		db_run(run);
#endif	/* DB_RUN */
		show_run(run);
		printf("\n");
	}
	CloseIter(&iter);
}

PRIVATE
show_run(run)
	struct run *run;
{
	/* The animals came in two by two ... */
	register struct chunk *cnk0 = &run->rn_cn0;
	register struct chunk *cnk1 = &run->rn_cn1;
	register unsigned int nl_cnt0 =
			cnk0->ch_last.ps_nl_cnt - cnk0->ch_first.ps_nl_cnt;
	register unsigned int nl_cnt1 =
			cnk1->ch_last.ps_nl_cnt - cnk1->ch_first.ps_nl_cnt;
	FILE *f0;
	FILE *f1;
	
	/* display heading of chunk */
	if (!options['d']) {
		/* no assumptions about the lengths of the file names! */
		register unsigned int quality = run->rn_quality;
		register int pos = 0;
		
		pos += prhead(cnk0);
		while (pos < maxline + 1) {
			pos += prs(" ");
		}
		pos += prs("|");
		pos += prhead(cnk1);
		while (pos < 2*maxline - unslen(quality)) {
			pos += prs(" ");
		}
		printf("[%u]\n", quality);
	}
	else {
		prhead(cnk0);
		printf("\n");
		prhead(cnk1);
		printf("\n");
	}
	
	/* stop if that suffices */
	if (options['n'])
		return;			/* ... had enough so soon ... */
	
	/* open the files that hold the chunks */
	f0 = open_chunk(cnk0);
	f1 = open_chunk(cnk1);
	
	/* display the chunks in the required format */
	if (!options['d']) {
		/* fill 2-column lines and print them */
		while (nl_cnt0 != 0 || nl_cnt1 != 0) {
			if (nl_cnt0) {
				fill_line(f0, line0);
				nl_cnt0--;
			}
			else {
				clear_line(line0);
			}
			if (nl_cnt1) {
				fill_line(f1, line1);
				nl_cnt1--;
			}
			else {
				clear_line(line1);
			}
			show_2C_line(line0, line1);
		}
	}
	else {
		/* display the lines in a diff(1)-like format */
		while (nl_cnt0--) {
			show_1C_line(f0, "<");
		}
		printf("---\n");
		while (nl_cnt1--) {
			show_1C_line(f1, ">");
		}
	}
	
	/* close the pertinent files */
	fclose(f0);
	fclose(f1);
}

PRIVATE int
prhead(cnk)
	struct chunk *cnk;
{
	register int pos = 0;
	
	pos += prs(cnk->ch_text->tx_fname);
	pos += prs(": line ");
	pos += pru(cnk->ch_first.ps_nl_cnt);
	pos += prs("-");
	pos += pru(cnk->ch_last.ps_nl_cnt - 1);
	return pos;
}

PRIVATE int
prs(str)
	char *str;
{
	printf("%s", str);
	return strlen(str);
}

PRIVATE int
pru(u)
	unsigned int u;
{
	printf("%u", u);
	return unslen(u);
}

PRIVATE int
unslen(u)
	unsigned int u;
{
	register int res = 1;
	
	while (u > 9) {
		u /= 10, res++;
	}
	return res;
}

PRIVATE FILE *
open_chunk(cnk)
	struct chunk *cnk;
{
	/*	opens the file in which the chunk resides and positions
		the file at the beginning of the chunk
	*/
	register char *fname = cnk->ch_text->tx_fname;
	register FILE *f = fopen(fname, "r");
	
	if (!f) {
		printf("*** File %s disappeared\n", fname);
		f = fopen("/dev/null", "r");
	}

#ifdef	BAD_FSEEK
	{	unsigned int nl_cnt = cnk->ch_first.ps_nl_cnt;
	
		while (nl_cnt > 1) {
			int ch = getc(f);
			
			if (ch < 0) break;
			if (ch == '\n') {
				nl_cnt--;
			}
		}
	}
#else
	fseek(f, cnk->ch_first.ps_fs_pos, 0);
#endif
	return f;
}

PRIVATE
fill_line(f, ln)
	FILE *f;
	char ln[];
{
	/*	Reads one line from f and puts it in condensed form in ln.
	*/
	register int indent = 0, lpos = 0;
	register int ch;
	
	/* condense and skip initial blank */
	while ((ch = getc(f)), ch == ' ' || ch == '\t') {
		if (ch == '\t') {
			indent = 8;
		}
		else {
			indent++;
		}
		if (indent == 8) {
			/* every eight blanks give one blank */
			if (lpos < maxline) {
				ln[lpos++] = ' ';
			}
			indent = 0;
		}
	}
	
	/* store the rest */
	while (ch >= 0 && ch != '\n') {
		if (ch == '\t') {
			/* replace tabs by blanks */
			ch = ' ';
		}
		if (lpos < maxline) {
			ln[lpos++] = ch;
		}
		ch = getc(f);
	}
	ln[lpos] = '\0';		/* always room for this one */
}

PRIVATE
clear_line(ln)
	char ln[];
{
	/* a simple null byte will suffice */
	ln[0] = '\0';
}

PRIVATE
show_2C_line(ln0, ln1)
	char ln0[], ln1[];
{
	/*	displays the contents of the two lines in a two-column
		format
	*/
	register int i;
	
	for (i = 0; i < maxline && ln0[i] != '\0'; i++) {
		putchar(ln0[i]);
	}
	for (; i < maxline; i++) {
		putchar(' ');
	}
	printf(" |");
	
	for (i = 0; i < maxline && ln1[i] != '\0'; i++) {
		putchar(ln1[i]);
	}
	printf("\n");
}

PRIVATE
show_1C_line(f, marker)
	FILE *f;
	char *marker;
{
	/*	displays one line from f, preceded by the marker
	*/
	register int ch;
	
	printf("%s", marker);
	while ((ch = getc(f)), ch > 0 && ch != '\n') {
		putchar(ch);
	}
	putchar('\n');
}

