/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: lang.c,v 2.2 91/09/17 21:32:44 dick Exp $
*/

/*
	lang() is a service routine that prints results from the
	lexical analyzer.  For each line, it prints:
		the line count,
		the token count at the beginning of the line,
		the fseek position to the beginning of the line,
		the contents of the line in token format.
*/

#include	"stream.h"

lang(fname)
	char *fname;
{
	printf("File %s:", fname);
	if (!OpenStream(fname)) {
		printf(" cannot open\n");
		return;
	}
	
	printf("nl_cnt, tk_cnt, fs_pos: tokens");

	lex_token = EOL;
	do {
		if (TOKEN_EQ(lex_token, EOL)) {
			printf("\n%u,%u,%ld:",
				lex_nl_cnt, lex_tk_cnt, lex_fs_pos);
		}
		else {
			show_token(lex_token);
		}
	} while (NextStrToken());

	printf("\n");

	CloseStream();
	
}
