/* VTRM example -- a trivial pager.
   There are zillions of things this pager doesn't do, or would
   crash on, but it is a nice demonstration of the use of VTRM. */

#include <stdio.h>

char *index();

#define CTRL(c) ((c)&0x1F)

#include "trm.h"

int lines, columns, flags;
FILE *fp;

/* Main program -- scan arguments, open file, set-up VTRM, main loop. */

main(argc, argv)
	int argc;
	char **argv;
{
	int n, c;
	
	if (argc != 2) {
		fprintf(stderr, "usage: %s file\n", argv[0]);
		exit(2);
	}
	
	if ((fp= fopen(argv[1], "r")) == NULL) {
		perror(argv[1]);
		exit(1);
	}
	
	if ((n= trmstart(&lines, &columns, &flags)) != 0) {
		fprintf(stderr, "trmstart error %d\n", n);
		exit(3);
	}
	
	page();

	for (;;) {
		prompt();
		c= trminput();
		
		switch (c) {

		case ' ':			/* Display one more page */
			page();
			break;

		case '\n':			/* Display one more line */
		case '\r':
			line();
			break;

		case 'q':			/* Quit */
		case CTRL('C'):			/* or Interrupt */
			trmputdata(lines-1, lines-1, 0, "");
			trmsync(lines-1, 0);
			trmend();
			exit(2);
		
		case CTRL('Z'):			/* Suspend */
			trmputdata(lines-1, lines-1, 0, "");
			trmsync(lines-1, 0);
			trmend();
			trmsuspend();
			if (trmstart(&lines, &columns, &flags))
				exit(3);
			page();
			break;

		default:			/* Error */
			trmbell();
			break;

		}
	}
}

int left;	/* Lines left on current page */

/* Output one page, using line() as a subroutine.
   BUG: if the last line takes up more space than available, it is
   displayed in its entirety, scrolling up more than a page in total. */

page()
{
	left= lines-1;
	do {
		line();
	} while (left > 0);
}

/* Output one line.  The line is displayed at the bottom,
   assuming the botom line of the screen is free.
   Update count of lines left on display.  Exit if EOF hit. */

line()
{
	char linebuf[BUFSIZ];
	char *p;
	int n;
	
	if (fgets(linebuf, sizeof linebuf, fp) == NULL) {
		trmend();
		exit(0);
	}
	if (p= index(linebuf, '\n'))
		*p= '\0';
	n= need(linebuf);
	trmscrollup(0, lines-1, n);
	trmputdata(lines-n-1, lines-2, 0, linebuf);
	left -= n;
}

/* Compute the number of screen lines required.
   Assumes only printing characters. */

need(buf)
	char *buf;
{
	int len= strlen(buf);
	
	if (len == 0)
		return 1;
	else
		return (len+columns-1) / columns;
}

/* Issue a prompt on the bottom line.
   Assumes this line is already free. */

prompt()
{
	static int beenhere= 0;
	static char pr[]= "--More--";
	
	if (!beenhere++) {
		char *p;
		
		for (p= pr; *p; ++p)
			*p |= 0x80;
	}
	trmputdata(lines-1, lines-1, 0, pr);
	trmsync(lines-1, strlen(pr));
}
