;slaconfg.lsp
;Configures SLaTeX for Common Lisp on your system
;(c) Dorai Sitaram, Rice U., 1991, 1994

(with-open-file (inp "config.dat" :direction :input)
  (read inp) ;ignore dialect info
  (setq *op-sys* (read inp)))

(if (not (member *op-sys* '(dos unix other)))
    (setq *op-sys* 'other))

(load "preproc.lsp")
(load "rnrscl.lsp")

(defvar list-of-slatex-files
  (list
    "s4.scm"
    "seqprocs.scm"
    "fileproc.scm"
    "lerror.scm"
    "defaults.scm"
    "helpers.scm"
    "structs.scm"
    "peephole.scm"
    "codeset.scm"
    "pathproc.scm"
    "texread.scm"
    "proctex.scm"
    "proctex2.scm"))

(defun generate-compatible-file (outf)
  (if (probe-file outf) (delete-file outf))
  (with-open-file (outp outf :direction :output)
    (format outp
      ";slatex.scm file generated using config.scm~%~
       ;This file is compatible for Common Lisp~%~
       ;(c) Dorai Sitaram, Rice U., 1991, 1994~%")

    (print `(defvar *op-sys*
	      ',(if (eq *op-sys* 'dos) 'dos 'unix))
      outp)

    (format #t "Pass 1...~%")
    (mapc #'(lambda (f)
	      (format #t "~t~a~%" f)
	      (scm/module/file-determine-locals f))
      list-of-slatex-files)

    (format #t "~%Pass 2...~%")
    (mapc #'(lambda (f)
	      (format #t "~t~a~%" f)
	      (scm/module/translate-file-to-port f outp))
      list-of-slatex-files)))

(format #t "Beginning configuring SLaTeX for Common Lisp on ~a -- ~
            wait...~%" *op-sys*)

(let ((*print-pretty* nil))
  (generate-compatible-file "slatex.scm"))

(format #t
  "Finished configuring SLaTeX for your machine.~%~
   Read install.doc for details on~%~
   ~t i. which paths to place the SLaTeX files in;~%~
   ~t ii. how to modify the given batch file or shell script ~
          that invokes SLaTeX.~%")
