;batconfg.lsp
;Configures SLaTeX batfile/shellscript (CL version)
;(c) Dorai Sitaram, Rice U., 1991, 1994

(defvar *dialect* 'cl)
(defvar *op-sys* 'forward)
(defvar *scheme-pathname* 'forward)
(defvar *slatex-pathname* 'forward)
(defvar *texinputs* 'forward)
(defvar *accepts-echo* 'forward)
(defvar *accepts-cmdline-file* 'forward)
(defvar *accepts-initfile* 'forward)
(defvar *system-procedure* 'forward)

(with-open-file (inp "config.dat" :direction :input)
    (read inp) ;ignore dialect info
    (setq *op-sys* (read inp))
    (setq *scheme-pathname* (read inp))
    (setq *slatex-pathname* (read inp))
    (setq *texinputs* (read inp))
    (setq *accepts-echo* (read inp))
    (setq *accepts-cmdline-file* (read inp))
    (setq *accepts-initfile* (read inp)))

(if (not (member *op-sys* '(dos unix other)))
    (setq *op-sys* 'other))

(defvar *file-deleter*
  (if (eq *op-sys* 'dos) "del" "rm"))

(defun echo (p &rest z)
  (if (streamp p)
      (mapc #'(lambda (x) (princ x p)) z)
      (progn
	(princ p)
	(mapc 'princ z)
	(force-output))))

(defvar % "
")

(defvar *echo-delim*
  (cond ((eq *op-sys* 'dos) "")
        (t "'")))

(defvar *arg-mark*
  (cond ((eq *op-sys* 'dos) "%")
        (t "$")))

(defvar *call-for-bat*
  (cond ((eq *op-sys* 'dos) "call ")
        (t "")))

(defvar bat-file (if (eq *op-sys* 'dos) "slatex.bat" "slatex"))

(if (probe-file bat-file) (delete-file bat-file))

(echo "Beginning configuring batfile/shellscript"
  "  -- wait..." %)

(defvar op (open bat-file :direction :output))

(if (eq *op-sys* 'dos)
    (echo op "@echo off" %))

(cond ((and *accepts-echo* (eq *op-sys* 'unix))
	;dos echos can't handle longish s-exps
       (echo op  "echo " *echo-delim*
	 "(load \"" *slatex-pathname* "\")"
	 "(setq SLaTeX.*texinputs* \"" *texinputs* "\")"
	 "(SLaTeX.process-main-tex-file \""
	 *echo-delim* *arg-mark* 1 *echo-delim* "\")"
	 *echo-delim* "|" *scheme-pathname* %))
      (*accepts-cmdline-file*
	(echo op
	  "echo " *echo-delim*
	  "(load \"" *slatex-pathname* "\")"
	  *echo-delim* " > slatex.jnk" %

	  "echo " *echo-delim*
	  "(setq SLaTeX.*texinputs* \"" *texinputs* "\")"
	  *echo-delim* " >> slatex.jnk" %

	  "echo " *echo-delim*
	  "(SLaTeX.process-main-tex-file \""
	  *echo-delim* *arg-mark* 1 *echo-delim* "\")"
	  *echo-delim* " >> slatex.jnk" %

	  "echo " *echo-delim* "(exit)" *echo-delim*
	  " >> slatex.jnk" %

	  *call-for-bat* *scheme-pathname* " slatex.jnk" %

	  *file-deleter* " slatex.jnk" %))
      (*accepts-initfile*
	(echo op
	  "echo " *echo-delim*
	  "(load \"" *slatex-pathname* "\")"
	  *echo-delim* " > " *accepts-initfile* %

	  "echo " *echo-delim*
	  "(setq SLaTeX.*texinputs* \"" *texinputs* "\")"
	  *echo-delim* " >> " *accepts-initfile* %

	  "echo " *echo-delim*
	  "(SLaTeX.process-main-tex-file \""
	  *echo-delim* *arg-mark* 1 *echo-delim* "\")"
	  *echo-delim* " >> " *accepts-initfile* %

	  "echo " *echo-delim* "(exit)" *echo-delim*
	  " >> " *accepts-initfile* %

	  *call-for-bat* *scheme-pathname* %

	*file-deleter* " " *accepts-initfile* %))
      (t (echo "Your CL/system interface isn't "
	      "very cooperative -- use callsla.scm" %)))

(cond ((eq *op-sys* 'dos)
       (echo op
	 "if exist pltexchk.jnk goto one" %
	 "goto two" %
	 ":one" %
	 "call tex %1" %
	 "del pltexchk.jnk" %
	 "goto end" %
	 ":two" %
	 "call latex %1" %
	 ":end" %))
      (t
	(echo op
	  "if test -f pltexchk.jnk" %
	  "then tex $1; rm pltexchk.jnk" %
	  "else latex $1" %
	  "fi" %)))

(close op)

(if (probe-file "callsla.scm") (delete-file "callsla.scm"))

(with-open-file (p "callsla.scm" :direction :output)
  (princ "(let ((slatex-not-loaded? t))" p)
  (princ "(defun call-slatex (tex-file)" p)
  (princ "(if slatex-not-loaded?" p)
  (princ "(progn (princ \"Loading slatex...\")" p)
  (princ "(load " p)
  (prin1 *slatex-pathname* p)
  (princ ")" p)
  (princ "(princ 'done) (terpri)" p)
  (princ "(setq SLaTeX.*texinputs* " p)
  (prin1 *texinputs* p)
  (princ ")" p)
  (princ "(setq slatex-not-loaded? nil)))" p)
  (princ "(SLaTeX.process-main-tex-file tex-file)" p)
  (princ "(terpri)" p)
  (if *system-procedure*
      (progn (princ "(system (concatenate 'string " p)
        (princ "(if SLaTeX.*latex?* \"latex\" \"tex\")" p)
        (princ "tex-file" p)
        (princ "))" p))
      (progn (princ "(display \"Call (la)tex on \")" p)
        (princ "(display tex-file)" p)
        (princ "(terpri)" p)))
  (princ "t))" p))

(echo "Finished configuring batfile/shellscript" %)
(if (eq *op-sys* 'unix)
  (echo "Type (chmod +x slatex) on Unix command line" %))
