;;; $Id: find-string.scm,v 1.1.1.1 1993/06/24 10:06:04 queinnec Exp $
;;; Copyright (c) 1990-93 by Christian Queinnec. All rights reserved.
;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;;                        LiSP2TeX
;;;   Christian Queinnec             or to:  Christian Queinnec
;;;   <queinnec@polytechnique.fr>            <Christian.Queinnec@inria.fr>
;;;   Laboratoire d'Informatique de l'X      INRIA -- Rocquencourt
;;;   Ecole Polytechnique                    Domaine de Voluceau, BP 105
;;;   91128 Palaiseau                        78153 Le Chesnay Cedex
;;;   France                                 France
;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo

;;; This program is distributed in the hope that it will be useful.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted, so long as the following
;;; conditions are met:
;;;      o credit to the authors is acknowledged following current
;;;        academic behaviour
;;;      o no fees or compensation are charged for use, copies, or
;;;        access to this software
;;;      o this copyright notice is included intact.
;;; This software is made available AS IS, and no warranty is made about
;;; the software or its performance.

;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; This file defines how directives are looked for in the standard input.

;;; PORT note: Macros are still not portable so an alternative is
;;; to use the `look.scm' file instead of this one. The `look.scm' file
;;; is the expansion of this one and does not contain any macros.

;;; A (big) macro to define the function to look for the directives to
;;; be translated. The generated pattern is not optimal, I have in the 
;;; mind a kind of Boyer Moore with multiple strings that I will
;;; eventually write.
(define-macro generate-look-function 
  (lambda (e m)
    (define (string . chars)            ; Curiously lacks from Scheme->C
      (let* ((size (length chars))
             (string (make-string size)) )
        (do ((i 0 (+ 1 i))
             (chars chars (cdr chars)) )
            ((= i size) string)
          (string-set! string i (car chars)) ) ) )
    (define gensym 
      (let ((counter 100))
        (lambda (string)
          (set! counter (+ 1 counter))
          (string->symbol
           (string-append string (number->string counter)) ) ) ) )
    (define (reverse! l)
      (define (nreverse l r)
        (if (pair? l)
            (let ((cdrl (cdr l)))
              (set-cdr! l r)
              (nreverse cdrl l) )
            r ) )
      (nreverse l '()) )
    ;; Analysis of the commands
    (let ((defs (cadr e))
          (read-char (gensym "READ-CHAR"))
          (port (gensym "PORT")) )
      ;; other utilities
      (define (string-add-char string char)
	(let* ((size (string-length string))
	       (newstring (make-string (+ 1 size))) )
	  (do ((i 0 (+ 1 i)))
	      ((= i size) 
	       (string-set! newstring i char)
	       newstring )
	    (string-set! newstring i (string-ref string i)) ) ) )
      (define (string->list-of-characters string)
        (let ((size (string-length string)))
          (do ((i 0 (+ 1 i))
               (result '()) )
              ((= i size) (reverse! result))
            (set! result (cons (string-ref string i) result)) ) ) )
      (define (no-duplicates chars)
        (if (null? chars) '()
            (if (memv (car chars) (cdr chars))
                (no-duplicates (cdr chars))
                (cons (car chars) (no-duplicates (cdr chars))) ) ) )
      (define (generate ch defs prefix)
        `(cond
          ((eof-object? ,ch) (display ,prefix stdout-port))
          ,@(map (lambda (char) 
                   (generate-cond-clause ch char defs prefix) )
                 (no-duplicates (map (lambda (def) (car (car def)))
                                     defs )) )
          (else ,(if (string=? prefix "")
                     `(begin (write-char ,ch stdout-port)
                             (set! ,ch (,read-char ,port)) )
                     `(display ,prefix stdout-port) )
                (look ,ch) ) ) )
      (define (generate-cond-clause ch char defs prefix)
        `((char=? ,ch ,char)
          ,(let ((defs (do ((defs defs (cdr defs))
                            (result '()) )
                           ((null? defs) result)
                         (if (char=? char (caar (car defs)))
                             (set! result (cons (cons (cdar (car defs))
                                                      (cdr (car defs)) )
                                                result )) ) ))
                 (ch (gensym "CHAR")) )
             (cond                  
              ((and (= (length defs) 1)
                    (null? (car (car defs))) )
               `(begin 
                  (when *ultra-verbose* 
			(command-echo ,(string-add-char prefix char)) )
                  (,(cadr (car defs)) ,port)
                  (flush-all-buffers)
                  (look (,read-char ,port)) ) )
              (else
               `(let ((,ch (,read-char ,port)))
                  ,(generate
                    ch
                    defs
		    (string-add-char prefix char) ) ) ) ) ) ) )
      (let* ((ch (gensym "CHAR"))
             (defs (map (lambda (def)
                          (cons (string->list-of-characters (car def))
                                (cdr def) ) )
                        defs ))
             (result `(define (look ,port ,read-char)
                        (define (look ,ch)
                          ,(generate ch defs "") )
                        (look (,read-char ,port)) )) )
        ;;; Generate the look function in a file to help ports.
        (call-with-output-file "look.scm"
          (lambda (out)
            (pp result out) ) )
        ;;; and resume the macroexpansion
        (m result m) ) ) ) )

;;; generate the looker that leave anything unchanged except instances of
;;; the following commands. This defines the function look.
;;; For those who cannot expand correctly this macro, the look function
;;; appears in the look.scm file.

;;; The run-XYZ functions takes the port as sole argument.
(generate-look-function
 ( ( "\\FromFile"            run-FromFile )
   ( "\\Eval"                run-Eval     )
   ( "\\ShowEvaluationOf"    run-ShowEvaluationOf )
   ( "\\PrettyPrint"         run-PrettyPrint )
   ( "\\PrettyFromFile"      run-PrettyFromFile )
   ( "\\Print"               run-Print    ) ) )

;;; end of find-string.scm
