;;; $Id: port-s2c.scm,v 1.10 1992/04/18 14:34:28 queinnec Exp $
;;; This file contains the functions that are highly dependent of the
;;; Scheme implementation. Other files use also some macros that are
;;; well known such as when or until.

;;; These streams correspond to the usual streams of Posix.
;(set! stderr-port stderr-port)
;(set! stdout-port stdout-port)

;;; After each directive processing, flush buffers if not automatically
;;; provided by the implementation.
(define (flush-all-buffers) 
  (flush-buffer stdout-port)
  (flush-buffer stderr-port) )

;;; probe-file tests if a file exists.
;;; This is specific to Scheme->C
(define (probe-file file)
  (let* ((handler *error-handler*)
         (r (call/cc
             (lambda (return)
               (set! *error-handler* (lambda args (return #f)))
               (call-with-input-file file (lambda (stream) #t)) ) )) )
    (set! *error-handler* handler)
    r ) )

;;; Dynamically evaluates an expression. If an error occurs, wrap the
;;; error in a list with a distinguished symbol.
;;; This is specific to Scheme->C
(define (LiSP2TeX-eval exp)
  (let ((handler *error-handler*)
	(result 'wait) )
    (set! result 
	  (call/cc 
	   (lambda (return)
	     (set! *error-handler*
		   (lambda args (return (cons '***EVALUATION-ERROR*** args))) )
	     (eval exp) ) ) )
    (set! *error-handler* handler)
    result ) )

;;; The entry point of LiSP2TeX. The args variable is the list of 
;;; arguments of the shell invokation (a list of strings). This function
;;; has to be called as the initial function.
(define (unix-main . args)
  (set! args (cdr args)) ; strip executable name
  (LiSP2TeX args) )

;;; Define a useless function that calls load, this allows in Scheme->C to
;;; have function load in the final image.
(define (useless)
  (load "tartempion.void") )

;;; To be unsensitive to case, redefine each symbol to be case insensitive.
(define (replicate-symbols)
  (let ((vect *obarray*))
    (let ((unknown-variable 
           'this-variable-is-not-defined-and-used-by-LiSP2TeX ))
      (do ((i 0 (+ 1 i)))
          ((= i (vector-length vect)) #t)
        (for-each 
         (lambda (symbol)
           ;; This is a hack to know if symbol has a value or not
           (unless (eq? (top-level-value unknown-variable) 
                        (top-level-value symbol) )
                   (set-top-level-value! 
                    (string->symbol
                     (string-uppercase
                      (symbol->string symbol) ) )
                    (top-level-value symbol) )
                   (set-top-level-value! 
                    (string->symbol
                     (string-lowercase
                      (symbol->string symbol) ) )
                    (top-level-value symbol) ) ) )
         (vector-ref vect i) ) ) ) ) )

;;; load the content of file. This content may use the various macros
;;; that are defined in emit.scm

(define (load-parameter-file file)
  (loadq file) )
  
;;; The pp.scm file uses some macros that must be present when 
;;; customization files are loaded.
;;; Code snarfed from ~/s2c/s2cmac.scm
;;; Syntax: (define-pervasive-macro (name . parameters) . body)
(define-macro define-pervasive-macro
  (lambda (e m)
    (define (map-arguments variables parameters)
      (cond ((pair? variables)
             (cons `( ,(car variables) (car ,parameters) )
                   (map-arguments (cdr variables) `(cdr ,parameters)) ) )
            ((symbol? variables)
             (list `( ,variables ,parameters )) )
            ((null? variables) '()) ) )
    (let* ((call (cadr e))
           (body (cddr e))
           (s2c-expander
            `(lambda (e m)
               (when (getprop 'define-macro 'ultra-verbose)
                     (format stderr-port "[call macro ~A]~%" e) )
               (m (let ,(map-arguments (cdr call) '(cdr e))
                    . ,body ) m) ))
           (s2c-installer
            `(let ((expander ,s2c-expander))
               (putprop ',(car call) '*expander* expander)
               (putprop ',(car call) 'scc
                        (cons (cons 'macro expander)
                              (or (getprop ',(car call) 'scc)
                                  '() ) ) )
               (putprop ',(car call) 'initial-scc
                        (cons (cons 'macro expander)
                              (or (getprop ',(car call) 'initial-scc)
                                  '() ) ) )
               ,(if (getprop 'define-macro 'verbose)
                    `(format stderr-port "[macro ~A installed]~%"
                             ',(car call) )
                    `#t )
               ',(car call) ) ) )
      (when (getprop 'define-macro 'verbose)
            (format stderr-port "[install macro ~A]~%" (car call)) )
      (eval s2c-installer)
      (m (if #t ; (getprop 'define-macro 'pervasive) ; They are persistent !
             s2c-installer
             `',(car call) ) m) ) ) )
