(define (<-filter-> pred? lyst)
  (cond
    ( (null? lyst) '() )
    ( (pred? (car lyst))
      (cons (car lyst)
            (<-filter-> pred? (cdr lyst))) )
    ( else  (<-filter-> pred? (cdr lyst)) )))

(define (assql obj alist)
  (<-filter-> (lambda (pair) (eq? (car pair) obj)) alist))

(define (assvl obj alist)
  (<-filter-> (lambda (pair) (eqv? (car pair) obj)) alist))

(define (assocl obj alist)
  (<-filter-> (lambda (pair) (equal? (car pair) obj)) alist))
