;;; vectors.scm -- vector and matrix stuff
;;; Brian Beckman, 9 Aug 1989

(define (v-copy vec)
  (let* ( (L (vector-length vec))
          (V (make-vector L)) )
    (do ( (i 0 (1+ i)) )
        ( (= i L)  V )
        (vector-set! V i (vector-ref vec i)))))

(define (v-unop vec op)
  (let ( (L (vector-length vec))
         (V (v-copy vec)) )
    (do ( (i 0 (1+ i)) )
        ( (= i L)  V )
        (vector-set! V i (op (vector-ref vec i))))))
