(define (new-set . initial-list)
  
  (let* ( (ivar '()) )

    (define (list-o-set) ivar)

    (define (put-set! obj)
      (cond
        ( (member obj ivar) self )
        ( else (set! ivar (cons obj ivar)) self )))

    (define (take-set obj)
      (set! ivar
        (let iter ( (L ivar) )
          (cond
            ( (null? L) '() )
            ( (equal? obj (car L)) (iter (cdr L)) )
            ( else (cons (car L) (iter (cdr L))) ))))
      self)

    (define (put-list! L)
      (for-each put-set! L) self)

    (define (member-set? obj)
      (if (member obj ivar) #t #f))

    (define (clear!)
      (set! ivar '()))
      
    (define (self msg)
      (cond
       ( (eq? msg 'list)          list-o-set    )
       ( (eq? msg 'put!)          put-set!      )
       ( (eq? msg 'take!)         take-set      )
       ( (eq? msg 'clear!)        clear!        )
       ( (eq? msg 'put-list!)     put-list!     )
       ( (eq? msg 'member?)       member-set?   )
       ( else  (make-error-method "set" msg) )))

    (put-list! initial-list)
    
    self))
