;================================================================
;| Dr. Brian Beckman              | brian@topaz.jpl.nasa.gov    |
;| Computer Graphics Laboratory   | (818) 397-9207              |
;| Mail Stop 510-202              | (818) 397-9344              |
;| Jet Propulsion Laboratory      |                             |
;| Pasadena, CA 91109             | 3 July 1989                 |
;================================================================

;;; Adapted from Abelson & Sussman, Ch. 3, Pg 208 ff.
;;; Uses the ``methods'' OOP package.  This is an expanded,
;;; industrial-strength solution to Exercise 3.22 of A & S.

(define (new-queue . initial-list)
  
  (let (  (q (cons () ()))
          (initial-list (cond
                          ( (null? initial-list) initial-list )
                          ( else (car initial-list) )))
          (supers ())  )
    
    (define (head) (car q))
    (define (tail) (cdr q))
    (define (set-head! item) (set-car! q item))
    (define (set-tail! item) (set-cdr! q item))
    
    (define (empty-queue?) (null? (head)))
    
    (define (front)
      (if (empty-queue?)
          (error "FRONT called on empty queue")
          (car (head))))
    
    (define (front!)    ;;; Remove front element and return it.
      (let ((f (front)))
        (remove-queue!)
        f))
    
    (define (append-queue! item)
      (let ((elt (cons item ())))  ; could be (list item)
        (cond
         (  (empty-queue?)
            (set-head! elt)
            (set-tail! elt)  
            self  )
         (  else
            (set-cdr! (tail) elt)
            (set-tail! elt)  
            self  ))))
    
    (define (append-list! lyst)
      (for-each append-queue! lyst)
      self)
    
    (define (remove-queue!)
      (cond
       (  (empty-queue?)
          (error "REMOVE called on empty queue")  )
       (  else
          (set-head! (cdr (head)))  self)))
    
    (define (clear-queue!)
      (set! q (cons () ()))
      self)
    
    (define (print) (display (head)) (newline))
    
    (define (self msg)
      (cond
       (  (eq? msg 'append!)       append-queue!  )
       (  (eq? msg 'empty?)        empty-queue?   )
       (  (eq? msg 'remove!)       remove-queue!  )
       (  (eq? msg 'clear!)        clear-queue!   )
       (  (eq? msg 'front)         front  )
       (  (eq? msg 'front!)        front! )
       (  (eq? msg 'print)         print  )
       (  (eq? msg 'list)          (lambda () (head))  )
       (  (eq? msg 'append-list!)  append-list!  )
       (  (search-supertypes supers msg)  )
       (  else  (make-error-method "Queue" msg)  )))
    
    (append-list! initial-list)  ;;; returns ``self''
    
    ))
    ;;; end of new-queue
