/******************************************************************************
 *
 * s t k . h
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 12-May-1993 10:34
 * Last file update:  1-Jun-1994 12:19
 *
 ******************************************************************************/

#include <stdio.h>
#include <setjmp.h>
#include <assert.h>
#include <math.h>
#include <malloc.h>
#include <signal.h>
#include <limits.h>
#include <string.h>
#include <memory.h>
#include <stdlib.h>
#include "gmp.h"

#define COMPACT_SMALL_CST

#define FALSE			0
#define TRUE			1

#define OBARRAY_SIZE	 223			/* size of global vars hash table */
#define TKBUFFERN 	 1024			/* max size of a token */

#ifdef _POSIX_PATH_MAX
#define MAX_PATH_LENGTH	 _POSIX_PATH_MAX
#else
#define MAX_PATH_LENGTH	 256
#endif

#define GC_VERBOSE	"*gc-verbose*"
#define ARGC		"*argc*"
#define ARGV		"*argv*"
#define DEBUG_MODE	"*debug*"


#ifdef USE_TK
#    include <tk.h>
#    include <tclInt.h>
#    undef open		/* These are macros used by Tcl to trap interrupt during */
#    undef read     	/* system calls. Undefine them */
#    undef write
#    define ROOT_WINDOW	"*root*"	/* Scheme name of main window */

     struct Tk_command {
       ClientData ptr;		/* pointer associated to the widget command */
       Tcl_CmdProc *fct;	/* Tk lib function associated to widget */
       struct obj *environment;	/* Environment at command creation */
       char string_result;	/* 1 if this command must return a string */
       char Id[1];		/* must be last field */
     };
#endif 


struct obj {
  short gc_mark;
  short type;
  union {struct {struct obj * car; struct obj * cdr;} 		cons;
	 struct {double data;} 					flonum;
	 struct {char *pname; struct obj * vcell;} 		symbol;
	 struct {char *name; struct obj * (*f)(void);} 		subr0;
	 struct {char *name; struct obj * (*f)(void *,...);} 	subr;
	 struct {struct obj *env; struct obj *code;} 		closure;
	 struct {struct obj *code; }				macro;
	 struct {long dim; char *data;} 			string;
	 struct {long dim; struct obj **data;} 			vector;
	 struct {FILE *f; char *name;} 				port;
	 struct {char *data;} 					keyword;
	 struct {MP_INT *data;}					bignum;
	 struct {short level, position; struct obj *symbol;}	localvar;
	 struct {struct obj *expr; int resultknown; }		promise;
	 struct {void *data; }					cont;
	 struct {struct obj *data;}				env;
	 struct {void *data; }					extension;
#ifdef USE_TK
	 /* Idea of l_data comes from Alexander Taranov <tay@jet.msk.edu> */
	 struct {struct Tk_command *data; struct obj *l_data;}	tk;
#endif
       } storage_as;
};

typedef struct obj* SCM;
typedef struct obj* PRIMITIVE;


#define tc_nil    	0
#define tc_cons   	1
#define tc_flonum 	2
#define tc_integer	3
#define tc_bignum	4
#define tc_symbol 	5
#define tc_keyword	6
#define tc_subr_0 	7
#define tc_subr_1 	8
#define tc_subr_2 	9
#define tc_subr_3 	10
#define tc_subr_0_or_1  11
#define tc_subr_1_or_2  12
#define tc_subr_2_or_3	13
#define tc_lsubr  	14
#define tc_fsubr  	15
#define tc_syntax  	16
#define tc_closure 	17
#define tc_free_cell 	18
#define tc_char	        19
#define tc_string       20
#define tc_vector	21
#define tc_eof		22
#define tc_undefined	23
#define tc_iport       	24
#define tc_oport	25
#define tc_isport	26
#define tc_osport	27
#define tc_boolean	28
#define tc_macro	29
#define tc_localvar	30
#define tc_globalvar	31
#define tc_cont		32
#define tc_env		33
#define tc_address	34
#ifdef USE_TK
#  define tc_tkcommand	50
#endif
#define tc_quote	61
#define tc_lambda	62
#define tc_if		63
#define tc_setq		64
#define tc_cond		65 
#define tc_and		66
#define tc_or		67
#define tc_let		68
#define tc_letstar	69
#define tc_letrec	70
#define tc_begin	71
#define tc_promise	72
#define tc_unbound	80
#define tc_start_extd	90	/* Number of first extended type */
#define tc_stop_extd	127	/* Number of last extended type */


#define CAR(x) 		((*x).storage_as.cons.car)
#define CDR(x) 		((*x).storage_as.cons.cdr)
#define PNAME(x) 	((*x).storage_as.symbol.pname)
#define KEYVAL(x)	((*x).storage_as.keyword.data)
#define VCELL(x) 	((*x).storage_as.symbol.vcell)
#define SUBR0(x) 	(*((*x).storage_as.subr0.f))
#define SUBRF(x) 	(*((*x).storage_as.subr.f))
#define FLONM(x) 	((*x).storage_as.flonum.data)
#define CHARS(x)	((*x).storage_as.string.data)
#define VECT(x)		((*x).storage_as.vector.data)
#define VECTSIZE(x)	((*x).storage_as.vector.dim)
#define BIGNUM(x)	((*x).storage_as.bignum.data)
#define EXTDATA(x)	((*x).storage_as.extension.data)


#ifdef COMPACT_SMALL_CST
#  define MAKE_SMALL_CST(x,type)  (((long) (x) << 8) |((type) << 1) | 1)
#  define SMALL_CST_TYPE(x)	  (((long) (x) >> 1) & 0x7F)
#  define SMALL_CST_VALUE(x)	  ((long)  (x) >> 8)
#  define SMALL_CSTP(x)		  ((long)  (x) & 1)
#  define TYPE(x)		  (SMALL_CSTP(x) ? SMALL_CST_TYPE(x):(x)->type)

#  define INTEGER(x)		  SMALL_CST_VALUE(x)
#  define SET_INTEGER(x, v)	  (x = (SCM) MAKE_SMALL_CST(v, tc_integer))
#  define CHAR(x)		  ((char) SMALL_CST_VALUE(x))
#  define SET_CHARACTER(x, v)	  (x = (SCM) MAKE_SMALL_CST(v, tc_char))
#else
#  define SMALL_CSTP(x)		  FALSE
#  define TYPE(x)		  ((x)->type)

#  define INTEGER(x)		  ((long) ((x)->storage_as.extension.data))
#  define SET_INTEGER(x, v)	  (INTEGER(x) = (v))
#  define CHAR(x)		  ((char) ((x)->storage_as.extension.data)
#  define SET_CHARACTER(x, v)	  (CHAR(x) = (v))
#endif


#define EQ(x,y) 	((x) == (y))
#define NEQ(x,y) 	((x) != (y))
#define NULLP(x) 	EQ(x,NIL)
#define NNULLP(x) 	NEQ(x,NIL)

#define TYPEP(x,y) 	(TYPE(x) == (y))
#define NTYPEP(x,y) 	(TYPE(x) != (y))

#define CONSP(x)   	 TYPEP(x,tc_cons)
#define FLONUMP(x) 	 TYPEP(x,tc_flonum)
#define SYMBOLP(x) 	 TYPEP(x,tc_symbol)
#define KEYWORDP(x)	 TYPEP(x,tc_keyword)
#define STRINGP(x)	 TYPEP(x,tc_string)
#define EOFP(x)		 TYPEP(x, tc_eof)
#define BOOLEANP(x)	 TYPEP(x, tc_boolean)
#define VECTORP(x)	 TYPEP(x,tc_vector)
#define IPORTP(x)	 TYPEP(x,tc_iport)
#define OPORTP(x)	 TYPEP(x,tc_oport)
#define ISPORTP(x)	 TYPEP(x,tc_isport)
#define OSPORTP(x)	 TYPEP(x,tc_osport)
#define INTEGERP(x)	 TYPEP(x,tc_integer)
#define BIGNUMP(x)	 TYPEP(x,tc_bignum)
#define NUMBERP(x)	 (FLONUMP(x) || INTEGERP(x) || BIGNUMP(x))
#define EXACTP(x)	 (INTEGERP(x) || BIGNUMP(x))
#define CHARP(x)	 TYPEP(x,tc_char)
#define PROMISEP(x)	 TYPEP(x,tc_promise)
#define CONTINUATIONP(x) TYPEP(x,tc_cont)
#define ENVP(x)		 TYPEP(x,tc_env)
#define MACROP(x)	 TYPEP(x,tc_macro)
#define EXTENDEDP(x)	 (tc_start_extd<=TYPE(x) && TYPE(x)<extended_type_stamp)


#define NCONSP(x)   	  NTYPEP(x,tc_cons)
#define NFLONUMP(x) 	  NTYPEP(x,tc_flonum)
#define NSYMBOLP(x) 	  NTYPEP(x,tc_symbol)
#define NKEYWORDP(x)	  NTYPEP(x,tc_keyword)
#define NSTRINGP(x)	  NTYPEP(x,tc_string)
#define NEOFP(x)	  NTYPEP(x, tc_eof)
#define NVECTORP(x)	  NTYPEP(x,tc_vector)
#define NIPORTP(x)	  NTYPEP(x,tc_iport)
#define NOPORTP(x)	  NTYPEP(x,tc_oport)
#define NISPORTP(x)	  NTYPEP(x,tc_isport)
#define NOSPORTP(x)	  NTYPEP(x,tc_osport)
#define NINTEGERP(x)	  NTYPEP(x,tc_integer)
#define NBIGNUMP(x)	  NTYPEP(x,tc_bignum)
#define NNUMBERP(x)	  (NFLONUMP(x) && NINTEGERP(x) && NBIGNUMP(x))
#define NEXACTP(x)	  (NINTEGERP(x) && NBIGNUMP(x))
#define NCHARP(x)	  NTYPEP(x,tc_char)
#define NPROMISEP(x)	  NTYPEP(x,tc_promise)
#define NCONTINUATIONP(x) NTYPEP(x,tc_cont)
#define NENVP(x)	  NTYPEP(x,tc_env)
#define NMACROP(x)	  NTYPEP(x,tc_macro)
#define NEXTENDEDP(x)	 (!EXTENDEDP(x))

#ifdef USE_TK
#    define TKCOMMP(x)	  TYPEP(x,tc_tkcommand)
#    define NTKCOMMP(x)	  NTYPEP(x,tc_tkcommand)
#endif


#define ModifyCode()	NEQ(VCELL(sym_debug), truth)

#define Debug(message, obj) {printf("***%s",message); lprint(obj, stdout, 1); printf("\n");}

#define EVAL(x)		  (leval((x), env))
#define EVALCAR(x)	  (SYMBOLP(CAR(x)) ? *varlookup((x),env, 1) : EVAL(CAR(x)))
#define SYNTAX_RETURN(x, need_eval) \
			  { *pform = (x); return (need_eval); }
#define CHANGEVALUE(var, val, env) \
		{if (tk_initialized) Tcl_ChangeValue(PNAME(var))};


#define LIST1(a)		 cons((a), NIL)
#define LIST2(a,b) 		 cons((a), LIST1(b))
#define LIST3(a,b,c)		 cons((a), LIST2((b),(c)))
#define LIST4(a,b,c,d)		 cons((a), LIST3((b),(c),(d)))
#define LIST5(a,b,c,d,e)	 cons((a), LIST4((b),(c),(d),(e)))
#define LIST6(a,b,c,d,e,f)	 cons((a), LIST5((b),(c),(d),(e),(f)))
#define LIST7(a,b,c,d,e,f,g)	 cons((a), LIST6((b),(c),(d),(e),(f),(g)))
#define LIST8(a,b,c,d,e,f,g,h)	 cons((a), LIST7((b),(c),(d),(e),(f),(g),(h)))
#define LIST9(a,b,c,d,e,f,g,h,i) cons((a), LIST8((b),(c),(d),(e),(f),(g),(h),(i)))

#ifdef _DEBUG_MALLOC_INC
#define must_malloc(n)		malloc(n)
#define must_realloc(p, n)	realloc(p, n)
#endif

#include "version.h"
#include "globals.h"
#include "boolean.h"
#include "char.h"
#include "str.h"
#include "vector.h"
#include "gc.h"
#include "number.h"
#include "port.h"
#include "slib.h"
#include "primitives.h"
#include "eval.h"
#include "read.h"
#include "print.h"
#include "slib.h"
#include "list.h"
#include "symbol.h"
#include "env.h"
#include "address.h"
#include "macros.h"
#include "syntax.h"
#include "cont.h"
#include "io.h"
#include "sport.h"
#include "promise.h"
#include "error.h"
#include "proc.h"
#include "keyword.h"
#include "dump.h"
#include "dynload.h"
#include "unix.h" 

#ifdef USE_TK
#    include "tcl-trace.h"
#    include "tk-glue.h"
#    include "tk-util.h"
#    include "tk-main.h"
     extern int background_error;
#endif
