/*
 *
 * n u m b e r . h				-- Numbers management
 *
 *
 * Numbers recognized by the interpreter are:
 *		- integer (which fit in a C long)
 *		- bignum  (arbitrary precision integer)
 *		- flonum  (represented as a C double)
 *
 * Bignum use the GNU gmp API. However to avoid to fall under the GPL terms
 * you can use the FGMP package (FGMP is a public domain implementation of
 * a subset of the GNU gmp library with the same API, written by Mark 
 * Henderson <markh@wimsey.bc.ca>). If your concern is speed, and if the
 * GPL is not a problem for you, use the gmp package. 
 *
 *
 *****
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: 12-May-1993 10:34
 * Last file update:  8-Feb-1994 11:40
 */


#ifdef COMPACT_SMALL_CST
#  define SMALLINT_MAX	(LONG_MAX>>8)
#else
#  define SMALLINT_MAX  LONG_MAX
#endif
#define SMALLINT_MIN	(-SMALLINT_MAX)



char *number2Cstr(SCM n, long base, char buffer[]);
SCM  Cstr2number(char *str, long base);
double do_compare(SCM x, SCM y);

SCM makenumber(double x);
SCM makeinteger(long x);
SCM makebignum(char *s);
long integer_value(SCM x); /* Returns LONG_MIN if not representable as int */


PRIMITIVE numberp(SCM x);
PRIMITIVE integerp(SCM x);
    
PRIMITIVE exactp(SCM x);
PRIMITIVE inexactp(SCM x);

PRIMITIVE numequal(SCM l, SCM env);
PRIMITIVE lessp(SCM l, SCM env);
PRIMITIVE greaterp(SCM l, SCM env);
PRIMITIVE lessep(SCM l, SCM env);
PRIMITIVE greaterep(SCM l, SCM env);

PRIMITIVE zerop(SCM n);
PRIMITIVE positivep(SCM n);
PRIMITIVE negativep(SCM n);
PRIMITIVE oddp(SCM n);
PRIMITIVE evenp(SCM n);

PRIMITIVE lmax(SCM l, SCM env);
PRIMITIVE lmin(SCM l, SCM env);

PRIMITIVE plus(SCM l, SCM env);
PRIMITIVE difference(SCM l, SCM env);
PRIMITIVE ltimes(SCM l, SCM env);
PRIMITIVE division(SCM l, SCM env);

PRIMITIVE labsolute(SCM x);
PRIMITIVE lquotient(SCM n1, SCM n2);
PRIMITIVE lremainder(SCM n1, SCM n2);
PRIMITIVE lmodulo(SCM n1, SCM n2);

PRIMITIVE lgcd(SCM l, SCM env);
PRIMITIVE llcm(SCM l, SCM env);

PRIMITIVE lfloor(SCM x);
PRIMITIVE lceiling(SCM x);
PRIMITIVE ltruncate(SCM x);
PRIMITIVE lround(SCM x);

PRIMITIVE lexp(SCM z);
PRIMITIVE llog(SCM z);
PRIMITIVE lsin(SCM z);
PRIMITIVE lcos(SCM z);
PRIMITIVE ltan(SCM z);
PRIMITIVE lasin(SCM z);
PRIMITIVE lacos(SCM z);
PRIMITIVE latan(SCM y, SCM x);
PRIMITIVE lsqrt(SCM z);
PRIMITIVE lexpt(SCM z1, SCM z2);

PRIMITIVE exact2inexact(SCM z);
PRIMITIVE inexact2exact(SCM z);
PRIMITIVE string2number(SCM str, SCM base);
PRIMITIVE number2string(SCM n, SCM base);
