/*
 * m a c r o s . c			-- Simple statically scoped macros
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: ??-Oct-1993 ??:?? 
 * Last file update: 22-Nov-1993 10:37
 *
 */


#include "stk.h"

PRIMITIVE lmacro(SCM args, SCM env)
{
  SCM z;
  
  if (llength(args) != 2) err("macro: Bad parameter list", args);

  NEWCELL(z, tc_macro);
  z->storage_as.macro.code = EVAL(cons(sym_lambda, args));
  return z;
}

PRIMITIVE macro_expand(SCM form, SCM env)
{
  SCM tmp;

  if (llength(form) != 1) err("macro-expand: bad number of parameters", form);
  form = EVAL(CAR(form));

  if (CONSP(form))
    if (SYMBOLP(CAR(form)) && MACROP(tmp = *varlookup(CAR(form), env, FALSE)))
      return apply(tmp->storage_as.macro.code, form);
  return form;
}

PRIMITIVE macro_body(SCM form)
{
  if (NMACROP(form)) err("macro-body: bad macro", form);
  return cons(intern("macro"), CDR(form->storage_as.macro.code));
}

PRIMITIVE macrop(SCM obj)
{
  return MACROP(obj)? truth: ntruth;
}

