/*
 *
 * e r r o r . c 			-- The error procedure
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 14-Nov-1993 14:58
 * Last file update:  2-Jun-1994 12:53
 */

#include "stk.h"

extern int nointerrupt;

static jmp_buf global_jmp_buf; 		/* Jump buffer denoting toplevel context */
jmp_buf *top_jmp_buf = &global_jmp_buf;

long error_context = ERR_FATAL;


void err(char *message, SCM x)
{
  SCM tmp;
  static int err_counter=0; /* to avoid loops when report-error proc is buggy */
  char *head;

  err_counter += 1;
  if (!(error_context & ERR_IGNORED)) {
    /* Error is not ignored: A message must be printed */
    if (*message) {
      switch (error_context) {
        case ERR_READ_FROM_STRING: head = "*** Read from string error:\n"; break;
        case ERR_FATAL: 	
	case ERR_OK:	           head = "*** Error:\n"; break;
#ifdef USE_TK
	case ERR_TK_BACKGROUND:    head = "*** Tk background error:\n"; break;
#endif
      }

      tmp = intern("report-error");
      if (symbol_boundp(tmp, globenv)==truth && err_counter == 1 && *message) {
	apply(leval(tmp, NIL), cons(makestrg(strlen(head), head),
				    cons(makestrg(strlen(message), message),
					 cons(luncode(x), NIL))));
      }
      else {
	if (err_counter>1) fprintf(stderr, "WARNING: report-error is buggy!!\n");
	fprintf(stderr, "\n%s    %s", head, message);
	if (NNULLP(x)) 
	  {fprintf(stderr, ": "); lprint(luncode(x), stderr, WRT_MODE);}
	show_eval_stack(5);
      }
    }
  }

  reset_eval_stack();
  /* 
   * Do all the terminal thunk of dynamic winds and make a long jump to
   * location retained in top_jmp_buf 
   */
  err_counter = 0;
  lunwind_all();

  switch (error_context) {
    case ERR_FATAL: 
      fprintf(stderr, "FATAL ERROR IN CRITICAL CODE SECTION. ABANDON\n");
      exit(1);
    default:
      longjmp(*top_jmp_buf, JMP_ERROR);
  }
}
