/**
 *
 * env.c			-- Environment management
 *
 **/ 

#include "stk.h"

static void makelocalvar(SCM x, int level, int position)
{
  if (ModifyCode() && CONSP(x)) { /* Replace (CAR x) by a localvar access */
    SCM z;
    NEWCELL(z, tc_localvar);
    z->storage_as.localvar.position = position;
    z->storage_as.localvar.level    = level;
    z->storage_as.localvar.symbol   = CAR(x);
    CAR(x) = z;
  }
}

static void makeglobalvar(SCM x)
{
  if (ModifyCode() && CONSP(x)) { /* Replace (CAR x) by a globalvar access */
    SCM z;
    NEWCELL(z, tc_globalvar);
    VCELL(z) = CAR(x);
    CAR(x) = z;
  }
}

SCM makeenv(SCM l)
{
  SCM z;
  NEWCELL(z, tc_env);
  z->storage_as.env.data = l;
  return z;
}


SCM intern(char *name)
{
  SCM l, sym, sl;
  register char *s1, *s2;
  long hash= 0, c, flag;
  
  flag = no_interrupt(1);
  for(s1=name; c=*s1; s1++)
    hash = ((hash * 17) ^ c) % OBARRAY_SIZE;
  
  for(l=sl=obarray[hash]; NNULLP(l); l=CDR(l)) {
    for (s1=name, s2=PNAME(CAR(l)); *s1 == *s2; s1++, s2++) {
      if (*s1 ==0) {
	no_interrupt(flag);
	return(CAR(l));
      }
    }
  }
  NEWCELL(sym, tc_symbol);
  PNAME(sym) = strcpy((char *) must_malloc(strlen(name)+1), name);
  VCELL(sym) = UNBOUND;
  obarray[hash] = cons(sym, sl);

  no_interrupt(flag);
  return(sym);
}

SCM *varlookup(SCM x, SCM env, int err_if_unbound)
{
  SCM frame, fl, *al, var = CONSP(x)? CAR(x) : x;
  int level, pos;

  /* Try to find var in env */ 
  for(level=0, frame=env; CONSP(frame); frame=CDR(frame), level++) {
    al = &CAR(frame);

    for (pos=0, fl=CAR(CAR(frame)); NNULLP(fl); fl=CDR(fl), pos++) {
      if (NCONSP(fl)) {
	if (EQ(fl, var)) { makelocalvar(x, level, pos); return &CDR(*al); }
	else break;
      }
      al = &CDR(*al);
      if EQ(CAR(fl), var) { makelocalvar(x, level, pos); return &CAR(*al); }
    }
  }
  /* Not found. Return it's value in global environment */
  if (err_if_unbound && VCELL(var) == UNBOUND) 
    err("unbound variable", var);

  makeglobalvar(x);
  return &VCELL(var);
}

SCM localvalue(SCM var, SCM env)
{
  register SCM p, q;
  register int i;

  p = env;
  /* Go down ``level'' environments */
  for (i = var->storage_as.localvar.level; i; i--)
    p = CDR(p);
  
  /* Go forward ``position'' variables */
  q = CAR(CAR(p)); p = CDR(CAR(p)); 
  for (i = var->storage_as.localvar.position; i; i--) {
    p = CDR(p);
    q = CDR(q);
  }
  return CONSP(q) ? CAR(p) : p;
}

SCM extend_env(SCM formals, SCM actuals, SCM env, SCM who)
{
  register SCM f = formals, a = actuals;

  for ( ; NNULLP(f); f=CDR(f), a=CDR(a)) {
    if (NCONSP(f)) goto Out;
    if (NULLP(a)) err("too few arguments to", who);
  }
  if (NNULLP(a)) err("too many arguments to", who);
 Out:
  return fast_extend_env(formals, actuals, env);
}


PRIMITIVE symbol_boundp(SCM x, SCM env)
{
  SCM tmp;

  if (NSYMBOLP(x)) err("symbol-bound?: not a symbol", x);
  if (env == UNBOUND) env = makeenv(NIL);
  else 
    if (NENVP(env)) err("symbol-bound?: bad environment", env);

  tmp = *varlookup(x, env->storage_as.env.data, FALSE);
  return (tmp == UNBOUND) ? ntruth : truth;
}

PRIMITIVE the_environment(SCM args, SCM env)
{
  if (NNULLP(args)) err("the-environement: Too much parameters", args);
  return makeenv(env);
}

PRIMITIVE global_environment(void)
{
  return makeenv(NIL);
}

static SCM local_env2list(SCM l)
{
  register SCM res=NIL, l1, l2;
  
  for (l1=CAR(l), l2=CDR(l); NNULLP(l1); l1=CDR(l1), l2=CDR(l2))
    res = cons(cons(CAR(l1), CAR(l2)), res);
  return res;
}

static SCM global_env2list(void)
{
  SCM l, res = NIL;
  int i;

  for (i=0; i < OBARRAY_SIZE; i++)
    for (l=obarray[i]; NNULLP(l); l=CDR(l))
      res = cons(cons(CAR(l), VCELL(CAR(l))), res);
  return res;
}

PRIMITIVE environment2list(SCM env)
{
  SCM l, res = NIL;

  if (NENVP(env)) err("environment->list: bad environment", env);

  for (l= env->storage_as.env.data; NNULLP(l); l=CDR(l))
    res = cons(local_env2list(CAR(l)), res);
  
  res = cons(global_env2list(), res);
  return reverse(res);
}


PRIMITIVE environmentp(SCM obj)
{
  return ENVP(obj)? truth: ntruth;
}

