/*
 *
 * d y n l o a d . c			-- All the stuff dealing with 
 *					   dynamic loading
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: 23-Jan-1994 19:09
 * Last file update:  5-Mar-1994 13:26
 */

#ifdef SUNOS4
#include <dlfcn.h>
#endif
#include "stk.h"


#define EXT_TYPE_DESCR(x)	(xtypes[TYPE(x)- tc_start_extd])

static extended_scheme_type *xtypes[tc_stop_extd-tc_start_extd+1];
int extended_type_stamp = tc_start_extd;


/****
 * 
 * Default procedures 
 *
 ****/

static void internal_display(SCM obj, FILE *f, int mode)
{
  sprintf(tkbuffer, "#<%s %lx>", (EXT_TYPE_DESCR(obj))->type_name, 
	  			 (unsigned long) obj);
  Puts(tkbuffer, f);
}

static SCM internal_apply(SCM obj, SCM args, SCM env)
{
  err("apply: bad procedure", obj);
  return UNDEFINED; /* to make the compiler happy */
}

/****
 *
 * User interface
 *
 ****/

int add_new_type(extended_scheme_type *p)		       
{
  if (!p) err("bad new type description", NIL);
  

  /* Set the apply procedure if not defined */
  if (!p->apply_fct) p->apply_fct = internal_apply;

  /* Replace NULL display function by a default function */
  if (!p->display_fct) p->display_fct = internal_display;

  /* Store the new type descriptor in the xtypes array */
  xtypes[extended_type_stamp - tc_start_extd] = p;

  return extended_type_stamp++;
}

void add_new_primitive(char *fct_name, int fct_type, void *fct_ptr)
{
  SCM z;

  NEWCELL(z, fct_type);
  z->storage_as.subr.name = fct_name;
  z->storage_as.subr.f    = fct_ptr;
  VCELL(intern(fct_name)) = z;
}

void set_global_var(char *name, SCM value)
{
  VCELL(intern(name)) = value;
}


SCM STk_eval_string(char *s, SCM env)
{
  SCM tmp = internal_eval_string(s, ERR_OK, env);
  return tmp == EVAL_ERROR ? NULL: tmp;
}



/******************************************************************************/


#if defined(SUNOS4) || defined(SUNOS5)

/* Following code works on SunOS 4/5. But it require to use dynamic loading,
 * which in turn can not be used with dump.....
 *
 * Following code should also work on OSF-1. But I can't test it myself 
 */

static void load_and_call(char *path, char *fct_name)
{
  void *handle;
  void (*init_fct)();
 
  if ((handle = dlopen(path, 1)) == NULL) 
    err("Cannot open file", makestrg(strlen(path), path));
  
  if ((init_fct = dlsym(handle, fct_name)) == NULL) {
    char msg[MAX_PATH_LENGTH];
    
    sprintf(msg, "Cannot find function %s in object file", fct_name);
    err(msg, NIL);
  }
  /* Call the init code */
  (*init_fct)();
}

void load_object_file(char *path)
{
  char fct_name[MAX_PATH_LENGTH], *p, *slash, *dot;

  /* Load the file as an object one */

  for (p = path, slash = p-1; *p; p++)		/* Find position of last '/' */
    if (*p == '/') slash = p;

  sprintf(fct_name, "init_%s", slash + 1);

  for (p = fct_name; *p; p++)			/* Delete suffix it it exists */
      if (*p == '.') { *p = '\0'; break; }

  load_and_call(path, fct_name);
}

#else
void load_object_file(char *path)
{
  err("load: Loading of object file is not defined on this architecture", NIL);
}
#endif


/******************************************************************************/
  
void extended_mark(SCM x)
{
  extended_scheme_type *p= EXT_TYPE_DESCR(x);
  if (p->gc_mark_fct) (*(p->gc_mark_fct))(x);
}

void extended_sweep(SCM x)
{
  extended_scheme_type *p = EXT_TYPE_DESCR(x);
  if (p->gc_sweep_fct) (*(p->gc_sweep_fct))(x);
}


SCM extended_apply(SCM x, SCM args, SCM env)
{
  return (*(EXT_TYPE_DESCR(x)->apply_fct))(x, args, env);
}


void extended_display(SCM x, FILE *f, int mode)
{
  (*(EXT_TYPE_DESCR(x)->display_fct))(x, f, mode);
}

SCM extended_procedurep(SCM x)
{
  return (EXT_TYPE_DESCR(x)->flags && EXT_ISPROC) ? truth: ntruth;
}

SCM extended_eval_parameters(SCM x)
{
  return (EXT_TYPE_DESCR(x)->flags && EXT_EVALPARAM) ? truth: ntruth;
}
