;;; Copyright (C) 1988, Barak Pearlmutter & Kevin Lang, CMU Oaklisp Project.

(herald start (env t))

(load 'files)

(define (make-makefile name)
  (with-open-streams ((outfile (open (->filename name) '(out))))

    (let* ((aller (lambda (x) (format outfile " ~A.oa"
				      (string-downcase (symbol->string x)))))
	   (aller1 (lambda (x) (if (not (memq x between-files)) (aller x)))))

      (format outfile "

# NOTE: This makefile is automatically generated from make-makefile.t,
# and should not normally be edited by hand.  New makefiles are
# generated with 'make Makefile'.")

      (format outfile "~%~%OAFILES =")
      (walk aller between-files)
      (walk aller1 all-the-layers)

      (format outfile "~%~%MISCFILES =")
      (walk aller misc-files)

      (format outfile "~%~%COMPFILES =")
      (walk aller compiler-files)

      (format outfile "~%~%BATFILE =")
      (walk aller batch-compiler-file)

      (format outfile "

# The following is a trick to deal with the endianity problem.
# Bigendian machines need binary oaklisp worlds with extension .ol*
# while littleendian ones need .lo*.

# If on a system without the fancy CMU mods to make, just change the
# line 'E = ...' to 'E = ol' or 'E = lo', as appropriate.

VAX_EXT		= lo
PMAX_EXT	= lo
PDP11_EXT	= lo
SUN_EXT		= ol
SUN4_EXT	= ol
IBMRT_EXT	= ol
CONVEX_EXT	= ol
MMAX_EXT	= lo

E = ${$(MACHINE)_EXT}

# T object file extensions

VAX_TOBJ	= vo
SUN_TOBJ	= mo
SUN4_TOBJ	= so
PMAX_TOBJ	= po
T = ${$(MACHINE)_TOBJ}


all: Makefile new.$Ez new.$Es

# Make correct_endian_worlds when bringing up a release distributed
# with only a bigendian world on a littleendian machine.

correct_endian_worlds: ../lib/oaklisp.$Ez ../lib/oaklisp.$Es

# Explain how to make oaklisp object files:
.SUFFIXES: .oa .oak

.oak.oa:
	oakliszt $*

# Get the compiler sources compiled in the correct locale:
$(COMPFILES) $(BATFILE): $$@k
	oakliszt $* compiler-locale

# Explain how to make T object files:
.SUFFIXES: .$T .t

.t.$T:
	echo \"(block (compile-file '$*)(exit 0))(exit 1)\"|t

# Explain how to boot cold worlds into warm worlds:
.SUFFIXES: .$E .cold

.cold.$E:
	rm -f $*.$E
	../etc/emulator -d -b -f $*.$E -G $*.cold

# Explain how to load misc stuff into warm worlds:
.SUFFIXES: .$Em .$E

.$E.$Em:
	../etc/fliw $*.$E $*.$Em system-locale $(MISCFILES)

%.$Em       : %.$E       $(MISCFILES)

# Explain how to load the compiler into misc worlds:
.SUFFIXES: .$Ec .$Em

.$Em.$Ec:
	../etc/fliw $*.$Em $*.$Ec compiler-locale $(COMPFILES)

%.$Ec       : %.$Em       $(COMPFILES)

# Explain how to load the batch compiler into worlds with the compiler in 'em:
.SUFFIXES: .$Ez .$Ec

.$Ec.$Ez:
	../etc/fliw $*.$Ec $*.$Ez compiler-locale $(BATFILE)

%.$Ez       : %.$Ec       $(BATFILE)



SCHEMEOA = scheme-upgrade.oa scheme.oa scheme-macros.oa

# Explain how to load the scheme compatibility package:
.SUFFIXES: .$Es .$Ec

.$Ec.$Es:
	../etc/fliw $*.$Ec $*.$Es system-locale scheme-upgrade

%.$Es       : %.$Ec       $(SCHEMEOA)
new.$Es     : new.$Ec     $(SCHEMEOA)
oaklisp.$Es : oaklisp.$Ec $(SCHEMEOA)





oafiles: $(OAFILES)

# How to build a new cold world using the linker:

new.cold: oafiles files.$T build-world.$T ../linker/tool.$T
	rm -f new.cold new.sym
	echo \"(block (load 'build-world)(build-world 'new)(exit 0))(exit 1)\"|t
	echo ''


# How to rebuild this makefile:

Makefile: make-makefile.$T files.$T
	echo \"(block (load 'make-makefile)(make-makefile\" '\"'Makefile'\"'\")(exit 0))(exit 1)\"|t
	echo Makefile modified -- redo the make
	false


# Delete all the crap:

clean-oa-files:
	rm -f $(OAFILES) $(COMPFILES) $(MISCFILES) $(BATFILE)


# What goes in an official release:

COMPOA = $(COMPFILES) $(BATFILE)
TFILES = build-world.t files.t make-makefile.t
BENCHMARKS = tak.oak compile-bench.oak
MISCOTHERS = $(TFILES) $(BENCHMARKS) Makefile

release:
	../etc/rel-source ../$(RELEASEDIR)/mac \\
		$(OAFILES) $(COMPOA) $(SCHEMEOA) $(MISCFILES)
	copy -l $(MISCOTHERS) $(COMPOA) $(SCHEMEOA) ../$(RELEASEDIR)/mac

min-release:
	copy -l $(BENCHMARKS) oaklisp.$Ec oaklisp.$Ez oaklisp.$Es ../$(RELEASEDIR)/mac

#eof~%")))
  name)
