/*  Copyright (C) 1987 Barak Pearlmutter and Kevin Lang    */

/* This file contains the garbage collector. */

#include "emulator.h"



#define OLD_PTR(r) (old_space<=(r) && (r)<end_of_old_space)
#define NEW_PTR(r) (new_space<=(r) && (r)<end_of_new_space)


#define gc_touch(r) ( (r)&2 ? gc_touch0((r)) : (r) )
#define GC_TOUCH(x) ((x)=gc_touch((x)))
#define GC_TOUCH_PTR(r,o) ((r)=REF_TO_PTR(gc_touch0(PTR_TO_REF((r)-(o))))+(o))

#define loc_touch(r,w) ( TAG_IS((r),LOC_TAG) ? loc_touch0((r),(w)) : (r) )
#define LOC_TOUCH(x) ((x)=loc_touch((x),0))



ref *new_space, *free_point, *end_of_new_space;
unsigned long new_space_size;


ref *old_space, *end_of_old_space;

unsigned long transport_count;
unsigned long loc_transport_count;
unsigned long wp_discard_count;


ref pre_gc_nil;






extern void post_gc_wp();


void gc_printref(refin)
     ref refin;
{
  ref theref = refin;
  char suffex = '?';

  if (theref&2)
    {
      if (OLD_PTR(REF_TO_PTR(theref)))
	{
	  theref -= (ref)old_space;
	  suffex = 'o';
	}
      else if (NEW_PTR(REF_TO_PTR(theref)))
	{
	  theref -= (ref)new_space;
	  suffex = 'n';
	}
      (void)printf("%ld~%ld%c", theref>>2, theref&3, suffex);
    }
  else
    (void)printf("%ld~%ld", theref>>2, theref&3);
}      



#ifndef FAST

/* Check if r is e_nil, even if in the middle of a gc. */
bool GC_NULL(r)
     ref r;
{
  return r == e_nil || r == pre_gc_nil;
}

#else

#define GC_NULL(r) ((r)==e_nil || (r)==pre_gc_nil)

#endif /* FAST */





/* This variant of get_length has to follow forwarding pointers so
   that it will work in the middle of a gc, when an object's type might
   already have been transported. */

unsigned long gc_get_length(x)
     ref x;
{
  if TAG_IS(x,PTR_TAG)
    {
      ref len;
      ref vlen_p;
      
      vlen_p = *(REF_TO_PTR(*REF_TO_PTR(x)) + TYPE_VAR_LEN_P_OFF);
      /* Check if forwarded... */
      if (TAG_IS(vlen_p,LOC_TAG)) 
	vlen_p = *LOC_TO_PTR(vlen_p);

      if (GC_NULL(vlen_p))
	{
	  /* Not variable length. */
	  len = *(REF_TO_PTR(*REF_TO_PTR(x)) + TYPE_LEN_OFF);

	  /* Check if length is forwarded... */
	  if (TAG_IS(len,LOC_TAG)) 
	    len = *LOC_TO_PTR(len);
	  
	  return REF_TO_INT(len);
	}
      else
	return REF_TO_INT(*(REF_TO_PTR(x) + 1));
    }
  else
    return 0;
}











ref gc_touch0(r)
     ref r;
{
  ref *p = REF_TO_PTR(r);

  if (OLD_PTR(p))

    if (r&1)
      {
	ref type_slot = *p;
	if (TAG_IS(type_slot,LOC_TAG))
	  {
	    /* Already been transported. */
	    return(PTR_TO_REF(LOC_TO_PTR(type_slot)));
	  }
	else
	  {
	    /* Transport it */
	    long i;
	    long len = gc_get_length(r);
	    ref *new_place = free_point;
	    ref *p0 = p;
	    ref *q0 = new_place;

	    transport_count += 1;

	    /*
	      printf("About to transport ");
	      gc_printref(r);
	      printf(" len = %ld.\n", len);
	      */

	    free_point += len;

	    for (i=0; i<len; i++, p0++, q0++)
	      {
		*q0 = *p0;
		*p0 = PTR_TO_LOC(q0);
	      }

	    return(PTR_TO_REF(new_place));
	  }
      }
    else
      {
	/* Follow the chain of locatives to oldspace until we find a
	   real object or a circularity. */
	ref r0 = r;
	ref r1 = *p;
	/* int chain_len = 1; */

	while (TAG_IS(r1,LOC_TAG) && OLD_PTR(LOC_TO_PTR(r1)))
	  {
	    if (r0==r1)
	      {
		/* printf("Circular locative chain.\n"); */
		goto forwarded_loc;
	      }
	    r0 = *LOC_TO_PTR(r0);
	    r1 = *LOC_TO_PTR(r1);
	    /* chain_len++; */
		
	    if (r0==r1)
	      {
		/* printf("Circular locative chain.\n"); */
		goto forwarded_loc;
	      }
	    if (!TAG_IS(r1,LOC_TAG) || !OLD_PTR(LOC_TO_PTR(r1)))
	      break;

	    r1 = *LOC_TO_PTR(r1);
	    /* chain_len++; */
	  }

	/* We're on an object, so touch it. */
	/* 
	  printf("Locative chain followed to ");
	  gc_printref(r1);
	  printf(" requiring %d dereferences.\n", chain_len);
	  */
	(void)gc_touch(r1);

	/* Now see if we're looking at a forwarding pointer. */
      forwarded_loc:
	r1 = *p;
	if (TAG_IS(r1,LOC_TAG) && NEW_PTR(LOC_TO_PTR(r1)))
	  return(r1);		/* return(*LOC_TO_PTR(r1)); */
	else
	  return(r);
      }
  else
    return(r);
}





ref loc_touch0(r, warn_if_unmoved)
     ref r;
     bool warn_if_unmoved;
{
  ref *p = LOC_TO_PTR(r);

  if (OLD_PTR(p))
    {
      /* A locative into old space.  See if it's been transported yet. */
      ref r1 = *p;
      if (TAG_IS(r1,LOC_TAG) && NEW_PTR(LOC_TO_PTR(r1)))
	{
	  /* Already been transported. */
	  return(r1);
	}
      else
	{
	  /* Better transport this lonely cell. */

	  ref *new_place = free_point++; /* make a new cell. */
	  ref new_r = PTR_TO_LOC(new_place);
	      
	  *p = new_r;		/* record the transportation. */

	  /* put the right value in the new cell. */
	  *new_place =
	    TAG_IS(r1,PTR_TAG)
	      ? PTR_TO_REF(REF_TO_PTR(*REF_TO_PTR(r1)))
		: r1;

	  loc_transport_count += 1;

	  if (warn_if_unmoved)
	    {
	      printf("Warning: the locative ");
	      gc_printref(r);
	      printf(" has just had its raw cell moved.\n");
	    }

	  return(new_r);
	}
    }
  else
    return(r);			/* Not a locative into old space. */
}




void scavenge()
{
  ref *scavenge_p = new_space;

  while (scavenge_p != free_point)
    {
      GC_TOUCH(*scavenge_p);
      scavenge_p += 1;
    }
}




void loc_scavenge()
{
  ref *scavenge_p = new_space;

  while (scavenge_p != free_point)
    {
      LOC_TOUCH(*scavenge_p);
      scavenge_p += 1;
    }
}




/* True if r seems like a messed up reference. */
bool gc_check(r)
     ref r;
{
  return (r&2) && !NEW_PTR(REF_TO_PTR(r));
}






#define GGC_CHECK(r) GC_CHECK(r,"r")





void GC_CHECK(x,st)
  ref x;
  char st[];
{
  if (gc_check((x)))
    {
      printf("%s = ", (st));
      gc_printref((x));
      if (OLD_PTR(REF_TO_PTR(x)))
	{
	  printf(",  cell contains ");
	  gc_printref(*REF_TO_PTR(x));
	}
      printf("\n");
    }
}





void GC_CHECK1(x,st,i)
     ref x;
     char st[];
     long i;
{
  if (gc_check((x)))
    {
      printf((st), (i));
      gc_printref((x));
      if (OLD_PTR(REF_TO_PTR(x)))
	{
	  printf(",  cell contains ");
	  gc_printref(*REF_TO_PTR(x));
	}
      printf("\n");
    }
}







unsigned short *pc_touch(o_pc)
     unsigned short *o_pc;
{
  long lowbits = (unsigned long)o_pc & 3;
  ref *pcell = (ref *)( (unsigned long)o_pc & ~3 );

  return
    (unsigned short *)
      (lowbits | (long)REF_TO_PTR(loc_touch(PTR_TO_LOC(pcell),1)));
}
  







/* Returns the new PC. */
unsigned short *gc(val_stk, cxt_stk, val_stk_start, e_pc, pre_dump)
     ref *val_stk, *cxt_stk, *val_stk_start;
     unsigned short *e_pc;	/* The old pc; must be passed in. */
     bool pre_dump;		/* Zero unless about to dump world. */
{
  long old_taken;
  ref *p;

  /* Flip. */
  printf("; About to flip...\n");
  old_space = new_space;
  end_of_old_space = free_point; /* end_of_new_space */
  old_taken = end_of_old_space - old_space;

  /* create newspace */
  new_space = (ref *)my_malloc( sizeof(ref)*new_space_size );
  free_point = new_space;
  end_of_new_space = new_space + new_space_size;



  transport_count = 0;


  /* touch all the rooted guys. */


  /* Hit all the registers. */
  printf("; Rooting...\n");
  pre_gc_nil = e_nil;

  if (pre_dump==0)
    {
      GC_TOUCH(e_t);
      GC_TOUCH(e_nil);
      GC_TOUCH(e_fixnum_type);
      GC_TOUCH(e_loc_type);
      GC_TOUCH(e_cons_type);
      GC_TOUCH_PTR(e_subtype_table,2);
      /* e_bp is a locative, but a pointer to the object should exist, so we
	 need only touch it in the locative pass. */
      GC_TOUCH_PTR(e_env,0);
      /* e_nargs is a fixnum. */
      GC_TOUCH(e_env_type);
      GC_TOUCH_PTR(e_argless_tag_trap_table,2);
      GC_TOUCH_PTR(e_arged_tag_trap_table,2);
      GC_TOUCH(e_object_type);
      GC_TOUCH(e_boot_code);

      /* Scan the stacks. */
      for (p=val_stk_start+1; p<=val_stk; p++)
	GC_TOUCH(*p);

      for (p=cxt_stk_start+1; p<=cxt_stk; )
	{
	  p++;			/* ignore PC */
	  p++;			/* ignore BP */
	  /* hack ENV */
	  {
	    ref **q = (ref **)p;

	    *q = REF_TO_PTR(gc_touch(PTR_TO_REF(*q)));
	  }
	  /*
	   *p = (ref)REF_TO_PTR(gc_touch(PTR_TO_REF((ref *)*p)));
	   */
	  p++;
	}
    }
  else
    {
      /* This is only needed to keep the registers consistent. */
      GC_TOUCH(e_nil);
      GC_TOUCH(e_boot_code);
    }
  

  
  /* Scavenge. */
  printf("; Scavenging...\n");
  scavenge();

  printf("; %ld objects transported.\n", transport_count);



  /* Clean up the locatives. */
  printf("; Scanning locatives...\n");
  loc_transport_count = 0;
  
  if (pre_dump == 0)
    {
      e_bp = LOC_TO_PTR(loc_touch(PTR_TO_LOC(e_bp),1));
      e_pc = pc_touch(e_pc);

      for (p=val_stk_start+1; p<=val_stk; p++)
	LOC_TOUCH(*p);


      for (p=cxt_stk_start+1; p<=cxt_stk; )
	{
	  /* hack PC */
	  {
	    unsigned short **q = (unsigned short **)p;
	    *q = pc_touch(*q);
	  }
	  p++;

	  /* hack BP */
	  *p = (ref)LOC_TO_PTR(loc_touch(PTR_TO_LOC((ref *)*p), 1));
	  p++;

	  /* ignore ENV */
	  p++;
	}
    }
  
  
  printf("; Scavenging locatives...\n");
  loc_scavenge();

  printf("; %ld naked cells transported.\n", loc_transport_count);



  /* Discard weak pointers whose targets have not been transported. */
  printf("; Scanning weak pointer table...\n");
  wp_discard_count = 0;
  post_gc_wp();
  printf("; %ld weak pointer table entries discarded.\n", wp_discard_count);





#ifndef FAST
  /* Check GC consistency. */

  printf("; Checking consistency...\n");
  if (pre_dump == 0)
    {
      GGC_CHECK(e_t);
      GGC_CHECK(e_nil);
      GGC_CHECK(e_fixnum_type);
      GGC_CHECK(e_loc_type);
      GGC_CHECK(e_cons_type);
      GC_CHECK(PTR_TO_REF(e_subtype_table-2),"e_subtype_table");
      GC_CHECK(PTR_TO_LOC(e_bp),"PTR_TO_LOC(e_bp)");
      GC_CHECK(PTR_TO_REF(e_env),"e_env");
      /* e_nargs is a fixnum. */
      GGC_CHECK(e_env_type);
      GC_CHECK(PTR_TO_REF(e_argless_tag_trap_table-2),"e_argless_tag_trap_table");
      GC_CHECK(PTR_TO_REF(e_arged_tag_trap_table-2),"e_arged_tag_trap_table");
      GGC_CHECK(e_object_type);
      GGC_CHECK(e_boot_code);

      /* Scan the stacks. */
      for (p=val_stk_start+1; p<=val_stk; p++)
	GC_CHECK1(*p,"val_stk[%ld] = ",p-val_stk_start);

      for (p=cxt_stk_start+1; p<=cxt_stk; )
	{
	  /* PC */
	  GC_CHECK1((ref)((*p&~3)|LOC_TAG),"PC: cxt_stk[%ld] = ",p-cxt_stk_start);
	  p++;
	  /* BP */
	  GC_CHECK1(PTR_TO_LOC(*p),"BP: cxt_stk[%ld] = ",p-cxt_stk_start);
	  p++;
	  /* ENV */
	  GC_CHECK1(PTR_TO_REF(*p),"ENV: cxt_stk[%ld] = ",p-cxt_stk_start);
	  p++;
	}
    }
  else
    GGC_CHECK(e_boot_code);

  /* Scan the heap. */

  for (p = new_space; p<free_point; p++)
    GC_CHECK1(*p,"new_space[%ld] = ",p-new_space);

#endif /* FAST */




  /* There are no more live references into old space. */
  printf("; GC done.  %ld words compacted into %ld.\n",
	 old_taken, free_point - new_space);
  free((char *)old_space);
  return e_pc;
}






/* Weak pointers are done with a simple table that goes from weak pointers
   to objects, and a hash table that goes from objects to weak pointers.
   */

/* NOTE this has to be completely rewritten! */

#define WP_TABLE_SIZE 6000

ref wp_table[WP_TABLE_SIZE];

long wp_index = 0;


ref ref_to_wp(r)
     ref r;
{
  /* For now (while still testing) linearly scan the table.  (!) */
  long i;

  for (i=0; i<wp_index; i++)
    if (wp_table[i] == r)
      return( INT_TO_WP(i) );

  wp_table[wp_index++] = r;
  return( INT_TO_WP(wp_index-1) );
}

void post_gc_wp()
{
  /* Scan the weak pointer table.  When a reference to old space is found,
     check if the location has a forwarding pointer.  If not, discard the
     reference; if so, update it. */
  long i;

  for (i=0; i<wp_index; i++)
    {
      ref r = wp_table[i];

      if ( (r&0x2) && OLD_PTR(REF_TO_PTR(r)) )
	{
	  ref r1 = *REF_TO_PTR(r);

	  if (TAG_IS(r1,LOC_TAG) && NEW_PTR(LOC_TO_PTR(r1)))
	    {
	      wp_table[i] = TAG_IS(r,LOC_TAG) ? r1 : r1|PTR_TAG;
	    }
	  else
	    {
	      wp_discard_count += 1;
	      wp_table[i] = e_nil;
	    }
	}
    }
}
