
/* The include file for machine dependent parameters and #definitions used */
/* in the Oaklisp system. */

/*  Copyright (C) 1987 Barak Pearlmutter and Kevin Lang    */


extern char *malloc();


/* Try to figure out the endianity. */

#if ('A\0' == 0x41)
#ifndef vax /* cpp on a vax thinks big endian! */
#define BIG_ENDIAN
#endif /* vax */
#endif

#define DEFAULT_NEW_SPACE_SIZE (128 * 1024) /* measured in words */

#define READ_MODE "r"
#define WRITE_MODE "w"
#define APPEND_MODE "a"




#ifdef Mac

#define READ_BINARY_MODE "r+b"
#define WRITE_BINARY_MODE "w+b"

#else

#define READ_BINARY_MODE READ_MODE
#define WRITE_BINARY_MODE WRITE_MODE

#endif




#ifndef NULL
#define NULL 0L
#endif


typedef int bool;

#define FALSE 0
#define TRUE 1



typedef unsigned long int ref;


#define TAG_MASK 3
#define SUBTAG_MASK 0xFF

#define INT_TAG 0
#define IMM_TAG 1
#define LOC_TAG 2
#define PTR_TAG 3

#define CHAR_SUBTAG		((0*4)+IMM_TAG)
#define WP_SUBTAG		((1*4)+IMM_TAG)

#define TAG_IS(X,TAG) (((X)&TAG_MASK)==(TAG))
#define SUBTAG_IS(X,SUBTAG) (((X)&SUBTAG_MASK)==(SUBTAG))

#define INT_TO_REF(i) ((ref)((i)<<2))
#define REF_TO_INT(r) ASHR2((long)(r))

#define REF_TO_PTR(r) ((ref *)((r)&~TAG_MASK))
#define LOC_TO_PTR(r) REF_TO_PTR(r)
#define PTR_TO_LOC(p) ((ref)((ref)(p) | LOC_TAG))
#define PTR_TO_REF(p) ((ref)((ref)(p) | PTR_TAG))

#define REF_TO_CHAR(r) ((char)(((r)&1)?((r)/256):ASHR2(r)))

#define CHAR_TO_REF(r) (((r)<<8)|CHAR_SUBTAG)


#ifdef ibmrt			/* expand this to include any system with unsigned chars */
#define SIGN_8BIT_ARG(c) (((c) & 0x80) ? ((c) | 0xffffff80) : (c))
#else
#define SIGN_8BIT_ARG(x) ((char)(x))
#endif

#define SIGN_16BIT_ARG(x) ((short)(x))
/* This can be ((x)>>2) on a machine that does arithmetic right shifts. */
#define ASHR2(x) ((x)/4)


/*
 * Offsets for wired types.  Offset includes type and
 * optional length fields when present.
 */

/* CONS-PAIR: */
#define CONS_PAIR_CAR_OFF 1
#define CONS_PAIR_CDR_OFF 2

/* TYPE: */
#define TYPE_LEN_OFF		1
#define TYPE_VAR_LEN_P_OFF	2
#define TYPE_SUPER_LIST_OFF	3
#define TYPE_IVAR_LIST_OFF	4
#define TYPE_IVAR_COUNT_OFF	5
#define TYPE_TYPE_BP_ALIST_OFF	6
#define TYPE_OP_METHOD_ALIST_OFF 7
#define TYPE_WIRED_P_OFF	8

/* METHOD: */
#define METHOD_CODE_OFF 1
#define METHOD_ENV_OFF 2

/* CODE-VECTOR: */
#define CODE_IVAR_MAP_OFF 2
#define CODE_CODE_START_OFF 3

/* OPERATION: */
#define OPERATION_LAMBDA_OFF		1
#define OPERATION_CACHE_TYPE_OFF	2
#define OPERATION_CACHE_METH_OFF	3
#define OPERATION_CACHE_TYPE_OFF_OFF	4

/* ESCAPE-OBJECT */
#define ESCAPE_OBJECT_VAL_OFF 1
#define ESCAPE_OBJECT_CXT_OFF 2

#define car(x) *(REF_TO_PTR(x)+CONS_PAIR_CAR_OFF)
#define cdr(x) *(REF_TO_PTR(x)+CONS_PAIR_CDR_OFF)

extern char *my_malloc();

extern ref e_t, e_nil, e_fixnum_type, e_loc_type, e_cons_type,
  *e_subtype_table, *e_bp, *e_env, e_env_type, *e_argless_tag_trap_table,
  *e_arged_tag_trap_table, e_object_type, *cxt_stk_start;

extern ref e_boot_code;

extern void printref();


extern bool dump_decimal, dump_binary;
extern unsigned long val_stk_size;
extern unsigned long cxt_stk_size;
extern unsigned long main_mem_size;
extern unsigned long load_mem_size;
extern ref *main_mem;
extern void read_world();
extern ref read_ref();
extern void dump_world();



extern unsigned long string_to_int();



extern unsigned long get_length();


extern ref *new_space, *free_point, *end_of_new_space;
extern unsigned long new_space_size;



#define wp_to_ref(r) (wp_table[(r)>>8])
extern ref wp_table[];
extern long wp_index;
extern ref ref_to_wp();
#define INT_TO_WP(i) ((ref)((i<<8)|WP_SUBTAG))
extern unsigned short *gc();

/* eof */
