
/*  Copyright (C) 1987 Barak Pearlmutter and Kevin Lang    */


/*  A bytecode emulator for the Oaklisp instruction set.   */
/*  Copyright (C) 1987 Barak Pearlmutter and Kevin Lang    */


#include <stdio.h>
#include <ctype.h>
#include "emulator.h"




#define CASE_FOUR 1

/* The FAST preprocessor symbol should be defined if you want things to run fast. */

#ifdef FAST

#define trace_insts	0
#define trace_stcon	0
#define trace_cxcon	0
#define trace_meth	0

#else

bool trace_insts = FALSE;		/* trace instruction execution */
bool trace_stcon = FALSE;		/* trace stack contents */
bool trace_cxcon = FALSE;		/* trace contents stack contents */
bool trace_meth  = FALSE;		/* trace method lookup */

#endif

bool trace_traps = FALSE;		/* trace tag traps */
bool trace_files = FALSE;		/* trace file opening */
bool dump_after  = FALSE;		/* dump world after running */
bool gc_before_dump = FALSE;		/* do a GC before dumping the world */

/*
 * Stack pointers point to the newest thing on the stack, not to the
 * next available location as is usual.  This makes PEEK and unary
 * functions faster.
 */

#define POP(x) (*(x)--)
#define PUSH(x,y) ((*++(x)) = (y))
#define PEEK(x) (*(x))




/*
 * Processor registers
 */

ref *cxt_stk;
ref *cxt_stk_start;

ref *e_bp, *e_env;

unsigned int e_nargs;

ref e_t, e_nil;
extern ref e_nil;


ref e_fixnum_type, e_loc_type, e_cons_type, e_env_type, *e_subtype_table,
  e_object_type, e_boot_code;

ref *e_arged_tag_trap_table, *e_argless_tag_trap_table;




#define GC() e_pc = gc(val_stk, cxt_stk, val_stk_start, e_pc, 0)


#define maybe_dump_world(dumpstackp) \
{                           \
  if (dumpstackp) dump_stack(val_stk_start, val_stk); \
  if ((dumpstackp) == 0 && gc_before_dump != 0) \
    (void)gc(val_stk,cxt_stk,val_stk_start,e_pc,1); \
  if (dump_after) dump_world(); \
}




void printref(s,refin)
     char s[];
     ref refin;
{
  ref theref = refin;
  if (theref&2) theref -= (ref)new_space;
  (void)printf(s,theref>>2,theref&3);
}      


void dump_stack(stk_start, stk)
     ref *stk_start, *stk;
{
  ref *ptr = stk_start;
  (void)printf("stack contents: ");
  while(ptr < stk)
    (void)printref(" %ld~%ld", *++ptr);
  (void)printf("\n");
  (void)fflush(stdout);
}


#define TRACEMETHOD(zz) {if (trace_meth) {printf("meth-trace%ld  ",zz);          \
					 printref("obj_type:%ld~%ld  ",obj_type); \
   				         printref("alist:%ld~%ld  ",alist);       \
				         printref("mptr:%ld~%ld\n",*method_ptr);  }}

#define TRACEASSQ(zz) {if (trace_meth) {printf("aq-trace%ld  ",zz);          \
   				         printref("elem:%ld~%ld  ",elem);       \
				         printref("list:%ld~%ld\n",list);  }}

#define TRACEPASSQ(zz) {printf("aq-trace%ld  ",zz);    \
			  printref("elem:%ld~%ld  ",elem);       \
			    printref("l:%ld~%ld ",l);  \
			    printref("cdr(l):%ld~%ld ",cdr(l));  \
			    if (locl) printref("*locl:%ld~%ld\n",*locl); }


/* these are inline coded now

ref assq(elem, list)
     ref elem, list;
{
  while (list != e_nil && car(car(list)) != elem) {
    list = cdr(list);
  }
  return ((list == e_nil)? e_nil : car(list));
}

ref old_pseudo_assq(elem, list)
     ref elem, list;
{
  while (list != e_nil && car(car(list)) != elem) {
    list = cdr(list);
  }
  return list;
}
*/


/* The following code uses the bring-to-front heuristic, 
   and eventually needs a register to inhibit this behavior. 
   This code is now inserted inline in the one place it is used.
ref pseudo_assq(elem, loclist) 
ref elem, *loclist;
{
  ref thelist = *loclist;

  register  ref l = thelist;
  register  ref *locl = NULL;

 iterate:
  if (l == e_nil)
    return e_nil;
  if (car(car(l)) == elem) {
    if (locl) {
      *locl = cdr(l);
      *loclist = l;
      cdr(l) = thelist;
    }
    return l;
  }
  locl = &(cdr(l));
  l = cdr(l);
  goto iterate;
}
*/




#define get_type(x) \
((x)&1 ? \
 ((x)&2 ? *REF_TO_PTR(x) : *(e_subtype_table + ((x&SUBTAG_MASK) >> 2))) : \
 ((x)&2 ? e_loc_type : e_fixnum_type))



void find_method_type_pair(op, obj_type, method_ptr, type_ptr)
     ref op, obj_type, *method_ptr, *type_ptr;
{
  register ref alist;
  register ref *locl = NULL;
  ref thelist;
  ref *loclist;

 tail_recurse:
  /* First look for it here: */
  /*alist = pseudo_assq(op, (REF_TO_PTR(obj_type) + TYPE_OP_METHOD_ALIST_OFF));*/

  /******************************************/
  loclist = (REF_TO_PTR(obj_type) + TYPE_OP_METHOD_ALIST_OFF);
  thelist = *loclist;
  alist = thelist;
  locl = NULL;
 iterate:
  if (alist == e_nil)
    goto iterate_end2;
  if (car(car(alist)) == op) {
    if (locl) {
      *locl = cdr(alist);
      *loclist = alist;
      cdr(alist) = thelist;
    }
    goto iterate_end;
  }
  locl = &(cdr(alist));
  alist = cdr(alist);
  goto iterate;
 iterate_end:
  /******************************************/

  if (alist != e_nil) 
    {
      *method_ptr = cdr(car(alist));
      *type_ptr = obj_type;
      return;
    }

 iterate_end2:
  /* Loop looking for it on supertypes: */
  alist = *(REF_TO_PTR(obj_type) + TYPE_SUPER_LIST_OFF);
  if (alist == e_nil) {
    return;
  }
  while (1)
    {
      if (cdr(alist) == e_nil)
	{
	  obj_type = car(alist);
          goto tail_recurse;
	}

      find_method_type_pair(op, car(alist), method_ptr, type_ptr);
      if (*method_ptr != e_nil) {
	/* Found on a supertype, that's it: */
	return;
      }
      alist = cdr(alist);
    }
}






main(argc,argv)
     int argc;
     char **argv;
{
  register ref *val_stk;
  unsigned short *e_pc;
#ifndef FAST
  ref *ptr;
#endif
  ref *val_stk_start;

  
  new_space_size = DEFAULT_NEW_SPACE_SIZE;


  {
    char **aargv = argv + 1;
    int aargc = argc - 1;
    
    while (aargc > 1 && (*aargv)[0] == '-')
      {
	switch ((*aargv)[1])
	  {
#ifndef FAST
	  case 'i':
	    trace_insts = 1; 
	    break;
	  case 'c':
	    trace_stcon = 1;
	    break;
	  case 'x':
	    trace_cxcon = 1;
	    break;
	  case 'm':
	    trace_meth = 1;
	    break;
#endif
	  case 'T':
	    trace_traps = 1;
	    break;
	  case 'F':
	    trace_files = 1;
	    break;
	  case 'd':
	    dump_after = 1;
	    break;
	  case 'h':
	    aargc -= 1;
	    aargv += 1;
	    new_space_size = string_to_int(*aargv) / sizeof(ref);
	    break;
	  case '9':
	    dump_decimal = 1;
	    break;
	  case 'b':
	    dump_binary = 1;
	    break;
	  case 'G':
	    gc_before_dump = 1;
	    break;
	  default:
	    (void)printf("Unknown option %s.\n", aargv[0]);
	    break;
	  }
	aargc -= 1;
	aargv += 1;
      }

    if (aargc != 1)
      {
	(void)printf("Usage: %s [-d,9,c,x,m,T] oaklisp-image\n", argv[0]);
	exit(1);
      }

    read_world(aargv[0]);

    val_stk = (ref *) my_malloc( val_stk_size*sizeof(ref) ) - 1;
    cxt_stk = (ref *) my_malloc( cxt_stk_size*sizeof(ref) ) - 1;

    val_stk_start = val_stk;
    cxt_stk_start = cxt_stk;

  }
  
/*e_pc = (unsigned short *) (REF_TO_PTR(e_boot_code) + CODE_CODE_START_OFF);*/

  e_pc = (unsigned short *)
    (REF_TO_PTR(*(REF_TO_PTR(e_boot_code) + METHOD_CODE_OFF))
     + CODE_CODE_START_OFF);
  e_env = REF_TO_PTR(*(REF_TO_PTR(e_boot_code) + METHOD_ENV_OFF));


  /* Okay, gentlemen, lets go: */

  {
    unsigned char arg_field;
    unsigned char op_field;
    /* This is used for instructions to communicate with the trap code when a fault is encountered. */
    unsigned int trap_nargs;
    register ref x, z;
    ref y;

#define CHECKTAG0(X,TAG,N) {if (!TAG_IS(X,TAG)) \
			      {trap_nargs=(N); goto arg0_tt;}}
#define CHECKTAG1(X,TAG,N) {if (!TAG_IS(X,TAG)) \
			      {trap_nargs=(N); goto arg1_tt;}}
#define CHECKTAG2(X,TAG,N) {if (!TAG_IS(X,TAG)) \
			      {trap_nargs=(N); goto arg2_tt;}}

#define CHECKCHAR0(X,N) {if (!TAG_IS(X,INT_TAG) && !SUBTAG_IS(X,CHAR_SUBTAG)) \
			   {trap_nargs=(N); goto arg0_tt;}}
#define CHECKCHAR1(X,N) {if (!TAG_IS(X,INT_TAG) && !SUBTAG_IS(X,CHAR_SUBTAG)) \
			   {trap_nargs=(N); goto arg1_tt;}}
#define CHECKCHAR2(X,N) {if (!TAG_IS(X,INT_TAG) && !SUBTAG_IS(X,CHAR_SUBTAG)) \
			   {trap_nargs=(N); goto arg2_tt;}}

#define CHECKWP0(X,N) {if (!TAG_IS(X,INT_TAG) && !SUBTAG_IS(X,WP_SUBTAG)) \
			   {trap_nargs=(N); goto arg0_tt;}}
#define CHECKWP1(X,N) {if (!TAG_IS(X,INT_TAG) && !SUBTAG_IS(X,WP_SUBTAG)) \
			   {trap_nargs=(N); goto arg1_tt;}}
#define CHECKWP2(X,N) {if (!TAG_IS(X,INT_TAG) && !SUBTAG_IS(X,WP_SUBTAG)) \
			   {trap_nargs=(N); goto arg2_tt;}}




    /* This is the big instruction fetch/execute loop. */
    while (1)
      {
#ifndef FAST
	if (val_stk < val_stk_start)
	  {
	    (void)fprintf(stderr,"stack underflow.\n");
	    maybe_dump_world(1);
	    exit(1);
	  }
	if (trace_insts)
	  {
	    (void)printf("PC %ld ", e_pc - (unsigned short *)new_space);
	    (void)fflush(stdout);
	  }
	if (trace_stcon) {
	  ptr = val_stk_start;
	  (void)printf("stack contents: ");
	  while(ptr < val_stk) 
	    (void)printref(" %ld~%ld", *++ptr);
	  (void)printf("\n");
	  (void)fflush(stdout);
	}
	if (trace_cxcon) {
	  ptr = cxt_stk_start;
	  (void)printf("context stack: ");
	  while(ptr < cxt_stk) 
	    (void)printref(" %ld~%ld", *++ptr);
	  (void)printf("\n");
	  (void)fflush(stdout);
	}
#endif
	/*
	 * instr = *e_pc++;
	 * op_field = instr & 0xFC;
	 * arg_field = instr>>8;
	 */
#ifdef BIG_ENDIAN
	/* *** Some compilers complain about the following construct : */
	/* arg_field = *((unsigned char *)e_pc)++; */
	/* op_field = *((unsigned char *)e_pc)++ >> 2; */
	/* *** so the code has to be rewritten to the horrible thing below: */
	arg_field = *(unsigned char *)e_pc;
	op_field = *( ((unsigned char *)e_pc) + 1) >> 2;
#else
	/* op_field = *(unsigned char *)e_pc++ >> 2; / * ICK */
	/* arg_field = *(unsigned char *)e_pc++; / * ICK */
	op_field = (*(unsigned char *)e_pc) >> 2;
	arg_field = *( ((unsigned char *)e_pc) + 1);
#endif
	e_pc += 1;
	
#ifndef FAST
	if (trace_insts)
	  {
	    (void)printf(", op %d, arg %d.\n", op_field, arg_field);
	    (void)fflush(stdout);
	  }
#endif

	switch (op_field)
	  {
	  case (CASE_FOUR*0):	/* ARGLESS-INSTRUCTION xxxx */
	    switch (arg_field)
	      {
	      case 0:		/* NOOP */
		break;
	      case 1:		/* PLUS */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,2);
		y = POP(val_stk);
		CHECKTAG2(y,INT_TAG,2);
		z = INT_TO_REF(REF_TO_INT(x)+REF_TO_INT(y));
		PUSH(val_stk, z);
		break;
	      case 2:		/* NEGATE */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,1);
		z = INT_TO_REF(-REF_TO_INT(x));
		PUSH(val_stk, z);
		break;
	      case 3:		/* EQ? */
		x = POP(val_stk);
		y = POP(val_stk);
		z = x==y ? e_t : e_nil;
		PUSH(val_stk, z);
		break;
	      case 4:		/* NOT */
		x = POP(val_stk);
		z = x==e_nil ? e_t : e_nil;
		PUSH(val_stk, z);
		break;
	      case 5:		/* TIMES */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,2);
		y = POP(val_stk);
		CHECKTAG2(y,INT_TAG,2);
		z = INT_TO_REF( REF_TO_INT(x) * REF_TO_INT(y) );
		PUSH(val_stk, z);
		break;
	      case 6:		/* LOAD-IMM ; INLINE-REF */
		/* allign pc to next word boundary: */
		if ((unsigned long)e_pc & 2) e_pc++;
		/* *** This don't work so I gotta rewrite it: */
		/* z = *(ref *)e_pc++; */
		z = *(ref *)e_pc;
		e_pc += 2;
		/* Not very pretty. */
		PUSH(val_stk, z);
		break;
	      case 7:		/* DIVIDE */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,2);
		y = POP(val_stk);
		CHECKTAG2(y,INT_TAG,2);
		z = INT_TO_REF( REF_TO_INT(x) / REF_TO_INT(y) );
		PUSH(val_stk, z);
		break;
	      case 8:		/* =0? */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,1);
		z = x==INT_TO_REF(0) ? e_t : e_nil;
		PUSH(val_stk, z);
		break;
	      case 9:		/* GET-TAG */
		x = POP(val_stk);
		z = INT_TO_REF(x & TAG_MASK);
		PUSH(val_stk, z);
		break;
	      case 10:		/* GET-DATA */
		x = POP(val_stk);
		z = (x&~TAG_MASK) | INT_TAG;
		if (x&2) z -= (ref)new_space;
		PUSH(val_stk, z);
		break;
	      case 11:		/* CRUNCH */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,2);
		y = POP(val_stk);
		CHECKTAG2(y,INT_TAG,2);
		z = (x&~TAG_MASK) | (ref)(REF_TO_INT(y)&TAG_MASK);
		if (REF_TO_INT(y)&2) z += (ref)new_space;
		PUSH(val_stk, z);
		break;
	      case 12:		/* GETC */
		/***************************** OBSOLETE? *********************/
		/* Used in emergency cold load standard-input stream. */
		z = CHAR_TO_REF(getc(stdin));
		PUSH(val_stk, z);
		break;
	      case 13:		/* PUTC */
		x = PEEK(val_stk);
		CHECKCHAR0(x,1);
		(void)putc(REF_TO_CHAR(x), stdout);
		(void)fflush(stdout);
		if (trace_insts)
		  (void)printf("\n");
		break;
	      case 14:		/* CONTENTS */
		x = POP(val_stk);
		CHECKTAG1(x,LOC_TAG,1);
		z = *REF_TO_PTR(x);
		PUSH(val_stk, z);
		break;
	      case 15:		/* SET-CONTENTS */
		x = POP(val_stk);
		CHECKTAG1(x,LOC_TAG,2);
		y = PEEK(val_stk);
		*REF_TO_PTR(x) = y;
		break;
	      case 16:		/* LOAD-TYPE */
		x = POP(val_stk);
		z = get_type(x);
		PUSH(val_stk, z);
		break;
	      case 17:		/* CONS */
		if (free_point+3 >= end_of_new_space)
		  GC();
		x = POP(val_stk);
		y = POP(val_stk);
		z = PTR_TO_REF(free_point);
		*free_point++ = e_cons_type;
		*free_point++ = x;
		*free_point++ = y;
		PUSH(val_stk, z);
		break;
	      case 18:		/* <0? */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,1);
		z = REF_TO_INT(x)<0 ? e_t : e_nil;
		PUSH(val_stk, z);
		break;
	      case 19:		/* MOD */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,2);
		y = POP(val_stk);
		CHECKTAG2(y,INT_TAG,2);
		{
		  long b = REF_TO_INT(y);
		  long c = REF_TO_INT(x) % b;

		  z = INT_TO_REF(c<0 ? c+b : c);
		}
		PUSH(val_stk, z);
		break;
	      case 20:		/* ASH */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,2);
		y = POP(val_stk);
		CHECKTAG2(y,INT_TAG,2);
		{
		  unsigned long a = (unsigned long)x;
		  long b = REF_TO_INT(y);

		  z = ( b<0 ? a>>-b : a<<b ) & ~3;
		}
		PUSH(val_stk, z);
		break;
	      case 21:		/* ROT */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,2);
		y = POP(val_stk);
		CHECKTAG2(y,INT_TAG,2);
		{
		  unsigned long a = (unsigned)x;
		  long b = REF_TO_INT(y);

		  z = ( b<0 ? (a>>-b | a<<30+b) : (a<<b | a>>30-b) ) & ~3;
		}
		PUSH(val_stk, z);
		break;
	      case 22:		/* STORE-BP-I */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,2);
		y = PEEK(val_stk);
		*(e_bp + REF_TO_INT(x)) = y;
		break;
	      case 23:		/* LOAD-BP-I */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,1);
		z = *(e_bp + REF_TO_INT(x));
		PUSH(val_stk, z);
		break;
	      case 24:		/* RETURN */
              do_a_return:
		e_env = (ref *) POP(cxt_stk);
		e_bp = (ref *) POP(cxt_stk);
		e_pc = (unsigned short *) POP(cxt_stk);
		break;
	      case 25:		/* ALLOCATE */
		x = POP(val_stk);
		y = POP(val_stk);
		CHECKTAG2(y,INT_TAG,2);
		{
		  ref *nfree_point = free_point+REF_TO_INT(y);

		  if (nfree_point >= end_of_new_space)
		    {
		      PUSH(val_stk, x);
		      GC();
		      nfree_point = free_point+REF_TO_INT(y);
		      x = POP(val_stk);
		    }

		  z = PTR_TO_REF(free_point);

		  *free_point++ = x;

		  /* This loop initializes the storage to 0's, to avoid garbage. */
		  while (free_point != nfree_point)
		    *free_point++ = REF_TO_INT(0);
		}
		PUSH(val_stk, z);
		break;
	      case 26:		/* ASSQ */
		z = POP(val_stk);
		x = POP(val_stk);
		/* y = assq(z,x); */
		while (x != e_nil && car(car(x)) != z) x = cdr(x);
		PUSH(val_stk, ((x == e_nil) ? e_nil : car(x)));
		break;
	      case 27:		/* LOAD-LENGTH */
		x = POP(val_stk);
		z = INT_TO_REF(get_length(x));
		PUSH(val_stk, z);
		break;
	      case 28:		/* PEEK */
		x = POP(val_stk);
		z = INT_TO_REF( *(short *)x );
		PUSH(val_stk, z);
		break;
	      case 29:		/* POKE */
		x = POP(val_stk);
		y = PEEK(val_stk);
		*(short *)x = REF_TO_INT(y);
		break;
	      case 30:		/* MAKE-CELL */
		if (free_point == end_of_new_space)
		  GC();
		x = POP(val_stk);
		z = PTR_TO_LOC(free_point);
		*free_point++ = x;
		PUSH(val_stk,z);
		break;
	      case 31:		/* SUBTRACT */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,2);
		y = POP(val_stk);
		CHECKTAG2(y,INT_TAG,2);
		z = INT_TO_REF(REF_TO_INT(x)-REF_TO_INT(y));
		PUSH(val_stk, z);
		break;
	      case 32:		/* = */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,2);
		y = POP(val_stk);
		CHECKTAG2(y,INT_TAG,2);
		z = (REF_TO_INT(x) == REF_TO_INT(y)) ? e_t : e_nil;
		PUSH(val_stk, z);
		break;
	      case 33:		/* < */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,2);
		y = POP(val_stk);
		CHECKTAG2(y,INT_TAG,2);
		z = (REF_TO_INT(x) < REF_TO_INT(y)) ? e_t : e_nil;
		PUSH(val_stk, z);
		break;
	      case 34:		/* LOG-NOT */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,1);
		z = INT_TO_REF(~REF_TO_INT(x));
		PUSH(val_stk, z);
		break;
	      case 35:		/* LONG-BRANCH distance (signed) */
		e_pc += ASHR2(SIGN_16BIT_ARG(*e_pc))+1;
		break;
	      case 36:		/* LONG-BRANCH-NIL distance (signed) */
		x = POP(val_stk);
		if (x == e_nil)
		  e_pc += ASHR2(SIGN_16BIT_ARG(*e_pc))+1;
		else
		  e_pc++;
		break;
	      case 37:		/* LONG-BRANCH-T distance (signed) */
		x = POP(val_stk);
		if (x != e_nil)
		  e_pc += ASHR2(SIGN_16BIT_ARG(*e_pc))+1;
		else
		  e_pc++;
		break;
	      case 38:		/* LOCATE-BP-I */
		x = POP(val_stk);
		CHECKTAG1(x,INT_TAG,1);
		z = PTR_TO_LOC(e_bp + REF_TO_INT(x));
		PUSH(val_stk, z);
		break;
	      case 39:		/* LOAD-IMM-CON ; INLINE-REF */
		/* This is like a LOAD-IMM followed by a CONTENTS. */
		/* allign pc to next word boundary: */
		if ((unsigned long)e_pc & 2) e_pc++;
		/* Compilers on some machines are wedged: */
		/* x = *(ref *)e_pc++; */
		x = *(ref *)e_pc;
		e_pc += 2;
		/* Blech. */
		CHECKTAG1(x,LOC_TAG,1);
		z = *REF_TO_PTR(x);
		PUSH(val_stk, z);
		break;
	      case 40:case 41:case 42:case 43:case 44:case 45: /* [SET-,LOCATE-]{CAR,CDR} */
		x = POP(val_stk);
		CHECKTAG1(x,PTR_TAG,( (arg_field==42 || arg_field==43) ? 2 : 1 ));
		if (*REF_TO_PTR(x) != e_cons_type)
		  {
		    if (trace_traps) (void)printf("Car family (%d) trap.\n", arg_field);
		    trap_nargs = (arg_field==42 || arg_field==43) ? 2 : 1;
		    goto arg1_tt;
		  }
		switch (arg_field)
		  {
		  case 40:
		    z = *(REF_TO_PTR(x) + CONS_PAIR_CAR_OFF);
		    PUSH(val_stk,z);
		    break;
		  case 41:
		    z = *(REF_TO_PTR(x) + CONS_PAIR_CDR_OFF);
		    PUSH(val_stk,z);
		    break;
		  case 42:
		    *(REF_TO_PTR(x) + CONS_PAIR_CAR_OFF) = PEEK(val_stk);
		    break;
		  case 43:
		    *(REF_TO_PTR(x) + CONS_PAIR_CDR_OFF) = PEEK(val_stk);
		    break;
		  case 44:
		    z = PTR_TO_LOC(REF_TO_PTR(x) + CONS_PAIR_CAR_OFF);
		    PUSH(val_stk,z);
		    break;
		  case 45:
		    z = PTR_TO_LOC(REF_TO_PTR(x) + CONS_PAIR_CDR_OFF);
		    PUSH(val_stk,z);
		    break;
		  }
		break;
	      case 46:	/* PUSH-CXT-LONG rel */
		/* Written like this for evaluation order. */
 		PUSH(cxt_stk, (ref) (e_pc + ASHR2(SIGN_16BIT_ARG(*e_pc)) + 1)); e_pc++;
		PUSH(cxt_stk, (ref)e_bp);
		PUSH(cxt_stk, (ref)e_env);
		break;
		/***************************** OBSOLETE *********************/
	      case 47:		/* OLD-FILLTAG : reuse this opcode */
		x =  PEEK(val_stk);
		printf("; Call to obsolete opcode OLD-FILLTAG (47).\n");
                *(REF_TO_PTR(x) + ESCAPE_OBJECT_VAL_OFF) = INT_TO_REF(val_stk - val_stk_start - 1);
                *(REF_TO_PTR(x) + ESCAPE_OBJECT_CXT_OFF) = INT_TO_REF(cxt_stk - cxt_stk_start);
		break;
	      case 48:		/* THROW */
		x = POP(val_stk);
		z = POP(val_stk);
		val_stk = val_stk_start
   		        + REF_TO_INT(*(REF_TO_PTR(x) + ESCAPE_OBJECT_VAL_OFF));
		cxt_stk = cxt_stk_start
   		        + REF_TO_INT(*(REF_TO_PTR(x) + ESCAPE_OBJECT_CXT_OFF));
		PUSH(val_stk, z);
		goto do_a_return;
		break;
	      case 49:		/* GET-WP */
		x = POP(val_stk);
		z = ref_to_wp(x);
		PUSH(val_stk, z);
		break;
	      case 50:		/* WP-CONTENTS */
		x = POP(val_stk);
		CHECKWP1(x,1);
		z = wp_to_ref(x);
		PUSH(val_stk,z);
		break;
	      case 51:		/* GC */
		GC();
		PUSH(val_stk,e_nil);
		break;
	      case 52:		/* BIG-ENDIAN? */
#ifdef BIG_ENDIAN
		PUSH(val_stk,e_t);
#else
		PUSH(val_stk,e_nil);
#endif /* BIG_ENDIAN */
		break;
#ifndef FAST
	      default:
		(void)printf("\nIllegal ARGLESS instruction %d.\n", arg_field);
		maybe_dump_world(1);
		exit(1);
#endif
	      }
	    break;
	  case (CASE_FOUR*1):	/* HALT n */
	    if (arg_field != 0) {
	      (void)printf("\nHalt code %d.\n", arg_field);
	    }
	    (void)printf("\nOaklisp stopped itself...\n");
	    maybe_dump_world(arg_field);
	    exit((int)arg_field);
	  case (CASE_FOUR*2):	/* LOG-OP log-spec */
	    x = POP(val_stk);
	    CHECKTAG1(x,INT_TAG,2);
	    y = POP(val_stk);
	    CHECKTAG2(y,INT_TAG,2);
	    {
	      long x1 = REF_TO_INT(x), y1 = REF_TO_INT(y);
	      z = INT_TO_REF(  (arg_field&1 ? x1&y1 : 0)
			     | (arg_field&2 ? ~x1&y1 : 0)
			     | (arg_field&4 ? x1&~y1 : 0)
			     | (arg_field&8 ? ~x1&~y1 : 0) );
	    }
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*3):	/* BLT-STACK stuff,trash */
	    {
	      ref *p1 = val_stk - ((arg_field&0xF) - 1);
	      ref *p2 = p1 - ((arg_field>>4)+1);

	      while (p1 <= val_stk)
		*p2++ = *p1++;
	      val_stk = p2-1;
	    }
	    break;
	  case (CASE_FOUR*4):	/* BRANCH-NIL distance (signed) */
	    x = POP(val_stk);
	    if (x == e_nil)
	      e_pc += SIGN_8BIT_ARG(arg_field);
	    break;
	  case (CASE_FOUR*5):	/* BRANCH-T distance (signed) */
	    x = POP(val_stk);
	    if (x != e_nil)
	      e_pc += SIGN_8BIT_ARG(arg_field);
	    break;
	  case (CASE_FOUR*6):	/* BRANCH distance (signed) */
	    e_pc += SIGN_8BIT_ARG(arg_field);
	    break;
	  case (CASE_FOUR*7):	/* POP n */
	    val_stk -= arg_field;
	    break;
	  case (CASE_FOUR*8):	/* SWAP n */
	    {
	      ref *other = val_stk - arg_field;

	      x = PEEK(val_stk);
	      /* This should be PEEK(val_stk) = *other; */
	      *(val_stk) = *other;
	      *other = x;
	    }
	    break;
	  case (CASE_FOUR*9):	/* BLAST n */
	    x = PEEK(val_stk);
	    *(val_stk - arg_field) = x;
	    (void) POP(val_stk);
	    break;
	  case (CASE_FOUR*10):	/* LOAD-IMM-FIX signed-arg */
	    z = INT_TO_REF(SIGN_8BIT_ARG(arg_field));
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*11):	/* STORE-STK n */
	    *(val_stk - arg_field) = PEEK(val_stk);
	    break;
	  case (CASE_FOUR*12):	/* LOAD-BP n */
	    z = *(e_bp + arg_field);
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*13):	/* STORE-BP n */
	    x = PEEK(val_stk);
	    *(e_bp + arg_field) = x;
	    break;
	  case (CASE_FOUR*14):	/* LOAD-ENV n */
	    z = *(e_env + arg_field);
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*15):	/* STORE-ENV n */
	    x = PEEK(val_stk);
	    *(e_env + arg_field) = x;
	    break;
	  case (CASE_FOUR*16):	/* LOAD-STK n */
	    z = *(val_stk - arg_field);
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*17):	/* MAKE-BP-LOC n */
	    z = PTR_TO_LOC(e_bp + arg_field);
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*18):	/* MAKE-ENV-LOC n */
	    z = PTR_TO_LOC(e_env + arg_field);
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*19):	/* STORE-REG reg */
	    x = PEEK(val_stk);
	    switch (arg_field)
	      {
	      case 0:
		e_t = x;
		break;
	      case 1:
		e_nil = x;
		break;
	      case 2:
		e_fixnum_type = x;
		break;
	      case 3:
		e_loc_type = x;
		break;
	      case 4:
		e_cons_type = x;
		break;
	      case 5:
		CHECKTAG1(x,PTR_TAG,1);
		e_subtype_table = REF_TO_PTR(x) + 2;
		break;
	      case 6:
		CHECKTAG1(x,LOC_TAG,1);
		e_bp = REF_TO_PTR(x);
		break;
	      case 7:
		CHECKTAG1(x,PTR_TAG,1);
		e_env = REF_TO_PTR(x);
		break;
	      case 8:
		CHECKTAG1(x,INT_TAG,1);
		e_nargs = REF_TO_INT(x);
		break;
	      case 9:
		e_env_type = x;
		break;
	      case 10:
		CHECKTAG1(x,PTR_TAG,1);
		e_argless_tag_trap_table = REF_TO_PTR(x) + 2;
		break;
	      case 11:
		CHECKTAG1(x,PTR_TAG,1);
		e_arged_tag_trap_table = REF_TO_PTR(x) + 2;
		break;
	      case 12:
		e_object_type = x;
		break;
	      case 13:
		e_boot_code = x;
		break;
	      case 14:
		CHECKTAG1(x,LOC_TAG,1);
		free_point = REF_TO_PTR(x);
		break;
	      case 15:
		CHECKTAG1(x,LOC_TAG,1);
		end_of_new_space = REF_TO_PTR(x);
		break;
	      }
	    break;
	  case (CASE_FOUR*20):	/* LOAD-REG reg */
	    switch (arg_field)
	      {
	      case 0:
		z = e_t;
		break;
	      case 1:
		z = e_nil;
		break;
	      case 2:
		z = e_fixnum_type;
		break;
	      case 3:
		z = e_loc_type;
		break;
	      case 4:
		z = e_cons_type;
		break;
	      case 5:
		z = PTR_TO_REF(e_subtype_table - 2);
		break;
	      case 6:
		z = PTR_TO_LOC(e_bp);
		break;
	      case 7:
		z = PTR_TO_REF(e_env);
		break;
	      case 8:
		z = INT_TO_REF((long)e_nargs);
		break;
	      case 9:
		z = e_env_type;
		break;
	      case 10:
		z = PTR_TO_REF(e_argless_tag_trap_table - 2);
		break;
	      case 11:
		z = PTR_TO_REF(e_arged_tag_trap_table - 2);
		break;
	      case 12:
		z = e_object_type;
		break;
	      case 13:
		z = e_boot_code;
		break;
	      case 14:
		z = PTR_TO_LOC(free_point);
		break;
	      case 15:
		z = PTR_TO_LOC(end_of_new_space);
		break;
	      }
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*21):	/* FUNCALL-CXT, FUNCALL-CXT-BR distance (signed) */
	    /* NOTE: (FUNCALL-CXT) == (FUNCALL-CXT-BR 0) */
	    PUSH(cxt_stk, (ref) (e_pc + SIGN_8BIT_ARG(arg_field)));
	    PUSH(cxt_stk, (ref)e_bp);
	    PUSH(cxt_stk, (ref)e_env);
	    /* Fall through to tail recursive case: */
	  case (CASE_FOUR*22):	/* FUNCALL-TAIL */
	    /* This label allows us to branch in here from the tag trap code. */
	  funcall_tail:
	    x = POP(val_stk);
	    CHECKTAG1(x,PTR_TAG,e_nargs+1);

	    {
	      ref *oper = REF_TO_PTR(x);
	      ref lambda = *(oper + OPERATION_LAMBDA_OFF);

	      if (lambda == e_nil)
		{
		  /* SEARCH */
		  ref y_type;
		  if (e_nargs == 0)
		    y_type = e_object_type;
		  else
		    {
		      y = PEEK(val_stk);
		      y_type = get_type(y);
		    }

#ifdef METH_CACHE
		  /* Check for cache hit: */
		  if (y_type == *(oper + OPERATION_CACHE_TYPE_OFF))
		    {
	/*
		      printf("H"); fflush(stdout);
	*/
		      lambda = *(oper + OPERATION_CACHE_METH_OFF);
		      e_bp = REF_TO_PTR(y) + REF_TO_INT(*(oper + OPERATION_CACHE_TYPE_OFF_OFF));
		      e_env = REF_TO_PTR(*(REF_TO_PTR(lambda) + METHOD_ENV_OFF));
		      e_pc = (unsigned short *)
			(REF_TO_PTR(*(REF_TO_PTR(lambda) + METHOD_CODE_OFF))
			 + CODE_CODE_START_OFF);
		    }
		  else
#endif /* METH_CACHE */
		    {
		      /* Search the type heirarchy. */
		      ref meth_type, offset;
#ifdef METH_CACHE
		/*
		      printf("M"); fflush(stdout);
		*/
#endif
		      find_method_type_pair(x,y_type,&lambda,&meth_type);

		      if (lambda == e_nil)
			{
			  if (trace_traps)
			    (void)printf("No handler for operation!\n");
			  trap_nargs = e_nargs+1;
			  goto arg1_tt;
			}

		      /* Could dispense with this if meth_type has no ivars and isn't
			 variable-length-mixin. */
		      z = meth_type;
		      x = *(REF_TO_PTR(y_type) + TYPE_TYPE_BP_ALIST_OFF);
		      while (x != e_nil && car(car(x)) != z)
			x = cdr(x);
		      offset = (x != e_nil) ? cdr(car(x)) : INT_TO_REF(0);

#ifdef METH_CACHE
		      /* Cache the results of our fun search. */
		      *(oper + OPERATION_CACHE_TYPE_OFF) = y_type;
		      *(oper + OPERATION_CACHE_METH_OFF) = lambda;
		      *(oper + OPERATION_CACHE_TYPE_OFF_OFF) = offset;
#endif /* METH_CACHE */
		      
		      e_bp = REF_TO_PTR(y) + REF_TO_INT(offset);
		      e_env = REF_TO_PTR(*(REF_TO_PTR(lambda) + METHOD_ENV_OFF));
		      e_pc = (unsigned short *)
			(REF_TO_PTR(*(REF_TO_PTR(lambda) + METHOD_CODE_OFF))
			 + CODE_CODE_START_OFF);
		    }
		}
	      else if (lambda == INT_TO_REF(0))
		{
		  /* TAG TRAP */
		  if (trace_traps)
		    (void)printf("No handler ever defined on anything for operation!\n");
		  trap_nargs = e_nargs+1;
		  goto arg1_tt;
		}
	      else
		{
		  /* LAMBDA */
		  e_env = REF_TO_PTR(*(REF_TO_PTR(lambda) + METHOD_ENV_OFF));
		  e_pc = (unsigned short *)
		    (REF_TO_PTR(*(REF_TO_PTR(lambda) + METHOD_CODE_OFF))
		     + CODE_CODE_START_OFF);
		}
	    }
	    break;
	  case (CASE_FOUR*23):	/* STORE-NARGS n */
	    e_nargs = arg_field;
	    break;
	  case (CASE_FOUR*24):	/* CHECK-NARGS n */
	    if (e_nargs != arg_field) 
	      {
		if (trace_traps)
		  (void)printf("\n%d args passed; %d expected.\n", e_nargs, arg_field);
		trap_nargs = e_nargs;
		goto arg0_tt;
	      }
	    break;
	  case (CASE_FOUR*25):	/* CHECK-NARGS-GTE n */
	    if (e_nargs < arg_field) 
	      {
		if (trace_traps)
		  (void)printf("\n%d args passed; %d or more expected.\n", e_nargs, arg_field);
		trap_nargs = e_nargs;
		goto arg0_tt;
	      }
	    break;
	  case (CASE_FOUR*26):	/* STORE-SLOT n */
	    x = POP(val_stk);
	    y = PEEK(val_stk);
	    *(REF_TO_PTR(x) + arg_field) = y;
	    break;
	  case (CASE_FOUR*27):	/* LOAD-SLOT n */
	    x = POP(val_stk);
	    z = *(REF_TO_PTR(x) + arg_field);
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*28):	/* MAKE-CLOSED-ENVIRONMENT n */
	    if (free_point + arg_field + 2 >= end_of_new_space)
	      GC();
	    z = PTR_TO_REF(free_point);
	    *free_point++ = e_env_type;
	    *free_point++ = INT_TO_REF(arg_field+2);
	    while (arg_field--)
	      *free_point++ = POP(val_stk);
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*29):	/* PUSH-CXT rel */
	    PUSH(cxt_stk, (ref) (e_pc + SIGN_8BIT_ARG(arg_field)));
	    PUSH(cxt_stk, (ref)e_bp);
	    PUSH(cxt_stk, (ref)e_env);
	    break;
	  case (CASE_FOUR*30):	/* LOCATE-SLOT n */
	    x = POP(val_stk);
	    z = PTR_TO_LOC(REF_TO_PTR(x) + arg_field);
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*31):	/* STREAM-PRIMITIVE n */
	    switch (arg_field)
	      {
	      case 0:		/* n=0: get standard input stream. */
		z = (ref)stdin;
		break;
	      case 1:		/* n=1: get standard output stream. */
		z = (ref)stdout;
		break;
	      case 2:		/* n=2: get standard error output stream. */
		z = (ref)stderr;
		break;
	      case 3:		/* n=3: fopen, mode READ */
	      case 4:		/* n=4: fopen, mode WRITE */
	      case 5:		/* n=5: fopen, mode APPEND */
		x = POP(val_stk);
		y = POP(val_stk);
		{
		  long len = REF_TO_INT(y);
		  char *stuff = malloc(len+1);
		  unsigned long *p = (unsigned long *)REF_TO_PTR(x);
		  int i = 0, j = 0;

		  while (i+2<len)
		    {
		      unsigned long pp = *p++;
		      stuff[j++] = (pp >> 2) & 0xFF;
		      stuff[j++] = (pp >> 10) & 0xFF;
		      stuff[j++] = (pp >> 18) & 0xFF;
		      i += 3;
		    }
		  if (i+1<len)
		    {
		      unsigned long pp = *p;
		      stuff[j++] = (pp >> 2) & 0xFF;
		      stuff[j++] = (pp >> 10) & 0xFF;
		      i += 2;
		    }
		  else if (i<len)
		    {
		      stuff[j++] = (*p >> 2) & 0xFF;
		      i += 1;
		    }
		  stuff[j] = 0;

		  if (trace_files)
		    (void)printf("About to open '%s'.\n", stuff);
		  z = (ref)fopen(stuff, arg_field == 3 ? READ_MODE : arg_field == 4 ? WRITE_MODE : APPEND_MODE);
		  free(stuff);
		}
		break;
	      case 6:		/* n=6: fclose */
		x = POP(val_stk);
		z = fclose((FILE *)x) == EOF ? e_nil : e_t;
		break;
	      case 7:		/* n=7: fflush */
		x = POP(val_stk);
		z = fflush((FILE *)x) == EOF ? e_nil : e_t;
		break;
	      case 8:		/* n=8: putc */
		x = POP(val_stk);
		y = POP(val_stk);
		CHECKCHAR2(y,2);
		z = putc(REF_TO_CHAR(y), (FILE *)x) == EOF ? e_nil : e_t;
		break;
	      case 9:		/* n=9: getc */
		x = POP(val_stk);
		{
		  int c=getc((FILE *)x);
		  z = (c==EOF) ? e_nil : CHAR_TO_REF(c);
		}
		break;
	      default:
		(void)printf("\nIllegal arg %d to STREAM-PRIMITIVE bytecode.\n",
			     arg_field);
		maybe_dump_world(1);
	      }
	    PUSH(val_stk, z);
	    break;
	  case (CASE_FOUR*32):	/* FILLTAG n */
	    x =  PEEK(val_stk);
	    *(REF_TO_PTR(x) + ESCAPE_OBJECT_VAL_OFF) = INT_TO_REF(val_stk - val_stk_start - arg_field);
	    *(REF_TO_PTR(x) + ESCAPE_OBJECT_CXT_OFF) = INT_TO_REF(cxt_stk - cxt_stk_start);
	    break;
#ifndef FAST
	  default:
	    (void)printf("\nIllegal Bytecode %d.\n", op_field);
	    maybe_dump_world(1);
#endif
	  }
      }

    /* The above loop is infinite; we branch down to here when instructions fail, normally from tag traps, and then branch back. */

  arg2_tt:
    /* If we have a tag trap on the second arg, push 'em both and deal with it. */
    PUSH(val_stk, y);
  arg1_tt:
    PUSH(val_stk, x);
  arg0_tt:
    if (trace_traps)
      {
	(void)printf("\nTag trap: opcode %d, argfield %d.\n", op_field, arg_field);
	(void)printf("Top of stack: ");
	printref("%ld~%ld", x);
	(void)printf(", pc =  %ld\n",
		     (ref) ((unsigned long) e_pc) - (unsigned long) new_space);
      }

    /* Trick: to preserve tail recursiveness, push context only if next instruction isn't a RETURN. */
    /* And if current instruction wasn't a FUNCALL, obviously.  */
    if (*e_pc != 24*256 + 0 && op_field != 21 && op_field != 22)
      {
	PUSH(cxt_stk, (ref)e_pc);
	PUSH(cxt_stk, (ref)e_bp);
	PUSH(cxt_stk, (ref)e_env);
      }

    /* The trapping instruction was supposed to stash it's argument count here. */
    e_nargs = trap_nargs;

    if (op_field == 0)
      {
	/* argless instruction. */
	z = *(e_argless_tag_trap_table + arg_field);
      }
    else
      {
	/* arg'ed instruction, so push arg field as extra argument */
	z = INT_TO_REF(arg_field);
	PUSH(val_stk, z);
	e_nargs += 1;

	z = *(e_arged_tag_trap_table + op_field);
      }

    PUSH(val_stk, z);

    if (trace_traps)
      {
	(void)printf("Dispatching to ");
	printref("%ld~%ld", z);
	(void)printf(" with NARGS = %d.\n", e_nargs);
      }

    /* We have to set the instruction dispatch registers in case the funcall fails. */
    op_field = 22;
    arg_field = 0;

    goto funcall_tail;
  }
}
