;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.7/Llib/intext.scm ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 18 08:11:58 1994                          */
;*    Last change :  Thu Nov 17 08:42:36 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'internement et l'externement lineaire qui ne fait pas de       */
;*    sur la taille des mots memoire de la machine utilisee. De plus   */
;*    les formats d'internements ne sont pas dependant des             */
;*    architectures. Autrement dit, il est possible d'externer une     */
;*    valeur sur machines 32 bits et de le relire sur machines 64 bits.*/
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __intext
   (foreign (define long  cnst->integer  (obj)  "CCNST")
	    (define obj   integer->cnst  (long) "BCNST")
	    (define bool  pointer?       (obj)  "POINTERP")
	    (define long  size-of-long          "sizeof( long )")
	    (define long  string-mark-offset    "STRING_MARK_OFFSET")
	    (define long  vector-mark-offset    "VECTOR_MARK_OFFSET")
	    (export obj   string->obj    (obj)  "string_to_obj")
	    (export obj   obj->string    (obj)  "obj_to_string"))
   (export  (string->obj <string>)
	    (obj->string <object>)))
 
;*---------------------------------------------------------------------*/
;*    for  ....                                                        */
;*---------------------------------------------------------------------*/
(define-macro (for var min max . body)
   (let ((loop (gensym 'for)))
      `(let ,loop ((,var ,min))
	    (if (<=fx ,var ,max)
		(begin
		   ,@body
		   (,loop (+fx ,var 1)))
		'done))))

;*---------------------------------------------------------------------*/
;*    Les variables de controle de `string->obj'                       */
;*---------------------------------------------------------------------*/
(define *ref-vector* '#())
(define *defining*    #f)
(define *pointeur*    0)
(define *nb-ref*      0)
(define *ref*         0)

;*---------------------------------------------------------------------*/
;*    Cette variable est *indispensable* pour la fonction `mark-item!' */
;*    (voir commentaire dans la fonction).                             */
;*---------------------------------------------------------------------*/
(define *string-mark* '())

;*---------------------------------------------------------------------*/
;*    string->obj ...                                                  */
;*---------------------------------------------------------------------*/
(define (string->obj s)
   (define (read-taille)
      (let ((accu-entier 0))
	 (let ((taille (char->integer (string-ref s *pointeur*))))
	    (set! *pointeur* (+fx *pointeur* 1))
	    (for i 0 (-fx taille 1)
		 (let ((d (string-ref s *pointeur*)))
		    (set! accu-entier (+fx (*fx 256 accu-entier)
					   (char->integer d)))
		    (set! *pointeur* (+fx *pointeur* 1))))
	    accu-entier)))
   (define (read-nombre-entier)
      (read-taille))
   (define (read-nombre-flottant)
      (let* ((taille (read-taille))
	     (res    (string->real (substring s *pointeur*
					      (+fx *pointeur* taille)))))
	 (set! *pointeur* (+fx *pointeur* taille))
	 res))
   (define (read-definition)
      (set! *defining* (read-item))
      (read-item))
   (define (read-reference)
      (vector-ref *ref-vector* (read-item)))
   (define (read-symbol)
      (let* ((defining (let ((old *defining*))
			  (set! *defining* #f)
			  old))
	     (res      (string->symbol (read-string))))
	 (if (integer? defining)
	     (vector-set! *ref-vector* defining res))
	 res))
   (define (read-cnst)
      (integer->cnst (read-nombre-entier)))
   (define (read-char)
      (integer->char (read-nombre-entier)))
   (define (read-string)
      (let* ((taille (read-taille))
	     (res    (substring s *pointeur* (+fx *pointeur* taille))))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (set! *pointeur* (+fx *pointeur* taille))
	 res))
   (define (read-vecteur)
      (let* ((taille (read-taille))
	     (res    (make-vector taille)))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (for i 0 (-fx taille 1)
	      (vector-set! res i (read-item)))
	 res))
   (define (read-vecteur-tague)
      (let* ((tag    (read-item))
	     (taille (read-taille))
	     (res    (make-vector taille)))
	 (vector-tag-set! res tag)
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (for i 0 (-fx taille 1)
	      (vector-set! res i (read-item)))
	 res))
   (define (read-liste)
      (let* ((taille (read-taille))
	     (res    (cons '() '())))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (let loop ((i  0)
		    (hd res))
	    (if (=fx i (-fx taille 2))
		(begin
		   (set-car! hd (read-item))
		   (set-cdr! hd (read-item)))
		(begin
		   (set-car! hd (read-item))
		   (set-cdr! hd (cons '() '()))
		   (loop (+fx i 1) (cdr hd)))))
	 res))
   (define (read-cellule)
      (let ((res (make-cell (unspecified))))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (cell-set! res (read-item))
	 res))
   (define (read-structure)
      (let* ((defining (let ((old *defining*))
			  (set! *defining* #f)
			  old))
	     (key      (read-item))
	     (taille   (read-taille))
	     (res      (make-struct key taille (unspecified))))
	 (if (integer? defining)
	     (vector-set! *ref-vector* defining res))
	 (for i 0 (-fx taille 1)
	      (begin
		 (struct-set! res i (read-item))))
	 res)) 
   (define (read-item)
      (let ((d (string-ref s *pointeur*)))
	 (set! *pointeur* (+fx *pointeur* 1))
	 (case d
	    ((#\=)  (read-definition))
	    ((#\#)  (read-reference))
	    ((#\')  (read-symbol))
	    ((#\a)  (read-char))
	    ((#\<)  (read-cnst))
	    ((#\")  (read-string))
	    ((#\[)  (read-vecteur))
	    ((#\t)  (read-vecteur-tague))
	    ((#\()  (read-liste))
	    ((#\{)  (read-structure))
	    ((#\f)  (read-nombre-flottant))
	    ((#\-)  (negfx (read-nombre-entier)))
	    ((#\!)  (read-cellule))
	    (else   (set! *pointeur* (-fx *pointeur* 1))
		    (read-nombre-entier)))))
   (set! *pointeur* 0)
   (let ((d (string-ref s *pointeur*)))
      (if (char=? d #\c)
	  (begin
	     (set! *pointeur* (+fx *pointeur* 1))
	     (set! *ref-vector* (make-vector (read-taille))))))
   (read-item))

;*---------------------------------------------------------------------*/
;*    les structures de marks                                          */
;*---------------------------------------------------------------------*/
(define-struct mark obj old-value ref defined? ref-count)

;*---------------------------------------------------------------------*/
;*    incr-mark-ref-count! ...                                         */
;*---------------------------------------------------------------------*/
(define (incr-mark-ref-count! mark ref)
   (let ((old-mark (mark-ref-count mark)))
      (mark-ref-count-set! mark (+fx 1 old-mark))
      (if (=fx old-mark 0)
	  (+fx ref 1)
	  ref)))

;*---------------------------------------------------------------------*/
;*    pair-unmark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (pair-unmark! pair)
   (let ((old-value (mark-old-value (get-pair-mark pair))))
      (set-cdr! pair old-value)))

;*---------------------------------------------------------------------*/
;*    pair-mark! ...                                                   */
;*---------------------------------------------------------------------*/
(define (pair-mark! pair)
   (let ((new (make-mark)))
      (mark-obj-set!       new pair)
      (mark-old-value-set! new (cdr pair))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (set-cdr! pair new)
      new))

;*---------------------------------------------------------------------*/
;*    pair-marked? ...                                                 */
;*---------------------------------------------------------------------*/
(define (pair-marked? pair)
   (mark? (cdr pair)))

;*---------------------------------------------------------------------*/
;*    get-pair-mark ...                                                */
;*---------------------------------------------------------------------*/
(define (get-pair-mark pair)
   (cdr pair))

;*---------------------------------------------------------------------*/
;*    pointer-unmark! ...                                              */
;*---------------------------------------------------------------------*/
(define (pointer-unmark! ptr)
   (let ((old-value (mark-old-value (get-pointer-mark ptr))))
      (poke! ptr 1 old-value)))

;*---------------------------------------------------------------------*/
;*    pointer-mark! ...                                                */
;*---------------------------------------------------------------------*/
(define (pointer-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (peek ptr 1))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (poke! ptr 1 new)
      new))

;*---------------------------------------------------------------------*/
;*    pointer-marked? ...                                              */
;*---------------------------------------------------------------------*/
(define (pointer-marked? ptr)
   (mark? (get-pointer-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-pointer-mark ...                                             */
;*---------------------------------------------------------------------*/
(define (get-pointer-mark ptr)
   (peek ptr 1))

;*---------------------------------------------------------------------*/
;*    cell-unmark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (cell-unmark! cell)
   (let ((old-value (mark-old-value (get-cell-mark cell))))
      (cell-set! cell old-value)))

;*---------------------------------------------------------------------*/
;*    cell-mark! ...                                                   */
;*---------------------------------------------------------------------*/
(define (cell-mark! cell)
   (let ((new (make-mark)))
      (mark-obj-set!       new cell)
      (mark-old-value-set! new (cell-ref cell))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (cell-set! cell new)
      new))

;*---------------------------------------------------------------------*/
;*    cell-marked? ...                                                 */
;*---------------------------------------------------------------------*/
(define (cell-marked? cell)
   (mark? (cell-ref cell)))

;*---------------------------------------------------------------------*/
;*    get-cell-mark ...                                                */
;*---------------------------------------------------------------------*/
(define (get-cell-mark cell)
   (cell-ref cell))

;*---------------------------------------------------------------------*/
;*    symbol-mark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (symbol-mark! symbol)
   (let ((new (make-mark)))
      (mark-obj-set!       new symbol)
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (putprop! symbol 'mark new)
      new))

;*---------------------------------------------------------------------*/
;*    symbol-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (symbol-unmark! symbol)
   (remprop! symbol 'mark))

;*---------------------------------------------------------------------*/
;*    symbol-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (symbol-marked? symbol)
   (mark? (getprop symbol 'mark)))

;*---------------------------------------------------------------------*/
;*    get-symbol-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-symbol-mark symbol)
   (getprop symbol 'mark))

;*---------------------------------------------------------------------*/
;*    string-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (string-unmark! ptr)
   (let ((old-value (mark-old-value (get-string-mark ptr))))
      (poke! ptr string-mark-offset old-value)))

;*---------------------------------------------------------------------*/
;*    string-mark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (string-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (peek ptr string-mark-offset))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (poke! ptr string-mark-offset new)
      new))

;*---------------------------------------------------------------------*/
;*    string-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (string-marked? ptr)
   (mark? (get-string-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-string-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-string-mark ptr)
   (peek ptr string-mark-offset))

;*---------------------------------------------------------------------*/
;*    vector-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (vector-unmark! ptr)
   (let ((old-value (mark-old-value (get-vector-mark ptr))))
      (poke! ptr vector-mark-offset old-value)))

;*---------------------------------------------------------------------*/
;*    vector-mark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (vector-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (peek ptr vector-mark-offset))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (poke! ptr vector-mark-offset new)
      new))

;*---------------------------------------------------------------------*/
;*    vector-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (vector-marked? ptr)
   (mark? (get-vector-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-vector-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-vector-mark ptr)
   (peek ptr vector-mark-offset))

;*---------------------------------------------------------------------*/
;*    *taille-du-mot-maximum* ...                                      */
;*---------------------------------------------------------------------*/
(define *taille-du-mot-maximum* size-of-long)

;*---------------------------------------------------------------------*/
;*    taille-du-mot ...                                                */
;*---------------------------------------------------------------------*/
(define (taille-du-mot m)
   (let loop ((taille 0)
	      (m      m))
      (if (=fx m 0)
	  taille
	  (loop (+fx taille 1)
		(bit-rsh m 8)))))

;*---------------------------------------------------------------------*/
;*    obj->string ...                                                  */
;*---------------------------------------------------------------------*/
(define (obj->string obj)
   (set! *ref*      -1)
   (set! *nb-ref*    0)
   (set! *pointeur*  0)
   (let* ((length-buffer    100)
	  (buffer            (make-string length-buffer #\space)))
      (define (get-new-ref)
	 (set! *ref* (+fx *ref* 1))
	 *ref*)
      (define (verifie-taille-buffer! taille)
	 (let ((l (+fx *pointeur* (+fx taille
				       (+fx *taille-du-mot-maximum* 1)))))
	    (if (>=fx l length-buffer)
		(begin
		   (let ((vieille-longeur length-buffer)
			 (vieux-buffer    buffer))
		      (set! length-buffer (*fx 2 (+fx l 100)))
		      (set! buffer (make-string length-buffer))
		      (blit-string! vieux-buffer 0 buffer
				    0 vieille-longeur))))))
      (define (print-marqueur c)
	 (verifie-taille-buffer! 0)
	 (string-set! buffer *pointeur* c)
	 (set! *pointeur* (+fx *pointeur* 1)))
      (define (print-int-as-char c)
	 (print-marqueur (integer->char c)))
      (define (print-mot m)
	 (let ((taille (taille-du-mot m)))
	    (if (=fx taille 0)
		(print-int-as-char 0)
		(begin
		   (print-int-as-char taille)
		   (let loop ((i (-fx taille 1)))
		      (if (=fx i -1)
			  'done
			  (begin
			     (let ((d (bit-and (bit-rsh m (*fx 8 i)) #xff)))
				(print-int-as-char d)
				(loop (-fx i 1))))))))))
      (define (print-taille taille)
	 (verifie-taille-buffer! taille)
	 (print-mot taille))
      (define (print-chars s len)
	 (let ((taille len))
	    (print-taille taille)
	    (blit-string! s 0 buffer *pointeur* taille)
	    (set! *pointeur* (+fx *pointeur* taille))))
      (define (print-ds s len)
	 (print-chars s len))
      (define (print-df f)
	 (let ((s (real->string f)))
	    (print-chars s (string-length s))))
      (define (print-di i)
	 (verifie-taille-buffer! 0)
	 (if (<fx i 0)
	     (begin
		(string-set! buffer *pointeur* #\-)
		(set! *pointeur* (+fx *pointeur* 1))
		(print-mot (negfx i)))
	     (print-mot i)))
      (define (print-dv v len)
	 (print-taille len)
	 (for i 0 (-fx len 1)
	      (print-item (vector-ref-ur v i))))
      (define (print-du v len)
	 (print-taille len)
	 (for i 0 (-fx len 1)
	      (print-item (struct-ref v i))))
      (define (pair-mark-gc! p)
	 (let ((mark (get-pair-mark p)))
 	    (if (and (mark-defined? mark)
		     (>fx (mark-ref-count mark) 0))
		(mark-ref-count-set! mark (-fx (mark-ref-count mark) 1))
		(pair-unmark! p))))
      (define (print-dl p len)
	 (print-taille len)
	 (let loop ((i 0)
		    (p p))
	    (cond
	       ((=fx i (-fx len 1))
		(if (pair? p)
		    (begin
		       (print-item (car p))
		       (print-item '())
		       (pair-mark-gc! p))
		    (print-item p)))
	       (else
		(let* ((mark (get-pair-mark p))
		       (vcdr (mark-old-value mark)))
		   (print-item (car p))
		   (pair-mark-gc! p)
		   (if (and (pair? vcdr)
			    (let ((mark (get-pair-mark vcdr)))
			       (or (> (mark-ref-count mark) 0)
				   (mark-defined? mark))))
		       (print-item vcdr)
		       (loop (+fx i 1) vcdr)))))))
      (define (print-item item)
	 (cond
	    ((symbol? item)
	     (cond
		((mark-defined? (get-symbol-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-symbol-mark item)))
		 (mark-ref-count-set! (get-symbol-mark item)
				      (-fx (mark-ref-count
					    (get-symbol-mark item))
					   1))
		 (if (=fx (mark-ref-count (get-symbol-mark item)) 0)
		     (symbol-unmark! item)))
		((=fx (mark-ref-count (get-symbol-mark item)) 0)
		 (symbol-unmark! item)
		 (print-marqueur #\')
		 (let ((s (symbol->string item)))
		    (print-ds s (string-length s))))
		(else
		 (let ((ref  (get-new-ref))
		       (mark (get-symbol-mark item)))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-marqueur #\')
		    (let ((s (symbol->string item)))
		       (print-ds s (string-length s)))))))
	    ((char? item)
	     (print-marqueur #\a)
	     (print-di (char->integer item)))
	    ((cnst? item)
	     (print-marqueur #\<)
	     (print-di (cnst->integer item)))
	    ((integer? item)
	     (print-di item))
	    ((real? item)
	     (print-marqueur #\f)
	     (print-df item))
	    ((string? item)
	     (cond
		((mark-defined? (get-string-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-string-mark item)))
		 (mark-ref-count-set! (get-string-mark item)
				      (-fx (mark-ref-count
					    (get-string-mark item))
					   1))
		 (if (=fx (mark-ref-count (get-string-mark item)) 0)
		     (string-unmark! item)))
		((=fx (mark-ref-count (get-string-mark item)) 0)
		 (string-unmark! item)
		 (print-marqueur #\")
		 (print-ds item (string-length item)))
		(else
		 (let ((ref  (get-new-ref))
		       (mark (get-string-mark item)))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-marqueur #\")
		    (print-ds item (mark-old-value mark))))))
	    ((cell? item)
	     (cond
		((mark-defined? (get-cell-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-cell-mark item)))
		 (mark-ref-count-set! (get-cell-mark item)
				      (-fx (mark-ref-count
					    (get-cell-mark item))
					   1))
		 (if (=fx (mark-ref-count (get-cell-mark item)) 0)
		     (cell-unmark! item)))
		((=fx (mark-ref-count (get-cell-mark item)) 0)
		 (cell-unmark! item)
		 (print-marqueur #\!)
		 (print-item (cell-ref item)))
		(else
		 (let* ((ref  (get-new-ref))
			(mark (get-cell-mark item))
			tag
			len) 
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-marqueur #\!)
		    (print-item (mark-old-value mark))))))
	    ((pair? item)
	     (cond
		((mark-defined? (get-pair-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-pair-mark item)))
		 (pair-mark-gc! item))
		((=fx (mark-ref-count (get-pair-mark item)) 0)
		 (let ((len (marked-pair-length item)))
		    (print-marqueur #\()
		    (mark-defined?-set! (get-pair-mark item) #t)
		    (print-dl item len)))
		(else
		 (let ((ref  (get-new-ref))
		       (mark (get-pair-mark item))
		       (len  (marked-pair-length item)))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-marqueur #\()
		    (print-dl item len)))))
	    ((vector? item)
	     (cond
		((mark-defined? (get-vector-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-vector-mark item)))
		 (mark-ref-count-set! (get-vector-mark item)
				      (-fx (mark-ref-count
					    (get-vector-mark item))
					   1))
		 (if (=fx (mark-ref-count (get-vector-mark item)) 0)
		     (vector-unmark! item)))
		((=fx (mark-ref-count (get-vector-mark item)) 0)
		 (vector-unmark! item)
		 (let ((tag (vector-tag item)))
		    (if (>fx tag 0)
			(begin
			   (print-marqueur #\t)
			   (print-di tag)
			   (print-dv item (vector-length item)))
			(begin
			   (print-marqueur #\[)
			   (print-dv item (vector-length item))))))
		(else
		 (let* ((ref  (get-new-ref))
			(mark (get-vector-mark item))
			tag
			len) 
		    (begin
		       ;; il faut momentanement restorer le vecteur
		       (poke! item 1 (mark-old-value mark))
		       (set! tag (vector-tag item))
		       (set! len (vector-length item))
		       ;; on restore
		       (poke! item 1 mark))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (if (>fx tag 0)
			(begin
			   (print-marqueur #\t)
			   (print-di tag)
			   (print-dv item len))
			(begin
			   (print-marqueur #\[)
			   (print-dv item len)))))))
	    ((struct? item)
	     (cond
		((mark-defined? (get-pointer-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-pointer-mark item)))
		 (mark-ref-count-set! (get-pointer-mark item)
				      (-fx (mark-ref-count
					    (get-pointer-mark item))
					   1))
		 (if (=fx (mark-ref-count (get-pointer-mark item)) 0)
		     (pointer-unmark! item)))
		((=fx (mark-ref-count (get-pointer-mark item)) 0)
		 (pointer-unmark! item)
		 (print-marqueur #\{)
		 (print-item (struct-key item))
		 (print-du item (struct-length item)))
		(else
		 (let* ((ref  (get-new-ref))
			(mark (get-pointer-mark item))
			(len  (struct-length item))
			key
			tag)
		    (begin
		       ;; il faut momentanement restorer la structure
		       (poke! item 1 (mark-old-value mark))
		       (set! key (struct-key item))
		       ;; on restore
		       (poke! item 1 mark))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-marqueur #\{)
		    (print-item key)
		    (print-du item len)))))
	    ((procedure? item)
	     (error "obj->string" "can't extern procedure" item))
	    (else
	     (error "obj->string" "Unknown object" item))))
      (set! *string-mark* '())
      (mark-item! obj)
      (set! *pointeur* 0)
      (if (>fx *nb-ref* 0)
	  (begin
	     (print-marqueur #\c)
	     (print-di *nb-ref*)))
      (print-item obj)
      (set! *string-mark* '())
      (substring buffer 0 *pointeur*)))

;*---------------------------------------------------------------------*/
;*    mark-item! ...                                                   */
;*---------------------------------------------------------------------*/
(define (mark-item! obj)
   (let loop ((obj obj))
      (cond
	 ((pair? obj)
	  (if (pair-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-pair-mark obj)
						   *nb-ref*))
	      (let ((ocar (car obj))
		    (ocdr (cdr obj)))
		 ;; on marque la paire
		 (pair-mark! obj)
		 ;; on l'ecrit
		 (loop ocar)
		 (loop ocdr))))
	 ((cell? obj)
	  (if (cell-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-cell-mark obj)
						   *nb-ref*))
	      (let ((oref (cell-ref obj)))
		 ;; on marque la cellule
		 (cell-mark! obj)
		 ;; on l'ecrit
		 (loop oref))))
	 ((symbol? obj)
	  (if (symbol-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-symbol-mark obj)
						   *nb-ref*))
	      (symbol-mark! obj)))
	 ((not (pointer? obj))
	  'done)
	 ((string? obj)
;*---------------------------------------------------------------------*/
;*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
;*    -------------------------------------------------------------    */
;*    Attention, il faut faire tres attention, les chaines sont        */
;*    allouees de telle facon que le GC sait qu'il n'y a pas de        */
;*    ptr dedans ! Il faut donc bien attention a ce que les marks      */
;*    (des chaines) soient mises dans une listes pour qu'elles ne      */
;*    soient pas ramassees.                                            */
;*---------------------------------------------------------------------*/
	  (if (string-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-string-mark obj)
						   *nb-ref*))
	      (begin
		 (string-mark! obj)
		 (set! *string-mark* (cons (get-string-mark obj)
					   *string-mark*)))))
	 ((vector? obj)
	  (if (vector-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-vector-mark obj)
						   *nb-ref*))
	      (let ((len (vector-length obj))
		    (tag (vector-tag obj)))
		 (vector-mark! obj)
		 (let liip ((i 0))
		    (if (=fx i len)
			'done
			(begin
			   (loop (vector-ref-ur obj i))
			   (liip (+fx i 1))))))))
	 ((pointer-marked? obj) 
	  (set! *nb-ref* (incr-mark-ref-count! (get-pointer-mark obj)
					       *nb-ref*)))
	 ((struct? obj)
	  (let ((key (struct-key obj))
		(len (struct-length obj)))
	     ;; on marque la cle
	     (loop key)
	     ;; on marque la structure
	     (pointer-mark! obj)
	     (let liip ((i 0))
		(if (=fx i len)
		    'done
		    (begin
		       (loop (struct-ref obj i))
		       (liip (+fx i 1)))))))
	 (else
	  'done))))

;*---------------------------------------------------------------------*/
;*    marked-pair-length ...                                           */
;*---------------------------------------------------------------------*/
(define (marked-pair-length l)
   (let loop ((l l)
	      (r 1))
      (let* ((mark (get-pair-mark l))
	     (vcdr (mark-old-value mark)))
	 (if (pair? vcdr)
	     (let ((mark (get-pair-mark vcdr)))
		(if (or (> (mark-ref-count mark) 0)
			(mark-defined? mark))
		    (+fx r 1)
		    (loop vcdr (+fx r 1))))
	     (+fx r 1)))))

   
	 
   
   


     
      
      
   
		


