;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.7/Llib/binary.scm ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  7 10:38:25 1994                          */
;*    Last change :  Tue Jun  7 11:16:31 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les entrees/sorties compactees des objets Scheme (eventuellement */
;*    circulaires).                                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __binary
   (foreign (type binary-port obj)
            (define bool c-binary-port? (obj)
	       "BINARY_PORTP")
	    (obj c-open-output-binary-file (bstring)
		 "open_output_binary_file")
	    (obj c-append-output-binary-file (bstring)
		 "append_output_binary_file")
	    (obj c-open-input-binary-file (bstring)
		 "open_input_binary_file")
	    (obj c-close-binary-port (binary-port)
		 "close_binary_port")
	    (obj c-input-obj  (binary-port)
		 "input_obj")
	    (obj c-output-obj (binary-port obj)
		 "output_obj"))
   (export  (inline binary-port?              obj)
	    (inline open-output-binary-file   str)
	    (inline append-output-binary-file str)
	    (inline open-input-binary-file    str)
	    (inline close-binary-port         port)
	    (inline input-obj                 port)
	    (inline output-obj                port obj)))

;*---------------------------------------------------------------------*/
;*    binary-port? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (binary-port? obj)
   (c-binary-port? obj))

;*---------------------------------------------------------------------*/
;*    open-output-binary-file ...                                      */
;*---------------------------------------------------------------------*/
(define-inline (open-output-binary-file str)
   (c-open-output-binary-file str))

;*---------------------------------------------------------------------*/
;*    append-output_binary-file ...                                    */
;*---------------------------------------------------------------------*/
(define-inline (append-output-binary-file str)
   (c-append-output-binary-file str))

;*---------------------------------------------------------------------*/
;*    open-input-binary-file ...                                       */
;*---------------------------------------------------------------------*/
(define-inline (open-input-binary-file str)
   (c-open-input-binary-file str))

;*---------------------------------------------------------------------*/
;*    close-binary-port ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (close-binary-port port)
   (c-close-binary-port port))

;*---------------------------------------------------------------------*/
;*    input-obj ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (input-obj port)
   (c-input-obj port))

;*---------------------------------------------------------------------*/
;*    output-obj ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (output-obj port obj)
   (c-output-obj port obj))
	    
   
