/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.7/Include/bigloo.h ...      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Sep  1 17:15:00 1993                          */
/*    Last change :  Wed Jan 18 16:34:23 1995 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Les choses de `Bigloo'                                           */
/*=====================================================================*/
#ifndef BIGLOO_H
#define BIGLOO_H

#if defined( NULL )
#   undef NULL
#endif

/*---------------------------------------------------------------------*/
/*    Les includes indispensables                                      */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <setjmp.h>
#include <errno.h>
#if( defined( sun ) && defined( sparc ) )
#   include <stdlib.h>
#endif
#include <math.h>
#if defined( sony_news )
#   include <news/machparam.h>
#endif
#include <limits.h>

/*---------------------------------------------------------------------*/
/*    Les sites ou sont ranges les libraries et les includes           */
/*---------------------------------------------------------------------*/
#define LIBRARY_DIR() "/home/cornas/icsla/serrano/prgm/project/bigloo/lib/1.7"
#define INCLUDE_DIR() "/home/cornas/icsla/serrano/prgm/project/bigloo/lib/1.7"
#define CC() "gcc"
/*---------------------------------------------------------------------*/
/*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
/*    Attention, le trois macros ci-dessus doivent imperativement etre */
/*    ligne 35 et 37 (pour la distribution)                            */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Le type booleen (je ne veux plus fixer que c'est unsigned char)  */
/*---------------------------------------------------------------------*/
#define bool_t int

/*---------------------------------------------------------------------*/
/*    Quelques macros system dependant                                 */
/*---------------------------------------------------------------------*/
#define DOWN 55
#define UP   66

/*--- Les casts pour `longjmp'/`setjmp' -------------------------------*/
#define JMP_BUF void
#define JMP_VAL int

/*--- La configuration machine dependente -----------------------------*/
#if defined( SPARC ) || defined( sparc )
#   if( !defined( SPARC ) )
#      define SPARC
#   endif
#   include <sys/signal.h>
#   define STACK_GROWS DOWN
#   define PTR_ALIGNMENT 2
    /* Le nombre de fenetre de registre sur sparc */
#   define BIG_ENDIAN
#   if defined( __svr4__ )
#      include <sys/regset.h>
#      define SETJMP setjmp
#      define LONGJMP longjmp
#      define bzero( ptr, len ) memset( ptr, 0L, len )
#      define bcopy( src, dst, len ) memcpy( dst, src, len )
#   else
#      define SETJMP  _setjmp
#      define LONGJMP _longjmp
#   endif
#   define NB_WINDOW_REGISTER SPARC_MAXREGWINDOW
#else
#   if( defined( PYR ) || defined( pyr ) \
        || (defined( sony_news ) && defined( r3000 )) )
#      define STACK_GROWS DOWN
#      define PTR_ALIGNMENT 2
#      define BIG_ENDIAN
#      define SETJMP  _setjmp
#      define LONGJMP _longjmp
#   else
#      if( defined( i386 ) )
#         define STACK_GROWS DOWN
#         define PTR_ALIGNMENT 2
#         if( !defined( LITTLE_ENDIAN ) )
#            define LITTLE_ENDIAN
#         endif
#         undef SIGBUS
#         define SIGBUS SIGUSR1
#         define SETJMP  _setjmp
#         define LONGJMP _longjmp
#      else
#         if( defined( __pa_risc ) || defined(_PA_RISC1_0) || defined(_PA_RISC1_1) )
#            define STACK_GROWS UP
#            define PTR_ALIGNMENT 2
#            define BIG_ENDIAN
#            define SIGBUS _SIGBUS
#            define SETJMP  _setjmp
#            define LONGJMP _longjmp
#         else
#            if( defined( sun ) && defined( mc68000 ) )
#               define STACK_GROWS DOWN
#               define PTR_ALIGNMENT 2
#               define BIG_ENDIAN
#               define SETJMP  _setjmp
#               define LONGJMP _longjmp
#            else
                /* thank's to Drew Whitehouse [Drew.Whitehouse@anu.edu.au] */
#               if( defined( sgi) || defined( ultrix ) && defined( mips ) )
#                  define STACK_GROWS DOWN
#                  define PTR_ALIGNMENT 2
#                  if defined( ultrix ) && defined( mips )
#                     define LITTLE_ENDIAN
#                  else
#                     define BIG_ENDIAN
#                  endif
#                  define SETJMP  _setjmp
#                  define LONGJMP _longjmp
#               else
#                  if( defined( _IBMR2 ) )
#                     define STACK_GROWS DOWN
#                     define PTR_ALIGNMENT 2
#                     define SETJMP  setjmp
#                     define LONGJMP longjmp
#                  else
#                     if( defined( NeXT ) && defined( mc68000 ) )
#                        define STACK_GROWS DOWN
#                        define PTR_ALIGNMENT 2
#                        define BIG_ENDIAN
#                        define SETJMP  setjmp
#                        define LONGJMP longjmp
#                     else
#                        if( defined( __alpha ) )
#                           define STACK_GROWS DOWN
#                           define PTR_ALIGNMENT 3
#                           define SETJMP  _setjmp
#                           define LONGJMP _longjmp
#                           define LITTLE_ENDIAN
#                        else
                            --> error "I need to know the way the c-stack grows, see `public/grows.c'"
#                        endif
#                     endif
#                  endif
#               endif                   
#            endif
#         endif
#      endif
#   endif
#endif

#if( !defined( NB_WINDOW_REGISTER ) )
#   define NB_WINDOW_REGISTER 0
#endif


/*---------------------------------------------------------------------*/
/*    Quelques messages d'erreur personnel.                            */
/*---------------------------------------------------------------------*/
#define EHEAP       500  /* Pas assez de memoire pour allouer le tas   */
#define EMEMORY     501  /* Plus assez de place dans le tas            */
#define ETARGS      502  /* on passe trop d'args a apply               */

/*---------------------------------------------------------------------*/
/*    Les macros du GC ...                                             */
/*---------------------------------------------------------------------*/
#define NO_GC            1
#define BOEHM_GC         2

#define GC BOEHM_GC
#define BOEHM_GC_VERSION 4

/*---------------------------------------------------------------------*/
/*    Il y a plusieurs formes d'objets:                                */
/*    Les objets allouees:                                             */
/*            +--------+--------+--------+--------+                    */
/*            |....signed fixed point value.....??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*    Les objets immediats 30 bits:                                    */
/*            +--------+--------+--------+--------+                    */
/*            |....signed fixed point value.....??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*    Les objets immediats 6 bits:                                     */
/*            +--------+--------+--------+--------+                    */
/*            |..........................|xxxxxx??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*    Les objets immediats 8 bits:                                     */
/*            +--------+--------+--------+--------+                    */
/*            |.................|xxxxxxxx|......??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Ou sont les `tags' et quel `mask' cela represente.               */
/*---------------------------------------------------------------------*/
#define TAG_SHIFT      PTR_ALIGNMENT
#define TAG_MASK       ((1 << PTR_ALIGNMENT) - 1)

/*---------------------------------------------------------------------*/
/*    Les `tags' des pointeurs  ...                                    */
/*---------------------------------------------------------------------*/
#if( GC == BOEHM_GC ) 
#   define TAG_INT       1     /*  Les integer sont tagues  ....01     */
#   define TAG_CNST      2     /*  Les cnsts sont taguees   ....10     */
#   define TAG_STRUCT    0     /*  Les pointer sont tagues  ....00     */
#   define TAG_PAIR      3     /*  Les pairs sont taguees   ....11     */
#else
#   if( GC == NO_GC )
#      define TAG_INT    0     /*  Les integer sont tagues  ....00     */
#      define TAG_CNST   2     /*  Les cnsts sont taguees   ....10     */
#      define TAG_STRUCT 1     /*  Les pointer sont tagues  ....01     */
#      define TAG_PAIR   3     /*  Les pairs sont taguees   ....11     */
#   else
       --> error "Unknown garbage collector type"
#   endif
#endif

/*---------------------------------------------------------------------*/
/*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
/*    -------------------------------------------------------------    */
/*    Il faut faire tres attention quand on rajoute des tags pour des  */
/*    machines particulieres. En particulier, il faut s'assurer que    */
/*    les fonctions `string->obj' et `obj->string' restent correctes.  */
/*    Ces deux fonctions utilisent la representation des objets.       */
/*    Voir les macros d'internement dans ce fichier                    */
/*    (STRING_MARK_OFFSET, ...)                                        */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Sur les machines 64 bits, on utilise 3 bits de tag. On a donc    */
/*    les configurations suivantes:                                    */
/*    -------------------------------------------------------------    */
/*    +--------+--------+--------+- ... -+--------+--------+--------+  */
/*    |..................signed fixed point value............... ???|  */
/*    +--------+--------+--------+- ... -+--------+--------+--------+  */
/*                                                                     */
/*    Les vecteurs:                                                    */
/*    +--------+--------+--------+- ... -+--------+--------+--------+  */
/*    |.................unsigned fixed point value.............. ???|  */
/*    +--------+--------+--------+- ... -+--------+--------+--------+  */
/*                                                                     */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Les `tags' sur 3 bits.                                           */
/*---------------------------------------------------------------------*/
#if( PTR_ALIGNEMENT >= 3 )
#   define TAG_VECTOR    4     /*  Les vecteurs sont tagues ...100     */
#   define TAG_CELL      5     /*  Les vecteurs sont tagues ...101     */
#   define TAG_REAL      6     /*  Les reals                ...110     */
#   define TAG_STRING    7     /*  Les strings              ...111     */
#endif

/*---------------------------------------------------------------------*/
/*    La taille de la table hashage                                    */
/*---------------------------------------------------------------------*/
#define HASH_TABLE_SIZE_SHIFT 12
#define HASH_TABLE_SIZE       (1 << HASH_TABLE_SIZE_SHIFT)

/*---------------------------------------------------------------------*/
/*    Les `header' des structures ...                                  */
/*---------------------------------------------------------------------*/
#define HEADER_PAIR                  ((header_t)BINT( 0 ))
#define HEADER_STRING                ((header_t)BINT( 1 ))
#define HEADER_VECTOR                ((header_t)BINT( 2 ))
#define HEADER_PROCEDURE             ((header_t)BINT( 3 ))
#define HEADER_TRUE                  ((header_t)BINT( 4 ))
#define HEADER_FALSE                 ((header_t)BINT( 5 ))
#define HEADER_UNSPEC                ((header_t)BINT( 6 ))
#define HEADER_SYMBOL                ((header_t)BINT( 8 ))
#define HEADER_STACK                 ((header_t)BINT( 9 ))
#define HEADER_INPUT_PORT            ((header_t)BINT( 10 ))
#define HEADER_OUTPUT_PORT           ((header_t)BINT( 11 ))
#define HEADER_RGRAMMAR              ((header_t)BINT( 12 ))
#define HEADER_CELL                  ((header_t)BINT( 13 ))
#define HEADER_EOF                   ((header_t)BINT( 14 ))
#define HEADER_STRUCT                ((header_t)BINT( 15 ))
#define HEADER_REAL                  ((header_t)BINT( 16 ))
#define HEADER_EOA                   ((header_t)BINT( 17 ))
#define HEADER_FOREIGN               ((header_t)BINT( 18 ))
#define HEADER_OUTPUT_STRING_PORT    ((header_t)BINT( 19 ))
#define HEADER_BINARY_PORT           ((header_t)BINT( 20 ))
#define HEADER_EXTENDED_PAIR         ((header_t)BINT( 21 ))

/*---------------------------------------------------------------------*/
/*    Les differents objects `Sqic' :                                  */
/*---------------------------------------------------------------------*/
typedef long  int_t;
typedef int_t header_t;

typedef union object {
   int_t              integer;   /*  Les entiers                       */
   
   header_t           header;    /*  Un champs un peu fictif mais      */
                                 /*  il est utile pour pouvoir acceder */
                                 /*  au header des objets sans savoir  */
                                 /*  quel est leur type. Tous les      */
                                 /*  headers sont en tete des struct   */
                                 /*  on peut donc le header global     */
                                 /*  plutot que les header locaux      */
   
   struct pair {                 /*  Les pairs.                        */
#if( !(defined( TAG_PAIR ) ) )            
      header_t        header;    /*  Le header est facultatif, il      */
#endif      
      union object   *car;       /*  depend du GC qu'on utilise.       */
      union object   *cdr;       /*  Dans tous les cas, il y a biensur */
   } pair_t;                     /*  un `car' et un `cdr' :-)          */

   struct extended_pair {        /*  Les pairs etendues.               */
#if( !(defined( TAG_PAIR ) ) )            
      header_t        header;    /*  Le header est facultatif, il      */
#endif                           /*  depend de l'utilisation des bits  */
      union object   *car;       
      union object   *cdr;
		header_t        eheader;   /*  header pour la marque `extended'  */
		union object   *cer;       /*  le slot supplementaire.           */
   } extended_pair_t;                     

#if( defined( ALLOCATE_CONSTANT ) )
   struct boolean {              /*  Les booleens qui sont au nombre   */
      header_t        header;    /*  de 2: true et false               */
   } boolean_t;
#endif

   struct string {               /*  Les chaines de char, juste une    */
#if( !defined( TAG_STRING ) ) 		
      header_t        header;    /*  longueur, la chaine C suit.       */
#endif		
      union object   *length;
   } string_t;

   struct vector {               /*  Les vecteurs, un header et une    */
#if( !defined( TAG_VECTOR ) )		
      header_t        header;    /*  taille (ATTENTION: sur 22 bits,   */
#endif		
      union object   *length;    /*  voir la macro vector-length).     */
   } vector_t;

   struct procedure {            /*  Les fermetures                    */
      header_t        header;    
      union object *(*entry)();
      union object *(*va_entry)();
      long            arity;       
      void            *env;      /*  Ce champs est utilise pour etre   */
   } procedure_t;                /*  sur que l'alignement est correct. */

   struct procedure_light {      /*  Les fermetures legeres            */
      union object *(*entry)();
      void           *env;
   } procedure_light_t;
   
   struct procedure_extra_light {/*  Les fermetures extra-legeres:     */
      void           *env;
   } procedure_extra_light_t;
   
   struct symbol {               /*  Les symboles, un nom et une       */
      header_t        header;    /*  valeur                            */
      char           *name;
      union object   *cval;
   } symbol_t;

   struct output_port {          /*  Les output_port                   */
      header_t        header;    /*  grosso-modo cette structure       */
      FILE           *file;      /*  comporte juste un file et son nom */
      char           *name;
   } output_port_t;

	struct output_string_port {   /*  Les output_string_port            */
		header_t        header;    /*  Cette structure comporte:         */
      char           *buffer;    /*  - un buffer                       */
		long            size;      /*  - une taille                      */
      long            offset;    /*  - un offset                       */
   } output_string_port_t;
	
   struct input_port {           /*  Les input_port                    */
      header_t        header;    /*  un input_port est:                */
      union object   *class;     /*    - une classe                    */
      char           *name;      /*    - une chaine                    */
      FILE           *file;      /*    - un file                       */
		long            filepos;   /*    - la position du match          */
      union object   *bufsiz;    /*    - une taille                    */
      union object   *eof;       /*    - un flag                       */
      union object   *backward;  /*    - un backward                   */
      union object   *forward;   /*    - un forward                    */
      union object   *remember;  /*    - un souvenir                   */
      union object   *mark;      /*    - un marqueur                   */
		char           *annexe;    /*    - une annexe (cf grands tokens) */
		union object   *anxsiz;    /*    - la taille de l'annexe         */
      char           *buffer;    /*    - un buffer                     */
   } input_port_t;

	struct binary_port {          /*  Les binary_port                   */
		header_t        header;    /*  ces ports sont constitues de:     */
		char           *name;      /*    - un nom de fichier             */
		FILE           *file;      /*    - un pointeur sur un fichier    */
		bool_t          io;        /*    - 0 en entree 1 en sortie       */
	} binary_port_t;
	
   struct cell {                 /*  Les cellules. Ces objets sont     */
#if( !defined( TAG_CELL ) )		
      header_t        header;    /*  utilisees quand il y a des var    */
#endif		
      union object   *obj;       /*  capturees qui sont en plus ecrite */
   } cell_t;

   struct structure {            /*  Les structures,                   */
#if( !defined( TAG_STRUCTURE ) )		
      header_t        header;    /*  sont constituees de :             */
#endif		
      union object   *key;       /*                      - une cle     */
      union object   *length;    /*                      - une long.   */
      union object   *slot;      /*                      - des slots   */
   } struct_t;

   struct real {                 /*  Les nombres flottants             */
#if( !defined( TAG_REAL ) )		
      header_t        header;    /*  ce champs est juste utile pour    */
#   if( defined( i386 ) )			/*  etre sur que le double est aligne */
		union object   *dummy;     /*  sur 8 octets (pour les 32 bits).  */
#   endif		                  /*  Cf. intext.scm (pointer-marked?)  */
#endif		                     /*  (sur les PC).                     */
      double          real;      
   } real_t;                     

   struct stack {                /*  Les piles de `call/cc'            */
      header_t        header;    /*  sont:                             */
      union object   *self;      /*        - un ptr sur soit meme      */
      union object   *size;      /*        - une taille                */
      void           *stack;     /*        - un espace memoire         */
   } stack_t;

   struct foreign {              /*  Les types etrangers               */
      header_t        header;    
      union object   *id;
      void           *value;
   } foreign_t;
} *obj_t;

typedef obj_t (*function_t)();

/*---------------------------------------------------------------------*/
/*    Les procedures d'allocations                                     */
/*---------------------------------------------------------------------*/
#if( GC == DELACOUR_GC )
#   define ALLOCATE( size )
#   define ALLOCATE_ATOMIC( size )
#   define INLINE_ALLOCATE( size )
#   define INLINE_ALLOCATE_ATOMIC( size )
#   define INIT_ALLOCATION() 1
#   define FREE_ALLOCATION() 1
#else
#   if( GC == BOEHM_GC )
#      if( !defined( GC_PRIVATE_H ) )
          extern obj_t GC_malloc();
          extern obj_t GC_malloc_atomic();
#      endif
#      if( defined( GC_DEBUG ) )
#         if( !defined( GC_PRIVATE_H ) )
             extern obj_t GC_debug_malloc();
             extern obj_t GC_debug_malloc_atomic();
#         endif
#         define GC_malloc         GC_debug_malloc
#         define GC_malloc_atomic  GC_debug_malloc_atomic
#      endif
#      define ALLOCATE( size ) (obj_t)(GC_malloc( size ))
#      define ALLOCATE_ATOMIC( size ) GC_malloc_atomic( size )
#      define INLINE_ALLOCATE( size ) (obj_t)(GC_malloc( size ))
#      define INLINE_ALLOCATE_ATOMIC( size ) GC_malloc_atomic( size )

/*  A supprimer des que Boehm aura corrige GC_register_displacement */
/*  dans son GC.                                                    */
#      if( !defined( GC_REGISTER_DISPLACEMENT ) )
#         if( defined( GC_DEBUG ))
#            define GC_REGISTER_DISPLACEMENT( o ) GC_debug_register_displacement( o )
#         else
#            define GC_REGISTER_DISPLACEMENT( o ) GC_register_displacement( o )
#         endif
#      endif

#      if( defined( TAG_STRUCT ) && ( TAG_STRUCT != 0) )
#         define STRUCT_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_STRUCT ) 
#      else
#         define STRUCT_DISPLACEMENT() 0
#      endif
#      if( defined( TAG_PAIR ) && ( TAG_PAIR != 0) )
#         define PAIR_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_PAIR ) 
#      else
#         define PAIR_DISPLACEMENT() 0
#      endif
#      if( defined( TAG_PAIR ) && ( TAG_PAIR != 0) )
#         define PAIR_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_PAIR ) 
#      else
#         define PAIR_DISPLACEMENT() 0
#      endif
#      if( defined( TAG_VECTOR ) && ( TAG_VECTOR != 0) )
#         define VECTOR_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_VECTOR ) 
#      else
#         define VECTOR_DISPLACEMENT() 0
#      endif
#      if( defined( TAG_CELL ) && ( TAG_CELL != 0) )
#         define CELL_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_CELL ) 
#      else
#         define CELL_DISPLACEMENT() 0
#      endif
#      if( defined( TAG_STRUCTURE ) && ( TAG_STRUCTURE != 0) )
#         define STRUCTURE_DISPLACEMENT() \
             GC_REGISTER_DISPLACEMENT( TAG_STRUCTURE ) 
#      else
#         define STRUCTURE_DISPLACEMENT() 0
#      endif
#      if( defined( TAG_STRING ) && ( TAG_STRING != 0) )
#         define STRING_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_STRING ) 
#      else
#         define STRING_DISPLACEMENT() 0
#      endif

#      define INIT_ALLOCATION( size )                                  \
          ( GC_init(),                                                 \
            GC_expand_hp( size ),                                      \
			   STRUCT_DISPLACEMENT(),                                     \
			   PAIR_DISPLACEMENT(),                                       \
			   VECTOR_DISPLACEMENT(),                                     \
			   CELL_DISPLACEMENT(),                                       \
			   STRUCTURE_DISPLACEMENT(),                                  \
			   STRING_DISPLACEMENT(),                                     \
            1 )
#      define FREE_ALLOCATION();
#   else
#      if( GC == NO_GC )
          extern obj_t heap_alloc();
#         define ALLOCATE( size ) heap_alloc( size )
#         define ALLOCATE_ATOMIC( size ) ALLOCATE( size )
#         define INLINE_ALLOCATE( size ) ALLOCATE( size )
#         define INLINE_ALLOCATE_ATOMIC( size ) ALLOCATE( size )
#         define INIT_ALLOCATION( size ) init_heap( size )
#         define FREE_ALLOCATION() free_heap()
#      else
          --> error "Unknown garbage collector type"
#      endif                
#  endif          
#endif

/*---------------------------------------------------------------------*/
/*    Les macros qui servent a taguer/detaguer                         */
/*---------------------------------------------------------------------*/
#define TAG( val, shift, tag )   ((long)(((long)(val) << shift) | tag))
#define UNTAG( val, shift, tag ) ((long)((long)(val) >> shift))

/*---------------------------------------------------------------------*/
/*    Les macros de conversions utilisees par `Sqic'                   */
/*    -------------------------------------------------------------    */
/*    Attention, il est normal que pour faire la conversion `bigloo->c'*/
/*    j'utilise une soustraction et non pas un `and'. En faisant comme */
/*    ca, le compilateur C peut bien optimiser les access aux          */
/*    differents champs.                                               */
/*---------------------------------------------------------------------*/
#define BINT( i )          (obj_t)TAG( i, TAG_SHIFT, TAG_INT )
#define CINT( i )          (long)UNTAG( i, TAG_SHIFT, TAG_INT )

#define BREF( r )          ((obj_t)((long)r | TAG_STRUCT))
#define CREF( r )          ((obj_t)((long)r - TAG_STRUCT))

#define BLIGHT( l )        BPAIR( l )
#define CLIGHT( l )        CPAIR( l )

#if( defined( TAG_PAIR ) )
#   define BPAIR( p )      ((obj_t)((long)p | TAG_PAIR))
#   define CPAIR( p )      ((obj_t)((long)p - TAG_PAIR))
#else
#   define BPAIR( p )      BREF( p )
#   define CPAIR( p )      CREF( p )
#endif

#if( defined( TAG_CELL ) )
#   define BCELL( r )      ((obj_t)((long)p | TAG_CELL))
#   define CCELL( p )      ((obj_t)((long)p - TAG_CELL))
#else
#   define BCELL( p )      BREF( p )
#   define CCELL( p )      CREF( p )
#endif

#if( defined( TAG_VECTOR ) )
#   define BVECTOR( r )    ((obj_t)((long)p | TAG_VECTOR))
#   define CVECTOR( p )    ((obj_t)((long)p - TAG_VECTOR))
#else
#   define BVECTOR( p )    BREF( p )
#   define CVECTOR( p )    CREF( p )
#endif

#if( defined( TAG_STRUCTURE ) )
#   define BSTRUCTURE( r ) ((obj_t)((long)p | TAG_STRUCTURE))
#   define CSTRUCTURE( p ) ((obj_t)((long)p - TAG_STRUCTURE))
#else
#   define BSTRUCTURE( p ) BREF( p )
#   define CSTRUCTURE( p ) CREF( p )
#endif

#if( defined( TAG_STRING ) )
#   define BSTRING( r )    ((obj_t)((long)p | TAG_STRING))
#   define CSTRING( p )    ((obj_t)((long)p - TAG_STRING))
#else
#   define BSTRING( p )    BREF( p )
#   define CSTRING( p )    CREF( p )
#endif

#if( defined( TAG_REAL ) )
#   define BREAL( p )      ((obj_t)((long)p | TAG_REAL))
#   define CREAL( p )      ((obj_t)((long)p - TAG_REAL))
#else
#   define BREAL( p )      BREF( p )
#   define CREAL( p )      CREF( p )
#endif

#define BFUN( f )          ((obj_t)(f))
#define CFUN( f )          ((obj_t (*)())(f))

#define BCNST( c )         (obj_t)TAG( c, TAG_SHIFT, TAG_CNST )
#define CCNST( c )         (long)UNTAG( c, TAG_SHIFT, TAG_CNST )

#define BCONT( c )         ((obj_t)(c))
#define CCONT( c )         (c)

#define TRUEP( c )         ((bool_t)(c != BFALSE))

#define CHAR_SHIFT         (TAG_SHIFT + 6)
#define BCHAR( i )         ((obj_t)((long)BCHARH + \
											  ((long)((unsigned char)(i) << CHAR_SHIFT))))
#define CCHAR( i )         (char)((long)(i)>>CHAR_SHIFT)

#define CTRUE              ((bool_t)1)
#define CFALSE             ((bool_t)0)

#define FAILURE( p, m, o ) return( the_failure( p, m, o ) )

#define FUNCTION_ADDRESS( f ) (function_t)(&(f))

/*---------------------------------------------------------------------*/
/*    Le `CASTING'                                                     */
/*---------------------------------------------------------------------*/
#define CBOOL_TO_BBOOL( o ) (o ? BTRUE : BFALSE )
#define BBOOL_TO_CBOOL( o ) (o != BFALSE)

#define CSTRING_TO_BSTRING( s ) c_string_to_string( s )
#define BSTRING_TO_CSTRING( s ) ((char *)CSTRING( s ) + STRING_SIZE)

#define CHAR_TO_INT( c ) BINT( (unsigned char)(CCHAR( c )) )
#define INT_TO_CHAR( i ) BCHAR( CINT( i ) )

#define DOUBLE_TO_REAL( d ) (make_real( d ))
#define REAL_TO_DOUBLE( r ) (REAL( r ).real)

#define CVOID_TO_BVOID( e ) (e, BUNSPEC)
#define BVOID_TO_CVOID( e ) ((void)e) 

/*---------------------------------------------------------------------*/
/*    Les `constantes' peuvent etre soit allouees soit constante.      */
/*---------------------------------------------------------------------*/
#if defined( ALLOCATE_CONSTANT )
#   define BNIL          nil_object
#   define BFALSE        false_object
#   define BTRUE         true_object
#   define BUNSPEC       unspec_object
#   define BEOF          end_of_file_object
#   define BEOA          end_of_argument_object
    extern obj_t nil_object, unspec_object, end_of_file_object;
    extern obj_t true_object, false_object;
#else
#   define BNIL          ((obj_t)BCNST( 0 ))
#   define BFALSE        ((obj_t)BCNST( 1 ))
#   define BTRUE         ((obj_t)BCNST( 2 ))
#   define BUNSPEC       ((obj_t)BCNST( 3 ))
#   define BCHARH        ((obj_t)BCNST( 5 ))
#   define BEOF          ((obj_t)BCNST( 0x100 ))
#   define BEOA          ((obj_t)BCNST( 0x101 ))
#endif

/*---------------------------------------------------------------------*/
/*    Les macros GENERALES                                             */
/*    -------------------------------------------------------------    */
/*    Les macros concernant tous les objects. On trouve ici les        */
/*    macros qui ne sont pas propre a une categorie d'object en        */
/*    particulier.                                                     */
/*---------------------------------------------------------------------*/
#define OBJ_SIZE               ((long)(sizeof( ((obj_t)0) ) ))
#define HEADER( o )            (CREF( o )->header)

#if( TAG_STRUCT != 0 )
#   define POINTERP( o )       ((((long)o) & TAG_MASK) == TAG_STRUCT)
#else
#   define POINTERP( o )       (o && ((((long)o) & TAG_MASK) == TAG_STRUCT))
#endif

#if( TAG_CNST != 0 )
#   define CNSTP( o )          ((((long)o) & TAG_MASK) == TAG_CNST)
#else
#   define CNSTP( o )          (o && ((((long)o) & TAG_MASK) == TAG_CNST))
#endif

#if( TAG_SHIFT <= LONG_MAX )
#   define BOUND_CHECK( o, v ) ((unsigned long)o < (unsigned long)v)
#else
#   define BOUND_CHECK( o, v ) (((long)o >= 0) && ((long)o < (long)v))
#endif

/*---------------------------------------------------------------------*/
/*    Les deux macros les plus dangeureuses de la terre. A n'          */
/*    utilisez que si on sait vraiment ce qu'on fait.                  */
/*---------------------------------------------------------------------*/
#define PEEK( v, i ) (*((obj_t *)(((long)CREF( v )) + (OBJ_SIZE * CINT( i )))))
#define POKE( var, i, val ) (PEEK( var, i ) = val, var)

/*---------------------------------------------------------------------*/
/*    Il existe plusieurs procedures d'allocation. Les `atomic'        */
/*    concernent les allocations qui ne contiennent pas de pointer.    */
/*---------------------------------------------------------------------*/
#define MAKE_OBJECT( size, head, an_object )                            \
   (an_object = ALLOCATE( size ),                                       \
    an_object->header = head, an_object)

#define MAKE_INLINE_OBJECT( size, head, an_object )                     \
   (an_object = INLINE_ALLOCATE( size ),                                \
    an_object->header = head, an_object)

#define MAKE_ATOMIC_OBJECT( size, head, an_object )                     \
   (an_object = ALLOCATE_ATOMIC( size ),                                \
    an_object->header = head, an_object)

#define EQP( o1, o2 ) ((long)o1 == (long)o2)

#define BOOLEANP( o ) (((long)o == (long)BTRUE) || ((long)o == (long)BFALSE))

#define NOT( o ) (!o)   

/*---------------------------------------------------------------------*/
/*    La manipulation des SYMBOLS (brrr !)                             */
/*---------------------------------------------------------------------*/
#define SYMBOLP( o ) (POINTERP( o ) && (HEADER( o ) == HEADER_SYMBOL))

#define SYMBOL( o )  (CREF( o )->symbol_t)
   
#define GET_HASH_NUMBER( s ) (obj_t)(get_hash_number( SYMBOL( s ).name ))

#define SYMBOL_SIZE (sizeof( ((obj_t)0)->symbol_t ))

#define SYMBOL_TO_STRING( o ) c_string_to_string( SYMBOL( o ).name )

#define GET_SYMBOL_PLIST( o ) (SYMBOL( o ).cval)

#define SET_SYMBOL_PLIST( o, v ) (GET_SYMBOL_PLIST( o ) = v)

/*---------------------------------------------------------------------*/
/*    le trippotage des PAIRs et des EXTENDED_PAIRs                    */
/*---------------------------------------------------------------------*/
#define PAIR_SIZE          (sizeof( ((obj_t)0)->pair_t ))
#define EXTENDED_PAIR_SIZE (sizeof( ((obj_t)0)->extended_pair_t ))

#define PAIR( o )  (CPAIR( o )->pair_t)
#define EPAIR( o ) (CPAIR( o )->extended_pair_t)

#if( GC == BOEHM_GC )
    extern obj_t make_pair();

#   define MAKE_PAIR( a, d ) make_pair( a, d )
#   define MAKE_INLINE_PAIR( a, d ) MAKE_PAIR( a, d )

#else
#   if( defined( __GNUC__ ) )
#      define MAKE_PAIR( a, d )                                        \
          ( { obj_t a_pair, an_object;                                 \
              a_pair = MAKE_INLINE_OBJECT( PAIR_SIZE, HEADER_PAIR,     \
												       an_object );                \
              a_pair->pair_t.car = a;                                  \
              a_pair->pair_t.cdr = d;                                  \
              BPAIR( a_pair ); } )
#   else
#      define MAKE_PAIR( a, d )                                        \
         (a_pair = MAKE_INLINE_OBJECT( PAIR_SIZE, HEADER_PAIR,         \
												   an_object ),                    \
          a_pair->pair_t.car = a,                                      \
          a_pair->pair_t.cdr = d,                                      \
          BPAIR( a_pair ) )
#   endif
#   define MAKE_INLINE_PAIR( a, d ) MAKE_PAIR( a, d )      
#endif

#define INIT_STACK_PAIR( p, a, d ) ( p.car = (a), p.cdr = (d), p )
#define SPAIR_REF( p ) BPAIR( &p )

#if( defined( __GNUC__ ) )
#   define MAKE_EXTENDED_PAIR( a, d, e )                               \
      ( { obj_t a_pair, an_object;                                     \
    		 a_pair = MAKE_OBJECT( EXTENDED_PAIR_SIZE, HEADER_PAIR,       \
										  an_object );                           \
			 a_pair->extended_pair_t.car = a;                             \
			 a_pair->extended_pair_t.cdr = d;                             \
			 a_pair->extended_pair_t.cer = e;                             \
			 a_pair->extended_pair_t.eheader = HEADER_EXTENDED_PAIR;      \
			 BPAIR( a_pair ); } )
#else
#   define MAKE_EXTENDED_PAIR( a, d, e )                               \
      (  a_pair = MAKE_OBJECT( EXTENDED_PAIR_SIZE, HEADER_PAIR,        \
										 an_object ),                            \
			 a_pair->extended_pair_t.car = a,                             \
			 a_pair->extended_pair_t.cdr = d,                             \
			 a_pair->extended_pair_t.cer = e,                             \
			 a_pair->extended_pair_t.eheader = HEADER_EXTENDED_PAIR,      \
			 BPAIR( a_pair ) )
#endif

#if( !(defined( TAG_PAIR ) ) )
#   define PAIRP( c ) (POINTERP( c ) && (HEADER( c ) == HEADER_PAIR))
#else
#   define PAIRP( c ) ((c && ((((long)c)&TAG_MASK) == TAG_PAIR)))
#endif

#define EXTENDED_PAIRP( c )                                            \
   ( PAIRP( c ) &&  (EPAIR( c ).eheader == HEADER_EXTENDED_PAIR) )

#define NULLP( c ) ((long)(c) == (long)BNIL)

#define CAR( c )        (PAIR( c ).car)
#define CDR( c )        (PAIR( c ).cdr)
#define CER( c )        (EPAIR( c ).cer)

#define SET_CAR( c, v ) ((CAR( c ) = v), c)
#define SET_CDR( c, v ) ((CDR( c ) = v), c)
#define SET_CER( c, v ) ((CER( c ) = v), c)

/*---------------------------------------------------------------------*/
/*    Les CHARs                                                        */
/*---------------------------------------------------------------------*/
#define CHARP( o ) \
   (((long)(o) & (long)((1 << (CHAR_SHIFT)) -1)) == (long)BCHARH)

/* Soit pour des FILE soit pour des STRING */
#define WRITE_CHAR( o, p )               \
   ( OUTPUT_STRING_PORTP( p ) ?          \
	    strputc( CCHAR( o ), p ) :        \
       ((obj_t)(fputc( CCHAR( o ), OUTPUT_PORT( p ).file )), o) )

/* la meme mais juste pour les FILE C */
#define WRITE_CHAR_F( o, p )       \
   ( (obj_t)(fputc( (long)CCHAR( o ), OUTPUT_PORT( p ).file )), o )

#define CHAR_LT( o1, o2 ) ((long)o1 < (long)o2)
   
#define CHAR_GT( o1, o2 ) ((long)o1 > (long)o2)
   
#define CHAR_LE( o1, o2 ) ((long)o1 <= (long)o2)
   
#define CHAR_GE( o1, o2 ) ((long)o1 >= (long)o2)

#if( !defined( __alpha ) )
extern int toupper(), tolower();
#endif

#define CHAR_UPCASE( o )   BCHAR( toupper( CCHAR( o ) ) )
#define CHAR_DOWNCASE( o ) BCHAR( tolower( CCHAR( o ) ) )
  
/*---------------------------------------------------------------------*/
/*      Les STRINGs de caracteres                                      */
/*---------------------------------------------------------------------*/
#if( !(defined( TAG_STRING ) ) )
#   define STRINGP( c ) (POINTERP( c ) && (HEADER( c ) == HEADER_STRING))
#else
#   define STRINGP( c ) ((c && ((((long)c)&TAG_MASK) == TAG_STRING)))
#endif

#define STRING( o )  (CSTRING( o )->string_t)

#define STRING_SIZE (sizeof( ((obj_t)0)->string_t))

#define STRING_LENGTH( s )  STRING( s ).length

#define STRING_REF( v, i ) BSTRING_TO_CSTRING( v )[ i ]
 
#define STRING_SET( s, i, c ) \
   ((STRING_REF( s, i ) = c), s )

#define STRING_COPY( s )  \
   (c_string_to_string((char *)(CSTRING s ) + STRING_SIZE)))
    
/*---------------------------------------------------------------------*/
/*    Les macros concernant les VECTORs                                */
/*---------------------------------------------------------------------*/
#define VECTOR_SIZE (sizeof( ((obj_t)0)->vector_t))

/* Le nombre de bit accordes aux tag des vecteurs (pour caml) */
#define VECTOR_TAG_NB_BIT 8
#define VECTOR_TAG_SIZE ((unsigned long)(1<<VECTOR_TAG_NB_BIT))

#define VECTOR_LENGTH_SHIFT ((sizeof( long ) << 3) - VECTOR_TAG_NB_BIT)

#define VECTOR_LENGTH_MASK  \
   (~(unsigned long)((VECTOR_TAG_SIZE -1) << VECTOR_LENGTH_SHIFT))

#define VECTOR( o ) CVECTOR( o )->vector_t

#if( !(defined( TAG_VECTOR ) ) )
#   define VECTORP( c ) (POINTERP( c ) && (HEADER( c ) == HEADER_VECTOR))
#else
#   define VECTORP( c ) ((c && ((((long)c)&TAG_MASK) == TAG_VECTOR)))
#endif

#if( (PTR_ALIGNMENT == TAG_SHIFT) )
#   define VECTOR_REF( v, i ) \
       (*((obj_t *)((long)CVECTOR( v ) + (VECTOR_SIZE - TAG_INT) + ((long)i))))
#else       
#   define VECTOR_REF( v, i )                \
       (*((obj_t *)(((long)CVECTOR( v )) +   \
						  VECTOR_SIZE +            \
						  (OBJ_SIZE * CINT( i )))))
#endif       
    
#define VECTOR_SET( v, i, o ) ((VECTOR_REF( v, i ) = o), v)

/*--- Les vecteurs alloues en pile ------------------------------------*/
#if( !defined( TAG_VECTOR ) )
#   define svector_t( n )                                         \
      struct {                                                    \
	      header_t header; 											       	\
         obj_t    length; 														\
   		obj_t    elements[ n ]; 	       								\
   	}
#else
#   define svector_t( n )                                         \
      struct {                                                    \
         obj_t    length; 														\
   		obj_t    elements[ n ]; 	       								\
   	}
#endif

#define INIT_STACK_INITIALIZED_VECTOR( vec, klen, init )          \
   ( INIT_STACK_VECTOR( vec, klen ),                              \
	  fill_vector( &vec, CINT( klen ), init ),                     \
	  vec )
	  
#define INIT_STACK_VECTOR( vec, klen )                            \
   ( vec.header = HEADER_VECTOR,                                  \
	  vec.length = klen,                                           \
	  vec )
	  
#define SVECTOR_REF( vec ) BVECTOR( &vec )
	 
/*---------------------------------------------------------------------*/
/*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
/*    -------------------------------------------------------------    */
/*    Pour pouvoir coder une information supplementaire sur les        */
/*    vecteurs, je limite leur taille a 2^22. Cela signifie que        */
/*    l'info peut-etre codee sur les 8 bits de poids fort.             */
/*---------------------------------------------------------------------*/
#define VECTOR_LENGTH( v ) \
   ((obj_t)((unsigned long)(VECTOR( v ).length) & VECTOR_LENGTH_MASK))

#define VECTOR_TAG_SET( v, tag )                     \
    ( VECTOR( v ).length =                           \
	   (obj_t)((unsigned long)VECTOR_LENGTH( v ) |    \
				 (((unsigned long)CINT( tag )) << VECTOR_LENGTH_SHIFT)) )

#define VECTOR_TAG( v )                                      \
      BINT( ((obj_t)(((unsigned long)(VECTOR( v ).length) &  \
				~VECTOR_LENGTH_MASK) >> VECTOR_LENGTH_SHIFT)) )

/*---------------------------------------------------------------------*/
/*    L'ARITHMETIQUE qui comme elle se doit est divisee en deux        */
/*    parties, l'ARITHMETIQUE ENTIERE et l'ARITHMETIQUE FLOTANTE. En   */
/*    plus il y a quelques macros valables pour les deux arithmetiques.*/
/*---------------------------------------------------------------------*/
/*--- l'ARITHMETIQUE ENTIERE ------------------------------------------*/
#define INTEGERP( o ) ((((long)o) & TAG_MASK) == TAG_INT)

#if( !TAG_INT )
#   define ADD_I( a, b ) ((obj_t)((long)( a ) + (long)( b ))) 
#   define SUB_I( a, b ) ((obj_t)((long)( a ) - (long)( b ))) 
#   define MUL_I( a, b ) ((obj_t)((CINT( a ) * (long)b)))
#   define DIV_I( a, b ) (obj_t)(BINT( CINT( a )/CINT( b ) ))
#   define ADD_I_PTAG( a, b ) (ADD_I( a, b ))
#   define SUB_I_PTAG( a, b ) (SUB_I( a, b ))
#   define PSUB_TAG( a ) BINT( a )
#   define PADD_TAG( a ) BINT( a )
#else
#   define ADD_I( a, b ) ((obj_t)(((long)( a ) - TAG_INT) + (long)( b )))
#   define SUB_I( a, b ) ((obj_t)(((long)( a ) - (long)( b )) | TAG_INT))
#   define MUL_I( a, b ) (BINT( (CINT( a )    * CINT( b )) ))
#   define DIV_I( a, b ) (BINT( (CINT( a )    / CINT( b )) ))
#   define ADD_I_PTAG( a, b ) ((obj_t)((long)(a) + (long)(b)))
#   define SUB_I_PTAG( a, b ) ((obj_t)((long)(a) - (long)(b)))
#   define PADD_TAG( a ) ((obj_t)((long)BINT( a ) + (long)TAG_INT))
#   define PSUB_TAG( a ) ((obj_t)((long)BINT( a ) - (long)TAG_INT))
#endif

#define EQ_I( x, y ) (((long)x) == ((long)y))
#define LT_I( x, y ) (((long)x) <  ((long)y))
#define LE_I( x, y ) (((long)x) <= ((long)y))
#define GT_I( x, y ) (((long)x) >  ((long)y))
#define GE_I( x, y ) (((long)x) >= ((long)y))

#define NEG_I( x ) (BINT( -CINT( x )))
#define ABS_I( x ) (LT_I( x, BINT(  0 )) ? BINT( -CINT( x ) ) : x)

#define BITOR( x, y )   (obj_t)(((long)x) | ((long)y))
#define BITAND( x, y )  (obj_t)(((long)x) & ((long)y))
#define BITXOR( x, y )  BINT( CINT( x ) ^ CINT( y ) )
#define BITNOT( x )     BINT( ~CINT(x) )
#define BITLSH( x, y )  BINT( CINT(x) << CINT(y) )
#define BITRSH( x, y )  BINT( CINT(x) >> CINT(y) )
#define BITURSH( x, y ) BINT((unsigned long)CINT(x) >> (unsigned long)CINT(y))

#define REMAINDER_I( a, b ) (BINT( (CINT( a ) % CINT( b )) ))
#define QUOTIENT_I( x, y ) DIV_I( x, y )

#define ODDP_I( x )  (CINT( x ) & 0x1)
#define EVENP_I( x ) (!ODDP_I( x ))

/*--- l'ARITHMETIQUE FLOTANTE -----------------------------------------*/
#define REAL_SIZE  (sizeof( ((obj_t)0)->real_t ))
#if( !(defined( TAG_REAL ) ) )
#   define REALP( c ) (POINTERP( c ) && (HEADER( c ) == HEADER_REAL))
#else
#   define REALP( c ) ((c && ((((long)c)&TAG_MASK) == TAG_REAL)))
#endif

#define REAL( o )  CREAL( o )->real_t

#define ADD_R( a, b )  (REAL_TO_DOUBLE( a ) + REAL_TO_DOUBLE( b ))
#define SUB_R( a, b )  (REAL_TO_DOUBLE( a ) - REAL_TO_DOUBLE( b ))
#define MUL_R( a, b )  (REAL_TO_DOUBLE( a ) * REAL_TO_DOUBLE( b ))
#define DIV_R( a, b )  (REAL_TO_DOUBLE( a ) / REAL_TO_DOUBLE( b ))
#define NEG_R( a )     (-REAL_TO_DOUBLE( a ))
    
#define EQ_R( x, y )   (REAL_TO_DOUBLE( x )) == (REAL_TO_DOUBLE( y ))
#define LT_R( x, y )   (REAL_TO_DOUBLE( x )) <  (REAL_TO_DOUBLE( y ))
#define LE_R( x, y )   (REAL_TO_DOUBLE( x )) <= (REAL_TO_DOUBLE( y ))
#define GT_R( x, y )   (REAL_TO_DOUBLE( x )) >  (REAL_TO_DOUBLE( y ))
#define GE_R( x, y )   (REAL_TO_DOUBLE( x )) >= (REAL_TO_DOUBLE( y ))

#define ZEROP_R( x )   (REAL_TO_DOUBLE( x )) == (double)(0.0)
#define POSITIVEP_R(x) (REAL_TO_DOUBLE( x )) >  (double)(0.0)
#define NEGATIVEP_R(x) (REAL_TO_DOUBLE( x )) <  (double)(0.0)
    
#define ABS_R( x )     (REAL_TO_DOUBLE( x ) < 0.0 ?                 \
								  DOUBLE_TO_REAL( -REAL_TO_DOUBLE( x ) ) :  \
								  x)

#define ROUND_R( x )   (floor( x + 0.5 ))

#define SREAL_REF( r ) BREAL( &r )

#if( defined( TAG_REAL ) )		
#   define INIT_STACK_REAL( r, v ) ( r.real = double( v ), r )
#else
#   define INIT_STACK_REAL( r, v ) \
       ( r.header = HEADER_REAL, r.real = (double)(v), r )
#endif

/*--- Les fonctions de converstions arithmetiques ---------------------*/
#define INT_TO_REAL(x) (DOUBLE_TO_REAL( (double)(CINT( x )) ))
#define REAL_TO_INT(x) (BINT( (long)(REAL_TO_DOUBLE( x )) ))
    
/*---------------------------------------------------------------------*/
/*    La manipulation des PROCEDUREs                                   */
/*---------------------------------------------------------------------*/
#define PROCEDURE_SIZE (sizeof( ((obj_t)0)->procedure_t))

#define PROCEDURE( o ) CREF( o )->procedure_t

#define PROCEDURE_ENTRY( fun ) (obj_t)(PROCEDURE( fun ).entry)
#define PROCEDURE_VA_ENTRY( fun ) (obj_t)(PROCEDURE( fun ).va_entry)

#define PROCEDUREP( fun ) \
   (POINTERP( fun ) && (HEADER( fun ) == HEADER_PROCEDURE))

#define PROCEDURE_ARITY( fun ) (PROCEDURE( fun ).arity)

#define VA_PROCEDUREP( fun ) ( PROCEDURE_ARITY( fun ) < 0 )
   
#define PROCEDURE_CORRECT_ARITYP( fun, num )      \
   ( (PROCEDURE_ARITY( fun ) == num) ||           \
     (VA_PROCEDUREP( fun ) &&                     \
       ((-num - 1) <= (PROCEDURE_ARITY( fun )))) )

#define PROCEDURE_ENV_REF( p, i ) \
   (*((obj_t *)(((long)&(PROCEDURE( p ).env)) + (OBJ_SIZE * i))))
   
#define PROCEDURE_ENV_SET( p, i, o ) ((PROCEDURE_ENV_REF( p, i ) = o), p)

/*--- Les procedures allouees en pile ---------------------------------*/
#define sprocedure_t( n )                                         \
   struct {                                                       \
	   header_t header; 															\
      obj_t    (*entry)();													   \
      obj_t    (*va_entry)();												   \
      long     arity;       												   \
      obj_t    elements[ n ]; 	       									\
   }

#define INIT_STACK_FX_PROCEDURE( proc, a_entry, a_arity, size )   \
   ( proc.header = HEADER_PROCEDURE,                              \
	  proc.entry  = a_entry,                                       \
	  proc.arity  = a_arity,                                       \
	  proc )

#define SPROCEDURE_REF( proc ) BREF( &proc )

/*--- Les procedures `light' allouees en pile -------------------------*/
#define sprocedure_light_t( n )                                   \
   struct {                                                       \
		obj_t    (*entry)();													   \
		obj_t    elements[ n ]; 	       									\
   }

#define INIT_STACK_LIGHT_PROCEDURE( proc, a_entry, size )         \
   ( proc.entry  = a_entry,                                       \
	  proc )

#define SPROCEDURE_LIGHT_REF( proc ) BLIGHT( &proc )

/*---------------------------------------------------------------------*/
/*    La manipulation des PROCEDURE_LIGHTs                             */
/*---------------------------------------------------------------------*/
#define PROCEDURE_LIGHT_SIZE \
   (sizeof( ((obj_t)0)->procedure_light_t ))

#define PROCEDURE_LIGHTP( o ) PAIRP( o )
      
#define PROCEDURE_LIGHT( o ) CLIGHT( o )->procedure_light_t

#define PROCEDURE_LIGHT_ENTRY( fun ) (obj_t)(PROCEDURE_LIGHT( fun ).entry)
   
#define PROCEDURE_LIGHT_ENV_REF( p, i ) \
   (*((obj_t *)(((long)&(PROCEDURE_LIGHT( p ).env)) + (OBJ_SIZE * i))))
   
#define PROCEDURE_LIGHT_ENV_SET( p, i, o ) \
   ((PROCEDURE_LIGHT_ENV_REF( p, i ) = o), p)

/*---------------------------------------------------------------------*/
/*    La manipulation des PROCEDURE_EXTRA_LIGHTs                       */
/*---------------------------------------------------------------------*/
#define PROCEDURE_EXTRA_LIGHT_SIZE \
   (sizeof( ((obj_t)0)->procedure_extra_light_t ))

#define PROCEDURE_EXTRA_LIGHT( o ) (o->procedure_extra_light_t)

#define PROCEDURE_EXTRA_LIGHT_ENTRY( fun ) \
   (obj_t)(PROCEDURE_EXTRA_LIGHT( fun ).entry)
   
#define PROCEDURE_EXTRA_LIGHT_ENV_REF( p, i ) \
   (*((obj_t *)(((long)&(PROCEDURE_EXTRA_LIGHT( p ).env)) + (OBJ_SIZE * i))))
   
#define PROCEDURE_EXTRA_LIGHT_ENV_SET( p, i, o ) \
   ((PROCEDURE_EXTRA_LIGHT_ENV_REF( p, i ) = o), p)

/*---------------------------------------------------------------------*/
/*      Les CELLules                                                   */
/*---------------------------------------------------------------------*/
#define CELL_SIZE (sizeof( ((obj_t)0)->cell_t))

#define CELL( o ) CCELL( o )->cell_t

#if( !(defined( TAG_CELL ) ) )
#   define CELLP( c ) (POINTERP( c ) && (HEADER( c ) == HEADER_CELL))
#else
#   define CELLP( c ) ((c && ((((long)c)&TAG_MASK) == TAG_CELL)))
#endif

#define MAKE_CELL( v )   make_cell( v )

#define CELL_SET( c, v ) ((CELL( c ).obj = v), c)
   
#define CELL_REF( c )    (CELL( c ).obj)

/*---------------------------------------------------------------------*/
/*    Les macros d'access aux OUTPUT_PORTs                             */
/*---------------------------------------------------------------------*/
#define OUTPUT_PORT_SIZE (sizeof( ((obj_t)0)->output_port_t ))

#define OUTPUT_PORT( o ) CREF( o )->output_port_t

#define OUTPUT_PORTP( o ) \
   ( POINTERP( o ) && ( (HEADER( o ) == HEADER_OUTPUT_PORT) || \
							   (HEADER( o ) == HEADER_OUTPUT_STRING_PORT) ) )

#define FLUSH_OUTPUT_PORT( o )  \
   ( OUTPUT_STRING_PORTP( o ) ? \
	  strport_flush( o ) :       \
	  ((fflush( OUTPUT_PORT( o ).file )), o) )

#define BOUTPUT_PORT_TO_CFILE( o )                                         \
   ( OUTPUT_STRING_PORTP( o ) ?                                            \
	  FAILURE( c_string_to_string( "output-port-to-file" ),                 \
				  c_string_to_string( "argument can't be a string port"),      \
				  o )                                                          \
	  : OUTPUT_PORT( o ).file )

#define CFILE_TO_BOUTPUT_PORT( f ) (make_output_port( "<c-port>", f))

/*---------------------------------------------------------------------*/
/*    Les OUTPUT_STRING_PORTs                                          */
/*---------------------------------------------------------------------*/
#define OUTPUT_STRING_PORT_SIZE (sizeof( ((obj_t)0)->output_string_port_t ))

#define OUTPUT_STRING_PORT( o ) CREF( o )->output_string_port_t

#define OUTPUT_STRING_PORTP( o ) \
   ( HEADER( o ) == HEADER_OUTPUT_STRING_PORT )

#define OUTPUT_STRING_PORT_BUFFER_SIZE 1024

#define END_OF_STRING_PORTP( o ) \
   ( OUTPUT_STRING_PORT( o ).offset == OUTPUT_STRING_PORT( o ).size )

/*---------------------------------------------------------------------*/
/*    Les macros d'access et de trippotages des ports binaires.        */
/*---------------------------------------------------------------------*/
#define BINARY_PORT_SIZE (sizeof( ((obj_t)0)->binary_port_t ))

#define BINARY_PORT( o ) CREF( o )->binary_port_t

#define BINARY_PORTP( o ) \
   ( POINTERP( o ) && (HEADER( o ) == HEADER_BINARY_PORT) )

#define BINARY_PORT_IN   ((bool_t)0)
#define BINARY_PORT_OUT  ((bool_t)1)

#define BINARY_PORT_INP( p ) (BINARY_PORT( o ).io == BINARY_PORT_IN)

/*---------------------------------------------------------------------*/
/*    Les macros d'access aux INPUT_PORTs                              */
/*---------------------------------------------------------------------*/
#define CLASS_FILE    BINT( 0 )
#define CLASS_CONSOLE BINT( 1 )
#define CLASS_STRING  BINT( 2 )
   
#define INPUT_PORT_SIZE (sizeof( ((obj_t)0)->input_port_t ))

#define INPUT_PORT( o ) CREF( o )->input_port_t

#define INPUT_PORTP( o ) \
    (POINTERP( o ) && (HEADER( o ) == HEADER_INPUT_PORT))

#define BUFFER( p ) ((unsigned char *)&(INPUT_PORT( p ).buffer))

#define EOF_OBJECTP( o ) ( o == BEOF )

#define INPUT_PORT_NAME( o ) (INPUT_PORT( o ).name)

#define INPUT_PORT_FILEPOS( o ) (INPUT_PORT( o ).filepos)

#define INPUT_PORT_ON_FILEP( o ) (INPUT_PORT( o ).class == CLASS_FILE)

#define INPUT_PORT_ON_STRINGP( o ) (INPUT_PORT( o ).class == CLASS_STRING)

/*--- Les macros de lecture -------------------------------------------*/
#define INPUT_PORT_READ_CHAR( p )                                          \
   ( INPUT_PORT( p ).forward = ADD_I_PTAG( INPUT_PORT( p ).forward,        \
                                           PSUB_TAG( 1 ) ),                \
     (long)((long)BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward ) - 1 ] ) )

#define READ_CHAR( p )                                                      \
   ( INPUT_PORT( p ).backward = INPUT_PORT( p ).forward,                    \
     INPUT_PORT( p ).forward = ADD_I_PTAG( INPUT_PORT( p ).forward,         \
                                           PSUB_TAG( 1 ) ),                 \
     INPUT_PORT( p ).filepos++,                                             \
     INPUT_PORT_REMEMBER_REF( p ),                                          \
     BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward )-1 ] ?               \
     BCHAR( BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward )-1 ] ) :      \
        !input_port_fill_buffer( p )?                                       \
           INPUT_PORT( p ).forward =                                        \
             SUB_I_PTAG( INPUT_PORT( p ).forward, PSUB_TAG( 1 ) ),          \
           reset_eof( p ),                                                  \
           BEOF :                                                           \
           ( INPUT_PORT( p ).forward =                                      \
               ADD_I_PTAG( INPUT_PORT( p ).forward, PSUB_TAG( 1 ) ),        \
             BCHAR( BUFFER( p )[ (long)CINT( INPUT_PORT( p ).backward ) ] ) ) )
   
#define PEEK_CHAR( p )                                                      \
   ( INPUT_PORT( p ).backward = INPUT_PORT( p ).forward,                    \
     BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward ) ] ?                 \
      BCHAR( BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward )] ) :        \
        (!input_port_fill_buffer( p )) ?                                    \
           BEOF :                                                           \
           (INPUT_PORT( p ).forward =                                       \
              ADD_I_PTAG( INPUT_PORT( p ).forward, PSUB_TAG( 1 ) ),         \
           BCHAR( BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward ) ] ) ))

#define INPUT_PORT_THROW_CHAR( p, n )                                       \
   INPUT_PORT( p ).backward = ADD_I( INPUT_PORT( p ).backward, n )

#define INPUT_PORT_REMEMBER_REF( p )                                        \
   INPUT_PORT( p ).remember = INPUT_PORT( p ).forward
   
#define INPUT_PORT_REMEMBER_BACK_REF( p )                                   \
   INPUT_PORT( p ).remember = SUB_I_PTAG( INPUT_PORT( p ).forward,          \
                                          PSUB_TAG( 1 ) )
      
#define INPUT_PORT_EOFP( p )                                                \
   ( (INPUT_PORT( p ).eof &&                                                \
      (BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward ) ] == '\0')) ?     \
     BTRUE : BFALSE )

#define INPUT_PORT_EOLP( p )                                                \
   ( (BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward ) ] == '\n') ?       \
      BTRUE : BFALSE )
      
#define INPUT_PORT_BOLP( p )                                                \
   ( (EQ_I( INPUT_PORT( p ).backward, BINT( 0 ) ) ||                         \
      (BUFFER( p )[ (long)CINT( INPUT_PORT( p ).backward ) - 1 ] == '\n')) ?\
      BTRUE : BFALSE )
   
#define INPUT_PORT_GET_LENGTH( p )                                          \
   ( INPUT_PORT( p ).annexe ? ADD_I( INPUT_PORT( p ).anxsiz,                \
                                     SUB_I( INPUT_PORT( p ).backward,       \
			  								           INPUT_PORT( p ).mark) )         \
                            : SUB_I( INPUT_PORT( p ).backward,              \
											    INPUT_PORT( p ).mark) )  

#define INPUT_PORT_STOLE_CHAR( p )                                          \
   ( INPUT_PORT( p ).backward = ADD_I_PTAG( INPUT_PORT( p ).backward,       \
                                            PSUB_TAG( 1 ) ),                \
     INPUT_PORT( p ).forward = INPUT_PORT( p ).remember =                   \
     INPUT_PORT( p ).backward,                                              \
     INPUT_PORT( p ).filepos++,                                             \
      BUFFER( p )[ (long)CINT( INPUT_PORT( p ).remember ) - 1 ] ?           \
        BCHAR( BUFFER( p )[ (long)CINT( INPUT_PORT( p ).remember )-1 ] ) :  \
        BEOF )
   
#define INPUT_PORT_AJUST_CURSOR( p )                                        \
   ( INPUT_PORT( p ).forward  = INPUT_PORT( p ).remember,                   \
     INPUT_PORT( p ).mark     = INPUT_PORT( p ).backward,                   \
     INPUT_PORT( p ).backward = INPUT_PORT( p ).forward,                    \
     INPUT_PORT( p ).filepos += CINT( INPUT_PORT_GET_LENGTH( p ) ),         \
     BUNSPEC )

#define INPUT_PORT_TOKEN_TOO_LARGEP( p ) (INPUT_PORT( p ).annexe != 0L)

/*---------------------------------------------------------------------*/
/*    Les STRUCtures                                                   */
/*---------------------------------------------------------------------*/
#define STRUCT_SIZE (sizeof( ((obj_t)0)->struct_t))

#define STRUCT( o ) CSTRUCTURE( o )->struct_t

#if( !(defined( TAG_STRUCTURE ) ) )
#   define STRUCTP( c ) (POINTERP( c ) && (HEADER( c ) == HEADER_STRUCT))
#else
#   define STRUCTP( c ) ((c && ((((long)c)&TAG_MASK) == TAG_STRUCTURE)))
#endif

#define STRUCT_KEY( c ) STRUCT( c ).key

#define STRUCT_LENGTH( c ) STRUCT( c ).length
   
#define STRUCT_SLOT_REF( c, i )                                        \
   (*((obj_t *)(((long)&(STRUCT( c ).slot)) + (OBJ_SIZE * CINT( i ) ))))

#define STRUCT_SLOT_SET( c, i, o ) ((STRUCT_SLOT_REF( c, i ) = o), c)

/*---------------------------------------------------------------------*/
/*    Les `STACK' (cf. call/cc)                                        */
/*---------------------------------------------------------------------*/
#define STACK_SIZE  (sizeof( ((obj_t)0)->stack_t))
   
#define STACK( _o_ ) CREF( _o_ )->stack_t

#define STACKP( _s_ ) (POINTERP( _s_ ) && (HEADER( _s_ ) == HEADER_STACK))

#define MAKE_STACK( _size_, aux ) \
   (BREF( MAKE_OBJECT( STACK_SIZE + (long)_size_, HEADER_STACK, aux )))
   
/*---------------------------------------------------------------------*/
/*    Les `LOCATION's                                                  */
/*---------------------------------------------------------------------*/
#define LOCATION( x )        BREF( &x )
#define LOCATION_REF( x )    (*((obj_t *)CREF( x )))
#define LOCATION_SET( x, y ) ((LOCATION_REF( x ) = (obj_t)y ), y)

/*---------------------------------------------------------------------*/
/*    Les `ENV'                                                        */
/*---------------------------------------------------------------------*/
#define ENV_REF( env, offset ) (((obj_t *)env)[ offset ])
#define ENV_SET( env, offset, value ) (ENV_REF( env, offset ) = value, value)
   
/*---------------------------------------------------------------------*/
/*    Les macros, structures et externes de debug bigloo.              */
/*    -------------------------------------------------------------    */
/*    Le champ `link' et la variable `link' sont tous les deux         */
/*    INDISPENSABLES. La variable sert pour les retours multiples, le  */
/*    champs sert pour l'affichage de la pile (voir debug.c).          */
/*---------------------------------------------------------------------*/
struct dframe {
   obj_t          symbol;
   struct dframe *link;  
};

#define PUSH_LAMBDA_TRACE( name )                  \
   struct dframe  frame;                           \
   struct dframe *link;                            \
                                                   \
   frame.symbol = name;                            \
   frame.link   = top_of_frame;                    \
   link         = top_of_frame;                    \
   top_of_frame = &frame;            
   
#define POP_LAMBDA_TRACE( res )  \
   ( top_of_frame = link, res )

#define GET_LAMBDA_STACK() BREF( top_of_frame )
#define SET_LAMBDA_STACK( t ) \
   ( top_of_frame = (struct dframe *)CREF( t ), BUNSPEC )

extern struct dframe *top_of_frame;

/*---------------------------------------------------------------------*/
/*    Les macros utilisee pour les `foreign_t'                         */
/*---------------------------------------------------------------------*/
#define FOREIGNP( o ) (POINTERP( o ) && (HEADER( o ) == HEADER_FOREIGN))
#define FOREIGN( o )  CREF( o)->foreign_t
#define FOREIGN_SIZE  (sizeof( ((obj_t)0)->foreign_t))

#define FOREIGN_ID( o )    FOREIGN( o ).id
#define FOREIGN_VALUE( o ) FOREIGN( o ).value

#define FOREIGN_ISP( o, key ) (FOREIGNP( o ) && (EQP( FOREIGN_ID( o ), key)))
#define BFOREIGN_TO_CFOREIGN( o ) (FOREIGN_VALUE( o ))

#define FOREIGN_EQP( o1, o2 ) (FOREIGN_VALUE( o1 ) == FOREIGN_VALUE( o2 ))
#define FOREIGN_NULLP( o1 ) (!FOREIGN_VALUE( o1 ))

#define FOREIGN_STRUCT_REF( o, tname, slot ) \
   (((tname)(FOREIGN_VALUE( o )))->slot)
#define FOREIGN_STRUCT_SET( o, tname, slot, value ) \
   (FOREIGN_STRUCT_REF( o, tname, slot ) = value, BUNSPEC)

#define FOREIGN_ARRAY_REF( tname, array, offset ) \
   (((tname)array)[ offset ])

#define FOREIGN_ARRAY_SET( tname, array, offset, value ) \
   (FOREIGN_ARRAY_REF( tname, array, offset ) = value, BUNSPEC)
   
/*---------------------------------------------------------------------*/
/*    Les definitions de certains objets alloues                       */
/*---------------------------------------------------------------------*/
#define DEFINE_STRING( name, str, len )                    \
   static struct { header_t header;                        \
                   obj_t    length;                        \
                   char     string[len+(4-(len % 4))]; }   \
      name = { HEADER_STRING, BINT( len ), str }

#if( !defined( TAG_REAL ) )
#   define DEFINE_REAL( name, flonum )                     \
      static struct { header_t header;                     \
							 double   real; }                     \
         name = { HEADER_REAL, flonum }
#endif

/*---------------------------------------------------------------------*/
/*    Le tableau des constantes (pour l'initialisation des modules).   */
/*    -------------------------------------------------------------    */
/*    Ces deux macros servent a l'initialisation des constantes. C'est */
/*    un peu astucieux la facon dont c'est fait. Il faut regarder le   */
/*    fichier `comptime/Cnst/read-alloc.scm' pour comprendre comment   */
/*    ca marche.                                                       */
/*---------------------------------------------------------------------*/

/* Cette premiere macro est juste utilisee dans un hack      */
/* pour la passe Cgen et Cnst. Le pbm est qu'il faut que     */
/* la variable __cnst soit utilisee. C'est le cas puisqu'on  */
/* la passe a cette macro bidon...                           */
#define DECLARE_CNST_TABLE( dummy )                           \
   BUNSPEC

#define CNST_TABLE_SET( offset, value )                       \
   ( __cnst[ CINT( offset ) ] = value, BUNSPEC )

#define CNST_TABLE_REF( offset )                              \
   __cnst[ offset ]

#define GET_CNST_TABLE() (&__cnst)

/*---------------------------------------------------------------------*/
/*    Les marks pour l'externement lineaire                            */
/*---------------------------------------------------------------------*/
#define TAG_MARK (unsigned long)((unsigned long)1 << ((8 * OBJ_SIZE) - 1))

#define IS_MARKP( x )                                     \
   ( CNSTP( (unsigned long)x ) && (TAG_MARK & (unsigned long) x) )

#define BINT_TO_MARK( x )                                 \
   (obj_t)( (unsigned long)( (unsigned long)BCNST( CINT( x ) ) | TAG_MARK ) )

#define MARK_TO_BINT( x )                                 \
   (obj_t)( BINT((unsigned long)CCNST( (unsigned long)x & (~TAG_MARK) ) ) )

#if( defined( TAG_STRING ) )
#   define STRING_MARK_OFFSET 0
#else
#   define STRING_MARK_OFFSET 1
#endif

#if( defined( TAG_VECTOR ) )
#   define VECTOR_MARK_OFFSET 0
#else
#   define VECTOR_MARK_OFFSET 1
#endif

/*---------------------------------------------------------------------*/
/*    Les macros de l'allocation en pile ...                           */
/*---------------------------------------------------------------------*/
#define STACK_REFERENCE( o ) ((obj_t)&o)

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
#if( !defined( __GNUC__ ) )
   extern obj_t an_object, a_cell, a_pair;
#endif

extern obj_t __ContinueValue;
extern obj_t c_constant_string_to_string();
extern bool_t input_port_fill_buffer();

extern obj_t c_string_to_string();
extern obj_t c_string_to_symbol();

extern obj_t apply();
extern obj_t eval_apply();

extern double strtod();
extern obj_t make_real();
extern obj_t make_cell();

extern obj_t strputc();
extern obj_t strputs();
extern obj_t strport_flush();

extern obj_t the_failure();
extern int fflush();

#endif
