;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.7/Ieee/numbers.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 24 16:07:40 1992                          */
;*    Last change :  Thu Jan 26 11:27:49 1995 (serrano)                */
;*                                                                     */
;*    6.5. Numbers (page 18, r4)                                       */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_numbers_6_5
   (foreign (define breal c-fixnum->flonum (bint)  "INT_TO_REAL")
	    (define bint  c-flonum->fixnum (breal) "REAL_TO_INT"))
   (export  (inline number?         obj)
	    (inline exact?          z)
	    (inline inexact?        z)
	    (complex?               x)
	    (rational?              x)
	    (inline flonum->fixnum  x)
	    (inline fixnum->flonum  x)
	    (2=                     x y)
	    (=                      x y . z)
	    (2<                     x y) 
	    (<                      x y . z)
	    (2>                     x y)
	    (>                      x y . z)
	    (2<=                    x y)
	    (<=                     x y . z)
	    (2>=                    x y)
	    (>=                     x y . z)
	    (zero?                  x)
	    (positive?              x)
	    (negative?              x)
	    (max                    x . y)
	    (min                    x . y)
	    (2+                     x y)
	    (+                      . x)
	    (2*                     x y)
	    (*                      . x)
	    (2-                     x y)
	    (-                      x . y)
	    (2/                     x y)
	    (/                      x . y)
	    (abs                    x)
	    (floor                  x)
	    (ceiling                x)
	    (truncate               x)
	    (round                  x)
	    (exp                    x) 
	    (log                    x) 
	    (sin                    x) 
	    (cos                    x) 
	    (tan                    x) 
	    (asin                   x) 
	    (acos                   x) 
	    (atan                   x . y) 
	    (sqrt                   x) 
	    (expt                   x y)
	    (inline exact->inexact  z)
	    (inline inexact->exact  z)
	    (number->string         x . radix)
	    (string->number         x . radix))
   (pragma  (+ _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (- _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (* _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (/ _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (= _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (<= _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (>= _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (< _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (> _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (number? _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)))
	    

;*---------------------------------------------------------------------*/
;*    number? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (number? obj)
   (or (c-integer? obj)
       (c-real?    obj)))

;*---------------------------------------------------------------------*/
;*    exact? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (exact? z)
   (integer? z))

;*---------------------------------------------------------------------*/
;*    inexact? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (inexact? z)
   (c-real? z))

;*---------------------------------------------------------------------*/
;*    complex? ...                                                     */
;*---------------------------------------------------------------------*/
(define (complex? x)
   (number? x))

;*---------------------------------------------------------------------*/
;*    rational? ...                                                    */
;*---------------------------------------------------------------------*/
(define (rational? x)
   (real? x))

;*---------------------------------------------------------------------*/
;*    flonum->fixnum ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (flonum->fixnum x)
   (c-flonum->fixnum x))

;*---------------------------------------------------------------------*/
;*    fixnum->flonum ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (fixnum->flonum x)
   (c-fixnum->flonum x))
		       
;*---------------------------------------------------------------------*/
;*    2= ...                                                           */
;*---------------------------------------------------------------------*/
(define (2= x y)
   (cond
      ((integer? x)
       (cond
	  ((integer? y)
	   (=fx x y))
	  ((c-real? y)
	   (=fl (fixnum->flonum x) y))
	  (else
	   (error "=" "not a number" y))))
      ((c-real? x)
       (cond
	  ((c-real? y)
	   (=fl x y))
	  ((integer? y)
	   (=fl x (fixnum->flonum y)))
	  (else
	   (error "=" "not a number" y))))
      (else
       (error "=" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    = ...                                                            */
;*---------------------------------------------------------------------*/
(define (= x y . z)
   (define (=-list x z)
	    (cond
	       ((null? z) #t)
	       ((2= x (car z))
		(=-list x (cdr z)))
	       (else #f)))
   (and (2= x y)
	(=-list y z)))

;*---------------------------------------------------------------------*/
;*    2< ...                                                           */
;*---------------------------------------------------------------------*/
(define (2< x y)
   (cond
      ((integer? x)
       (cond
	  ((integer? y)
	   (<fx x y))
	  ((c-real? y)
	   (<fl (fixnum->flonum x) y))
	  (else
	   (error "<" "not a number" y))))
      ((c-real? x)
       (cond
	  ((c-real? y)
	   (<fl x y))
	  ((integer? y)
	   (<fx (flonum->fixnum x) y))
	  (else
	   (error "<" "not a number" y))))
      (else
       (error "<" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    < ...                                                            */
;*---------------------------------------------------------------------*/
(define (< x y . z)
   (define (<-list x z)
	    (cond
	       ((null? z) #t)
	       ((2< x (car z))
		(<-list (car z) (cdr z)))
	       (else #f)))
   (and (2< x y)
	(<-list y z)))

   
;*---------------------------------------------------------------------*/
;*    2> ...                                                           */
;*---------------------------------------------------------------------*/
(define (2> x y)
   (cond
      ((integer? x)
       (cond
	  ((integer? y)
	   (>fx x y))
	  ((c-real? y)
	   (>fx x (flonum->fixnum y)))
	  (else
	   (error ">" "not a number" y))))
      ((c-real? x)
       (cond
	  ((c-real? y)
	   (>fl x y))
	  ((integer? y)
	   (>fl x (fixnum->flonum y)))
	  (else
	   (error ">" "not a number" y))))
      (else
       (error ">" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    > ...                                                            */
;*---------------------------------------------------------------------*/
(define (> x y . z)
   (define (>-list x z)
	    (cond
	       ((null? z) #t)
	       ((2> x (car z))
		(>-list (car z) (cdr z)))
	       (else #f)))
   (and (2> x y)
	(>-list y z)))
 
;*---------------------------------------------------------------------*/
;*    2<= ...                                                          */
;*---------------------------------------------------------------------*/
(define (2<= x y)
   (cond
      ((integer? x)
       (cond
	  ((integer? y)
	   (<=fx x y))
	  ((c-real? y)
	   (<=fx x (flonum->fixnum y)))
	  (else
	   (error "<=" "not a number" y))))
      ((c-real? x)
       (cond
	  ((c-real? y)
	   (<=fl x y))
	  ((integer? y)
	   (<=fl x (fixnum->flonum y)))
	  (else
	   (error "<=" "not a number" y))))
      (else
       (error "<=" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    <= ...                                                           */
;*---------------------------------------------------------------------*/
(define (<= x y . z)
   (define (<=-list x z)
	    (cond
	       ((null? z) #t)
	       ((2<= x (car z))
		(<=-list (car z) (cdr z)))
	       (else #f)))
   (and (2<= x y)
	(<=-list y z)))

;*---------------------------------------------------------------------*/
;*    2>= ...                                                          */
;*---------------------------------------------------------------------*/
(define (2>= x y)
   (cond
      ((integer? x)
       (cond
	  ((integer? y)
	   (>=fx x y))
	  ((c-real? y)
	   (>=fl (fixnum->flonum x) y))
	  (else
	   (error ">=" "not a number" y))))
      ((c-real? x)
       (cond
	  ((c-real? y)
	   (>=fl x y))
	  ((integer? y)
	   (>=fx (flonum->fixnum x) y))
	  (else
	   (error ">=" "not a number" y))))
      (else
       (error ">=" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    >= ...                                                           */
;*---------------------------------------------------------------------*/
(define (>= x y . z)
   (define (>=-list x z)
	    (cond
	       ((null? z) #t)
	       ((2>= x (car z))
		(>=-list (car z) (cdr z)))
	       (else #f)))
   (and (2>= x y)
	(>=-list y z)))

;*---------------------------------------------------------------------*/
;*    zero? ...                                                        */
;*---------------------------------------------------------------------*/
(define (zero? x)
   (cond
      ((integer? x)
       (zerofx? x))
      ((c-real? x)
       (zerofl? x))
      (else
       (error "zero" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    positive? ...                                                    */
;*---------------------------------------------------------------------*/
(define (positive? x)
   (cond
      ((integer? x)
       (positivefx? x))
      ((c-real? x)
       (positivefl? x))
      (else
       (error "positive" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    negative? ...                                                    */
;*---------------------------------------------------------------------*/
(define (negative? x)
   (cond
      ((integer? x)
       (negativefx? x))
      ((c-real? x)
       (negativefl? x))
      (else
       (error "negative" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    max ...                                                          */
;*---------------------------------------------------------------------*/
(define (max x . y)
   (let loop ((x x)
	      (y y))
      (if (pair? y)
	  (loop (if (> x (car y))
		    x
		    (car y))
		(cdr y))
	  x)))

;*---------------------------------------------------------------------*/
;*    min ...                                                          */
;*---------------------------------------------------------------------*/
(define (min x . y)
   (let loop ((x x)
	      (y y))
      (if (pair? y)
	  (loop (if (< x (car y))
		    x
		    (car y))
		(cdr y))
	  x)))

;*---------------------------------------------------------------------*/
;*    2+ ...                                                           */
;*---------------------------------------------------------------------*/
(define (2+ x y)
   (cond
      ((integer? x)
       (cond
	  ((integer? y)
	   (+fx x y))
	  ((c-real? y)
	   (+fl (fixnum->flonum x) y))
	  (else
	   (error "+" "not a number" y))))
      ((c-real? x)
       (cond
	  ((c-real? y)
	   (+fl x y))
	  ((integer? y)
	   (+fl x (fixnum->flonum y)))
	  (else
	   (error "+" "not a number" y))))
      (else
       (error "+" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    + ...                                                            */
;*---------------------------------------------------------------------*/
(define (+  . x)
   (let loop ((sum 0)
	      (x x))
      (if (pair? x)
	  (loop (2+ sum (car x))
		(cdr x))
	  sum)))

;*---------------------------------------------------------------------*/
;*    2* ...                                                           */
;*---------------------------------------------------------------------*/
(define (2* x y)
   (cond
      ((integer? x)
       (cond
	  ((integer? y)
	   (*fx x y))
	  ((c-real? y)
	   (*fl (fixnum->flonum x) y))
	  (else
	   (error "*" "not a number" y))))
      ((c-real? x)
       (cond
	  ((c-real? y)
	   (*fl x y))
	  ((integer? y)
	   (*fl x (fixnum->flonum y)))
	  (else
	   (error "*" "not a number" y))))
      (else
       (error "*" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    * ...                                                            */
;*---------------------------------------------------------------------*/
(define (*  . x)
   (let loop ((product 1)
	      (x x))
      (if (pair? x)
	  (loop (2* product (car x)) (cdr x))
	  product)))

;*---------------------------------------------------------------------*/
;*    2- ...                                                           */
;*---------------------------------------------------------------------*/
(define (2- x y)
   (cond
      ((integer? x)
       (cond
	  ((integer? y)
	   (-fx x y))
	  ((c-real? y)
	   (-fl (fixnum->flonum x) y))
	  (else
	   (error "-" "not a number" y))))
      ((c-real? x)
       (cond
	  ((c-real? y)
	   (-fl x y))
	  ((integer? y)
	   (-fl x (fixnum->flonum y)))
	  (else
	   (error "-" "not a number" y))))
      (else
       (error "-" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    - ...                                                            */
;*---------------------------------------------------------------------*/
(define (- x . y)
    (if (pair? y)
	(let loop ((result (2- x (car y)))
		   (args (cdr y)))
	   (if (pair? args)
	       (loop (2- result (car args)) (cdr args))
	       result))
	(2- 0 x)))

;*---------------------------------------------------------------------*/
;*    2/ ...                                                           */
;*---------------------------------------------------------------------*/
(define (2/ x y)
   (cond
      ((integer? x)
       (cond
	  ((integer? y)
	   (if (=fx (remainder x y) 0)
	       (/fx x y)
	       (/fl (fixnum->flonum x) (fixnum->flonum y))))
	  ((c-real? y)
	   (/fl (fixnum->flonum x) y))
	  (else
	   (error "/" "not a number" y))))
      ((c-real? x)
       (cond
	  ((c-real? y)
	   (/fl x y))
	  ((integer? y)
	   (/fl x (fixnum->flonum y)))
	  (else
	   (error "/" "not a number" y))))
      (else
       (error "/" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    / ...                                                            */
;*---------------------------------------------------------------------*/
(define (/ x . y)
    (if (pair? y)
	(let loop ((result (2/ x (car y)))
		   (z (cdr y)))
	     (if (pair? z)
		 (loop (2/ result (car z))
		       (cdr z))
		 result))
	(2/ 1 x)))

;*---------------------------------------------------------------------*/
;*    abs ...                                                          */
;*---------------------------------------------------------------------*/
(define (abs x)
   (cond
      ((integer? x)
       (absfx x))
      ((c-real? x)
       (absfl x))
      (else
       (error "abs" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    floor ...                                                        */
;*---------------------------------------------------------------------*/
(define (floor x)
   (cond
      ((integer? x)
       x)
      ((c-real? x)
       (floorfl x))
      (else
       (error "floor" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    ceiling ...                                                      */
;*---------------------------------------------------------------------*/
(define (ceiling x)
   (cond
      ((integer? x)
       x)
      ((c-real? x)
       (ceilingfl x))
      (else
       (error "ceiling" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    truncate ...                                                     */
;*---------------------------------------------------------------------*/
(define (truncate x)
   (cond
      ((integer? x)
       x)
      ((c-real? x)
       (truncatefl x))
      (else
       (error "truncate" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    round ...                                                        */
;*---------------------------------------------------------------------*/
(define (round x)
   (cond
      ((integer? x)
       x)
      ((c-real? x)
       (roundfl x))
      (else
       (error "round" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    exp ...                                                          */
;*---------------------------------------------------------------------*/
(define (exp x)
   (cond
      ((integer? x)
       (expfl (fixnum->flonum x)))
      ((c-real? x)
       (expfl x))
      (else
       (error "exp" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    log ...                                                          */
;*---------------------------------------------------------------------*/
(define (log x)
   (cond
      ((integer? x)
       (logfl (fixnum->flonum x)))
      ((c-real? x)
       (logfl x))
      (else
       (error "log" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    sin ...                                                          */
;*---------------------------------------------------------------------*/
(define (sin x)
   (cond
      ((integer? x)
       (sinfl (fixnum->flonum x)))
      ((c-real? x)
       (sinfl x))
      (else
       (error "sin" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    cos ...                                                          */
;*---------------------------------------------------------------------*/
(define (cos x)
   (cond
      ((integer? x)
       (cosfl (fixnum->flonum x)))
      ((c-real? x)
       (cosfl x))
      (else
       (error "cos" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    tan ...                                                          */
;*---------------------------------------------------------------------*/
(define (tan x)
   (cond
      ((integer? x)
       (tanfl (fixnum->flonum x)))
      ((c-real? x)
       (tanfl x))
      (else
       (error "tan" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    asin ...                                                         */
;*---------------------------------------------------------------------*/
(define (asin x)
   (cond
      ((integer? x)
       (asinfl (fixnum->flonum x)))
      ((c-real? x)
       (asinfl x))
      (else
       (error "asin" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    acos ...                                                         */
;*---------------------------------------------------------------------*/
(define (acos x)
   (cond
      ((integer? x)
       (acosfl (fixnum->flonum x)))
      ((c-real? x)
       (acosfl x))
      (else
       (error "acos" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    atan ...                                                         */
;*---------------------------------------------------------------------*/
(define (atan x . y)
   (let ((y (if (pair? y)
		(let ((y (car y)))
		   (cond
		      ((integer? y)
		       (fixnum->flonum y))
		      ((c-real? y)
		       y)
		      (else
		       (error "atan" "not a number" y))))
		#f)))
      (define (do-atanfl x)
	 (if (number? y)
	     (atanfl x y)
	     (atanfl x)))
      (cond
	 ((integer? x)
	  (do-atanfl (fixnum->flonum x)))
	 ((c-real? x)
	  (do-atanfl x))
	 (else
	  (error "atan" "not a number" x)))))

;*---------------------------------------------------------------------*/
;*    sqrt ...                                                         */
;*---------------------------------------------------------------------*/
(define (sqrt x)
   (cond
      ((integer? x)
       (sqrtfl (fixnum->flonum x)))
      ((c-real? x)
       (sqrtfl x))
      (else
       (error "sqrt" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    expt ...                                                         */
;*---------------------------------------------------------------------*/
(define (expt x y)
   (if (and (c-real? x) (c-real? y) (=fl x 0.0) (=fl y 0.0))
       1.0
       (cond
	  ((and (integer? x)
		(integer? y))
	   (flonum->fixnum (exptfl (fixnum->flonum x)  (fixnum->flonum y))))
	  ((integer? x)
	   (cond
	      ((c-real? y)
	       (exptfl (fixnum->flonum x) y))
	      (else
	       (error "expt" "not a number" y))))
	  ((c-real? x)
	   (cond
	      ((c-real? y)
	       (exptfl x y))
	      (else
	       (error "expt" "not a number" y))))
	  (else
	   (error "expt" "not a number" x)))))

;*---------------------------------------------------------------------*/
;*    exact->inexact ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (exact->inexact z)
   (if (exact? z)
       (fixnum->flonum z)
       z))

;*---------------------------------------------------------------------*/
;*    inexact->exact ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (inexact->exact z)
   (if (inexact? z)
       (flonum->fixnum z)
       z))

;*---------------------------------------------------------------------*/
;*    number->string ...                                               */
;*---------------------------------------------------------------------*/
(define (number->string x . radix)
   (if (null? radix)
       (set! radix 10)
       (set! radix (car radix)))
   (cond
      ((integer? x)
       (integer->string x radix))
      ((c-real? x)
       (real->string x))))

;*---------------------------------------------------------------------*/
;*    string->number ...                                               */
;*---------------------------------------------------------------------*/
(define (string->number x . radix)
   (define (integer-string? x)
      (let loop ((i (-fx (string-length x) 1)))
	 (cond
	    ((=fx i -1)
	     #t)
	    ((char=? (string-ref x i) #\-)
	     (=fx i 0))
	    ((and (char>=? (string-ref x i) #\0)
		  (char<=? (string-ref x i) #\9))
	     (loop (-fx i 1)))
	    (else
	     #f))))
   (if (integer-string? x)
       (apply string->integer (cons x radix))
       (apply string->real (cons x radix))))
       
