/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.7/Clib/init-obj.c ...       */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Jul 17 09:00:08 1992                          */
/*    Last change :  Sat Oct 29 14:37:36 1994 (serrano)                */
/*                                                                     */
/*    On initialise les objects vitaux                                 */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les objects vitaux ...                                           */
/*---------------------------------------------------------------------*/
obj_t  an_object, a_cell, a_pair;
obj_t  quote;
obj_t *c_allocated_char;
obj_t  __ContinueValue;

#if defined( ALLOCATE_CONSTANT )
   obj_t nil_object, undef_object, end_of_file_object, end_of_argument_object;
   obj_t true_object, false_object;
#endif

extern obj_t string_to_obj();

/*---------------------------------------------------------------------*/
/*    init_objects ...                                                 */
/*---------------------------------------------------------------------*/
init_objects()
{
   long i;
   obj_t aux;
	
   /* l'initialisation des objects speciaux */
#if defined( ALLOCATE_CONSTANT )
   true_object  = BREF( MAKE_ATOMIC_OBJECT( sizeof( ((obj_t)0)->boolean_t ),
                                            HEADER_TRUE,
														  aux ) );
   false_object = BREF( MAKE_ATOMIC_OBJECT( sizeof( ((obj_t)0)->boolean_t ),
                                            HEADER_FALSE,
														  aux ) );

   nil_object   = BREF( MAKE_ATOMIC_OBJECT( sizeof( ((obj_t)0)->header ),
                                            HEADER_NIL,
														  aux ) );
   undef_object = BREF( MAKE_ATOMIC_OBJECT( sizeof( ((obj_t)0)->header ),
                                            HEADER_UNDEF,
														  aux ) );

   end_of_file_object = BREF( MAKE_ATOMIC_OBJECT( sizeof( ((obj_t)0)->header ),
                                                  HEADER_EOF,
																  aux ) );
   end_of_argument_object =
      BREF(  MAKE_ATOMIC_OBJECT( sizeof( ((obj_t)0)->header ),
										   HEADER_EOA,
										   aux ) );
#endif
  
   /* l'initialisation des symbols */
   init_symbol_table();

	/* l'initialisation de l'interface etrangere */
	init_address_table();
	
   /* l'initialisation des ports d'entree/sortie */
   init_io();

   /* l'initialisation du symbol QUOTE (voir apply.c) */
   quote = c_string_to_symbol( "QUOTE" );
}
