/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.7/Clib/debug.c ...          */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Sep 16 08:22:22 1992                          */
/*    Last change :  Fri Jan 13 16:45:44 1995 (serrano)                */
/*                                                                     */
/*    Quelques fonctions de debug C (gdb)                              */
/*---------------------------------------------------------------------*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t DISPLAY___R4_OUTPUT_6_10_3_107();
extern int puts();

/*---------------------------------------------------------------------*/
/*    La partie concernant la `lambda stack'.                          */
/*---------------------------------------------------------------------*/
struct dframe *top_of_frame = 0L;

/*---------------------------------------------------------------------*/
/*    dump_lambda_stack ...                                            */
/*---------------------------------------------------------------------*/
obj_t
dump_lambda_stack( port, depth )
obj_t port;
long  depth;
{
   long           level = 0L;
   struct dframe *runner = top_of_frame;
	obj_t          old = 0L;
	int            recursion = 0;

   while( (level < depth) && runner )
   {
		if( SYMBOLP( runner->symbol ) )
		{
			if( EQP( runner->symbol, old ) )
				recursion++, depth++;
			else
			{
				if( recursion > 0 )
				{
					fprintf( OUTPUT_PORT( port ).file, "       ...\n" );
					recursion = 0;
				}
				old = runner->symbol;
				
				fprintf( OUTPUT_PORT( port ).file,
						   "  %3ld. %s\n", level, SYMBOL( runner->symbol ).name );
			}
		}
		else
         fprintf( OUTPUT_PORT( port ).file, "  %3ld. #<???>\n", level );
		
      level++, runner = runner->link;
   }
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    dprint ...                                                       */
/*    -------------------------------------------------------------    */
/*    Cette fonction ne sert que pour gdb. (pour pouvoir appeller une  */
/*    fonction de printing depuis le debugger).                        */
/*---------------------------------------------------------------------*/
dprint( obj )
obj_t obj;
{
   DISPLAY___R4_OUTPUT_6_10_3_107( obj, BNIL );
   puts( "" );
   return ;
}

/*---------------------------------------------------------------------*/
/*    cref ...                                                         */
/*---------------------------------------------------------------------*/
obj_t
cref( obj )
obj_t obj;
{
   return CREF( obj );
}

/*---------------------------------------------------------------------*/
/*    car ...                                                          */
/*---------------------------------------------------------------------*/
obj_t
car( obj )
obj_t obj;
{
   return CAR( obj );
}

/*---------------------------------------------------------------------*/
/*    cdr ...                                                          */
/*---------------------------------------------------------------------*/
obj_t
cdr( obj )
obj_t obj;
{
   return CDR( obj );
}

/*---------------------------------------------------------------------*/
/*    byteshow ...                                                     */
/*---------------------------------------------------------------------*/
static void
byteshow( addr )
unsigned char *addr;
{
#define PP_CHAR( c ) (((c) >= 33) && ((c) < 127)) ? c : '.'

   printf( "  %08x  :  %02x %02x %02x %02x  :  %c%c%c%c\n",
           (unsigned)addr,
           addr[ 0 ],
           addr[ 1 ],
           addr[ 2 ],
           addr[ 3 ],
           PP_CHAR( addr[ 0 ] ),
           PP_CHAR( addr[ 1 ] ),
           PP_CHAR( addr[ 2 ] ),
           PP_CHAR( addr[ 3 ] ) );
}
             
   
/*---------------------------------------------------------------------*/
/*    memshow ...                                                      */
/*---------------------------------------------------------------------*/
void
memshow( from, to, step )
char *from, *to;
long  step;
{
   char *i;

   step *= 4;
      
   if( from > to )
      for( i = from; i > to; i -= step )
         byteshow( i );
   else
      for( i = from; i < to; i += step )
         byteshow( i );

   puts( "" );
   return ;
}

      

