;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloos/recette/kwote.scm ...               */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 10:22:02 1992                          */
;*    Last change :  Tue Nov  3 15:13:40 1992  (serrano)               */
;*                                                                     */
;*    On test l'expansion des kwote                                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module kwote
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-kwote)))

;*---------------------------------------------------------------------*/
;*    test-kwote ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-kwote)
   (test-module "kwote" "kwote.scm" #f)
   (test "kwote" `(list ,(+ 1 2) 4) '(list 3 4))
   (test "kwote" (let ((name 'a)) `(list ,name ',name)) `(list a (quote a)))
   (test "kwote" `(a ,(+ 1 2) ,@(map (lambda (x) (+ 10 x))
				     '(4 -5 6))
		     b)
	 '(a 3 14 5 16 b))
   (test "kwote" `((foo ,(- 10 3)) ,@(cdr '(c)) . ,(car '(cons)))
	 '((foo 7) . cons))
   (test "kwote" `(a `(b ,(+ 1 2) ,(foo ,(+ 1 3) d) e) f)
	 '(a `(b ,(+ 1 2) ,(foo 4 d) e) f))
   (test "kwote" (let ((name1 'x)
		       (name2 'y))
		    `(a `(b ,,name1 ,',name2 d) e))
	 '(a `(b ,x ,'y d) e))
   (test "kwote" (quasiquote (list (unquote (+ 1 2)) 4))
	 '(list 3 4))
   (test "kwote" '(quasiquote (list (unquote (+ 1 2)) 4))
	 '`(list ,(+ 1 2) 4))
   (test "kwote" `#(1 2 ,(+ 1 2) ,(+ 2 2))
	 '#(1 2 3 4))
   (test "kwote" `#(1 2 ,(+ 1 2) ,@(map (lambda (x) (+ 1 x)) '(3 4)) 6)
	 '#(1 2 3 4 5 6)))
