;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/foreign.scm ...              */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue May 19 15:38:42 1992                          */
;*    Last change :  Wed Oct 26 13:39:41 1994 (serrano)                */
;*                                                                     */
;*    Le fichier principale de test des foreign                        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module foreign
   (include "test.sch") 
   (import  (bis big-file "big-file.scm")
	    (main "main.scm"))
   (export  (test-foreign))
   (foreign (string hux (string) "hux")
            (int var "var")
	    (include "c-file.h")
	    (type el (struct ((int "key")
			      (el* "next"))
			     "struct el"))
	    (type tab (array int -11 11))
	    (int sum-el (el*) "sum_el")
	    (el*  define-el (int) "define_el")
	    (double sum-tab (tab int) "sum_tab")
	    (el*  make-dummy-el () "make_dummy_el")))

;*---------------------------------------------------------------------*/
;*    foo ... ...                                                      */
;*---------------------------------------------------------------------*/
(define (foo x)
   (bar x))
 
;*---------------------------------------------------------------------*/
;*    boo                                                              */
;*---------------------------------------------------------------------*/
(define (boo s)
   (hux s))
 
;*---------------------------------------------------------------------*/
;*    test-struct ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-struct n)
   (let ((head (make-el)))
      (el-key-set! head 0)
      (let loop ((n  n)
		 (c  head))
	 (if (= n 0)
	     (sum-el c)
	     (let ((new (make-el)))
		(el-key-set!  new n)
		(el-next-set! new c)
		(loop (- n 1) new))))))

;*---------------------------------------------------------------------*/
;*    test-array ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-array n)
   (let ((tab (make-tab)))
      (let loop ((i (- n)))
	 (if (> i n)
	     (sum-tab tab 21)
	     (begin
		(tab-set! tab i i)
		(loop (+ i 1)))))))

;*---------------------------------------------------------------------*/
;*    lux ...                                                          */
;*---------------------------------------------------------------------*/
(define (lux pred? el)
   (pred? el))

;*---------------------------------------------------------------------*/
;*    test-foreign ...                                                 */
;*---------------------------------------------------------------------*/
(define (test-foreign)
   (test-module "foreign" "foreign.scm" #f)
   (test "foreign"    var 9)
   (test "foreign"    (begin (set! var (+ 1 var)) var) 10)
   (test "foreign"    (foo 4) 5)
   (test "foreign"    (boo "toto n'est pas content") "TOTO EST CONTENT")
   (test "foreign"    (bis 5) 6)
   (test "struct"     (test-struct 5) (+ 0 1 2 3 4 5))
   (test "struct-ref" (el-key (define-el 5)) 5)
   (test "array-ref"  (tab-ref (let ((tab (make-tab)))
				  (tab-set! tab 0 5)
				  tab)
			       0) 5)
   (test "array"      (inexact->exact (test-array 10)) 0)
   (test "eq?"        (make-dummy-el) (make-dummy-el))
   (test "checker"    (el? (make-el)) #t)
   (test "checker"    (el? 7) #f)
   (test "checker"    (lux el? (make-el)) #t)
   (test "checker"    (lux el? 7) #f))



		    
		     
	       
