;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/0cfa.scm ...                 */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul  7 11:13:48 1993                          */
;*    Last change :  Tue Jan 18 11:01:33 1994 (serrano)                */
;*                                                                     */
;*    Quelques tests sur la 0cfa                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module 0cfa
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-0cfa)))

;*---------------------------------------------------------------------*/
;*    Un test qui ne se compilait pas                                  */
;*---------------------------------------------------------------------*/
(define (foo x)
   (begin 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9
	  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9)
   (labels ((bar () gee)
            (gee (y) (+fx y 1)))
      ((bar) 5)))

(foo 1)

;*---------------------------------------------------------------------*/
;*    set-car ...                                                      */
;*---------------------------------------------------------------------*/
(define (set-car)
   (let ((l (cons 1 2)))
      (let ((y (car l)))
	 (set-car! l '())
	 (integer? (car l)))))

;*---------------------------------------------------------------------*/
;*    extra-light ...                                                  */
;*---------------------------------------------------------------------*/
(define (foo-of-extra-light f)
   (begin 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9
	  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9)
   (f))

(define (extra-light x)
   (labels ((f1 () x)
	    (f2 () (f1)))
      (foo-of-extra-light f2)))

;*---------------------------------------------------------------------*/
;*    test-0cfa ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-0cfa)
   (test-module "0cfa" "0cfa.scm" #f)
   (test "set-car!" (set-car) #f)
   (test "extra-light" (extra-light 1) 1))
