;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/examples/Pp/reader.scm ...           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 22 15:23:18 1992                          */
;*    Last change :  Sat Nov 12 16:02:07 1994 (serrano)                */
;*                                                                     */
;*    Le reader de `Bigloo'                                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module pp-reader
   (import  (pp "pp.scm"))
   (export  pp-read))

;*---------------------------------------------------------------------*/
;*    pp-read ...                                                      */
;*---------------------------------------------------------------------*/
(define pp-read
   (let* ((par-open      0)
	  (grammar
	   (regular-grammar ((chiffre (>-< #\0 #\9))
			     (float   (! ((* chiffre) #\. (+ chiffre))
					 ((+ chiffre) #\. (* chiffre))))
			     (lettre  (>-< #\a #\z #\A #\Z #a128 #a255))
			     (special (in #\! #\@ #\# #\$ #\%
					  #\^ #\& #\* #\> #\<
					  #\/ #\. #\- #\_ #\+   
					  #\\ #\| #\{ #\= #\?
					  #\} #\: #\~))
			     (quote   (in #\" #\, #\' #\`))
			     (paren   (in #\( #\) #\[ #\]))
			     (blank   (in #\space #\tab #\newline))
			     (id      ((! lettre chiffre special)
				       (* (! lettre chiffre special quote)))))
	      ((+ blank)                    ;; on oublie les separateurs
	       (ignore))  
	      ((#\# #\\ (! lettre           ;; Les caracteres normaux
			   chiffre
			   special
			   quote
			   paren
			   ";"))
	       (string-ref (the-string) 2))
	      (((* #\space) ";" (* (all)))  ;; les commentaires
	       (if *ignore-comment*
		   (ignore)
		   (let* ((string (the-string))
			  (indice (let loop ((i 0))
				     (if (char=? (string-ref string i) #\;)
					 i
					 (loop (+fx i 1))))))
		      (list 'COMMENT
			    indice
			    (substring string
				       indice
				       (string-length string))))))
	      ((#\# #\\ (uncase "newline")) ;; retour charriot
	       #\newline)
	      ((#\# #\\ (uncase "tab"))     ;; tabulation
	       #\tab)
	      ((! (#\# #\\ (uncase "space"));; espace
		  (#\# #\\ #\space))
	       #\space)
	      ((#\# #\\ (uncase "return"))  ;; carriage return
	       (integer->char 13))
	      ((#\" (* (! (out #\\ #\")     ;; Les chaines de caracteres
			  (#\\ (all)))) #\")
	       (escape-scheme-string (the-small-string)))
	      ((#\# #\"                   ;; Les chaines de caracteres foreign
		    (* (! (out #\\ #\")  
			  (#\\ (all)))) #\")
	       (escape-C-string (the-small-string)))
	      (((! #\" (#\# #\"))         ;; Les bouts de chaines non termines
		(* (! (out #\\ #\")  
		      (#\\ (all)))))
	       (error "read" "Unexpected end-of-file" (the-string)))
	      ((! (+ chiffre)             ;; Les entiers
		  (#\- (+ chiffre))
		  (#\+ (+ chiffre)))
	       (string->integer (the-string) 10))
	      (("#o" (! (+ (>-< #\0 #\7)) ;; Les entiers en base 8
			((in #\+ #\-)
			 (>-< #\0 #\7))))
	       (string->integer (substring (the-string) 2 (the-length)) 8))
	      (("#d" (! (+ chiffre)       ;; Les entiers en base 10
			((in #\+ #\-)
			 chiffre)))
	       (string->integer (substring (the-string) 2 (the-length)) 10))
	      (("#x" (! (+ (! chiffre     ;; Les entiers en base 10
			      (>-< #\a #\f)
			      (>-< #\A #\F)))
			((in #\+ #\-)
			 (+ (! chiffre
			       (>-< #\a #\f)
			       (>-< #\A #\F))))))
	       (string->integer (substring (the-string) 2 (the-length)) 16))
	      ((! float                   ;; Les reels
		  ((in #\+ #\-) float)
		  ((! float (+ chiffre))
		   (in #\e #\E) (+ chiffre)) 
		  ((in #\+ #\-) (! float (+ chiffre)) (in #\e #\E) (+ chiffre))
		  ((! float (+ chiffre)) (in #\e #\E) (in #\+ #\-) (+ chiffre))
		  ((in #\+ #\-) (! float (+ chiffre))
				(in #\e #\E) (in #\+ #\-) (+ chiffre)))
	       (string->real (the-string)))
	      (pair (#\. (* blank) #\))
		    (error "read" "Illegal pair" (the-string)))
	      (pair (#\.)                ;; Le point des pairs pointees
		    '__dot__)
	      ((#\.)
	       (error "read" "Illegal token" #\.))
	      ((uncase "#t")             ;; true
	       #t)
	      ((uncase "#f")             ;; false
	       #f)
	      (("#unspecified")   ;;
	       (unspecified))
	      ((! id (#\. (+ #\.)))      ;; Les identificateurs
	       (if (eq? *case* 'respect)
		   (string->symbol (the-string)) 
		   (the-symbol)))
	      ((#\')                     ;; Les simples quotations
	       (cons 'quote (cons (ignore) '())))
	      ((#\`)                     ;; Les quasiquotes
	       (cons 'quasiquote (cons (ignore) '())))
	      ((#\,)                     ;; Les unquotations
	       (cons 'unquote (cons (ignore) '())))
	      ((#\, #\@)                 ;; Les unquote-splicing
	       (cons 'unquote-splicing (cons (ignore) '())))
	      ((in #\( #\[)              ;; Les parentheses ouvrantes
	       (let ((open-key par-open))
		 (set! par-open (+fx 1 par-open))
		 (context 'pair)
		 (let loop-pair ((walk (ignore))) 
		   (cond
		    ((eq? walk '__dot__) ;; une pair pointee
		     (context)
		     (let ((cdr (ignore)))
		       (ignore)
		       (if (=fx open-key par-open)
			   (begin
			     (context 'pair)
			     cdr)
			   (error "read" "Illegal pair" cdr))))
		    ((=fx open-key par-open)
		     (if (=fx open-key 0)
			 (context))
		     '())
		    (else
		     (cons walk (loop-pair (ignore))))))))
	      ((in #\) #\])               ;; Les parentheses fermantes
	       (set! par-open (-fx par-open 1))
	       (if (<fx par-open 0)
		   (begin
		     (set! par-open 0)
		     (ignore))
		   #f))
	      ((#\# #\()                 ;; Les debuts de vecteur
	       (let ((open-key par-open))
		 (set! par-open (+fx 1 par-open))
		 (list->vector (let loop-vector ((walk (ignore)))
				 (cond
				  ((=fx open-key par-open)
				   '())
				  (else
				   (cons walk (loop-vector (ignore)))))))))
	      ((#\# chiffre chiffre chiffre #\() ;; Les debuts de vect. (tages)
	       (let ((open-key par-open)
		     (tag      (string->integer (substring (the-string) 1 4))))
		  (set! par-open (+fx 1 par-open))
		  (let ((res (list->vector
			      (let loop-vector ((walk (ignore)))
				 (cond
				    ((=fx open-key par-open)
				     '())
				    (else
				     (cons walk (loop-vector (ignore)))))))))
		     (vector-tag-set! res tag)  
		     res)))
	      (else
	       (let ((char (the-failing-char)))
		 (if (eof-object? char)
		     (if (>fx par-open 0)
			 (error "read" "Unexpected end-of-file" char)
			 (begin
			    (reset-eof input-port)
			    char))
		     (error "read"
			    "Illegal char"
			    (illegal-char-rep char))))))))
     (lambda input-port
       (if (null? input-port)
	   (read/rp grammar (current-input-port))
	   (read/rp grammar (car input-port))))))

		      
		 

