;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../expanded.scm ...                                             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 18 14:25:54 1992                          */
;*    Last change :  Tue Jul 12 10:59:22 1994 (serrano)                */
;*                                                                     */
;*    On ecrit du scheme expanse                                       */
;*---------------------------------------------------------------------*/
  
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module write_expanded
   (include "Var/variable.sch"
	    "0cfa/app.sch"
	    "Foreign/type.sch")
   (import  var_env
	    var_variable
	    engine_param
	    write_scheme
	    tools_args
	    tools_file
	    tools_hash)
   (static  (shape exp))
   (export  (write-expanded expanded)))

;*---------------------------------------------------------------------*/
;*    write-expanded ...                                               */
;*---------------------------------------------------------------------*/
(define (write-expanded expanded)
   (let* ((output-name (if (string? *dest*)
			   *dest*
			   (if (string? *src*)
			       (string-append (remove-extansion *src*) ".escm")
			       #f)))
	  (port        (if (string? output-name)
			   (open-output-file output-name)
			   (current-output-port))))
      (if (not (output-port? port))
	  (error "write-expanded" "Can't open file" output-name)
	  (let ((handler (lambda (escape proc mes obj)
			    (notify-error proc mes obj)
			    (close-output-port port)
			    (exit -4))))
	     (try (begin
		     (write-scheme-file-header
		      port "Le fichier scheme macro expanse")
		     (for-each (lambda (code)
				  (match-case code
				     ((define (?name . ?args) ?value)
				      (write `(define ,(cons name args)
						  ,(shape value)) port))
				     ((define ?name ?value)
				      (write `(define ,name ,(shape value))
					     port))
				     ((define-inline (?name . ?args) ?value)
				      (write `(define-inline
						 ,(cons name args)
						 ,(shape value))
					     port))
				     (else
				      (write (shape code) port))))
			       expanded))
		  handler)))))

;*---------------------------------------------------------------------*/
;*    shape ...                                                        */
;*---------------------------------------------------------------------*/
(define (shape exp)
  (cond
      ((global? exp)
       (global-shape exp))
      ((local? exp)
       (local-shape exp))
      ((app? exp)
       'app)
      ((type? exp)
       (type-id exp))
      ((vector? exp)
       (let* ((len (vector-length exp))
	      (res (make-vector len '())))
	  (let loop ((indice 0))
	     (if (=fx indice len)
		 res
		 (begin
		    (vector-set! res
				 indice
				 (shape (vector-ref exp indice)))
		    (loop (+fx indice 1)))))))
      ((not (pair? exp))
       exp)
      ((eq? (car exp) 'typed-case)
       `(case ,(shape (caddr exp)) ,@(map shape (cdddr exp))))
      (else
       (let loop ((exp exp))
	  (cond
	     ((null? exp)
	      '())
	     ((not (pair? exp))
	      (shape exp))
	     (else
	      (cons (shape (car exp)) (loop (cdr exp)))))))))
   


