;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.7/Var/pragma.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar 28 11:31:19 1993                          */
;*    Last change :  Sat Oct 29 09:41:43 1994 (serrano)                */
;*                                                                     */
;*    La gestion des pragma des variables globales                     */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module var_pragma
   (include "Var/variable.sch")
   (import  tools_error
	    tools_speek
	    var_env)
   (export  (put-pragma! list)
	    (add-pragma! global pragma)
	    (pragma-no-side-effect? global)
	    (pragma-allocater?      global)
	    (pragma-no-mutation?    global)
	    (pragma-imutable?       global)
	    (pragma-imbricable?     global)
	    (pragma-no-eval-value?  global)
	    (check-pragma?          pragma)))

;*---------------------------------------------------------------------*/
;*    check-pragma? ...                                                */
;*    -------------------------------------------------------------    */
;*    On verifie si la `pragma' est correcte (connue) du               */
;*    compilateur.                                                     */
;*---------------------------------------------------------------------*/
(define (check-pragma? pragma)
   (let loop ((pragma pragma))
      (cond
	 ((null? pragma)
	  #t)
	 ((memq (car pragma) '(_dont_return_
			       _dont_return_but_
			       _no_side_effect_
			       _imutable_
			       _no_mutation_
			       _imbricable_
			       _allocater_
			       _no_eval_value_))
	  (loop (cdr pragma)))
	 ((pair? (car pragma))
	  (loop (cdr pragma)))
	 ((vector? (car pragma))
	  (loop (cdr pragma)))
	 (else
	  #f))))

;*---------------------------------------------------------------------*/
;*    add-pragma! ...                                                  */
;*---------------------------------------------------------------------*/
(define (add-pragma! global one-pragma)
   (if (not (check-pragma? (list one-pragma)))
       (warning "add-pragma!" "Illegal pragma" one-pragma)
       (global-pragma-set! global (cons one-pragma (global-pragma global)))))

;*---------------------------------------------------------------------*/
;*    put-pragma! ...                                                  */
;*---------------------------------------------------------------------*/
(define (put-pragma! pragma-list)
   (let loop ((l pragma-list))
      (if (null? l)
	  'done
	  (let* ((pragma (car l))
		 (fun    (car pragma))
		 (prop   (cdr pragma)))
	     (if (not (check-pragma? prop))
		 (warning "put-pragma!" "Illegal pragma" prop))
	     (let ((global (find-in-global-environment fun *Genv*)))
		(if (not (global? global))
		    (error "put-pragma!"
			   "Unbound variable" fun)
		    (begin
		       (global-pragma-set! global prop)
		       (loop (cdr l)))))))))

;*---------------------------------------------------------------------*/
;*    pragma-no-side-effect? ...                                       */
;*---------------------------------------------------------------------*/
(define (pragma-no-side-effect? global)
   (pair? (memq '_no_side_effect_ (global-pragma global))))

;*---------------------------------------------------------------------*/
;*    pragma-allocater? ...                                            */
;*---------------------------------------------------------------------*/
(define (pragma-allocater? global)
   (pair? (memq '_allocater_ (global-pragma global))))
       
;*---------------------------------------------------------------------*/
;*    pragma-no-mutation? ...                                          */
;*---------------------------------------------------------------------*/
(define (pragma-no-mutation? global)
   (pair? (memq '_no_mutation_ (global-pragma global))))
       
;*---------------------------------------------------------------------*/
;*    pragma-imutable? ...                                             */
;*---------------------------------------------------------------------*/
(define (pragma-imutable? global)
   (pair? (memq '_imutable_ (global-pragma global))))
       
;*---------------------------------------------------------------------*/
;*    pragma-imbricable? ...                                           */
;*    -------------------------------------------------------------    */
;*    Peut-on imbrique une appel a une fonction dans un autre ?        */
;*---------------------------------------------------------------------*/
(define (pragma-imbricable? global)
   (pair? (memq '_imbricable_ (global-pragma global))))

;*---------------------------------------------------------------------*/
;*    pragma-no-eval-value? ...                                        */
;*    -------------------------------------------------------------    */
;*    Peut-on passer la fonction a eval ?                              */
;*---------------------------------------------------------------------*/
(define (pragma-no-eval-value? global)
   (pair? (memq '_no_eval_value_ (global-pragma global))))

