;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Type/enforce.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 25 10:50:33 1993                          */
;*    Last change :  Mon May  9 14:12:51 1994 (serrano)                */
;*                                                                     */
;*    On force les objects a avoir les bons types                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_enforce
   (include "Tools/trace.sch"
	    "Var/variable.sch")
   (import  engine_param
	    foreign_atomic
	    tools_error
	    tools_speek
	    tools_shape
	    heap_abstract
	    scan_lexical
	    type_type
	    type_cast)
   (export  (enforce-procedure arity exp)
	    (enforcer tester   type-name)))

;*---------------------------------------------------------------------*/
;*    enforce-procedure ...                                            */
;*---------------------------------------------------------------------*/
(define (enforce-procedure arity proc)
   (enforce-arity arity
		  (if *unsafe-type*
		      proc
		      (check (lambda (exp)
				(abstract 'c-procedure? exp))
			     proc 'procedure))
		  proc))

;*---------------------------------------------------------------------*/
;*    enforce-arity ...                                                */
;*---------------------------------------------------------------------*/
(define (enforce-arity arity procedure proc-name)
   (if *unsafe-arity*
       procedure
       (if (pair? procedure)
	   (let ((aux (get-type-aux-var proc-name)))
	      `(let ((,aux ,procedure))
		  ,(enforce-atom-arity arity aux)))
	   (enforce-atom-arity arity procedure))))

;*---------------------------------------------------------------------*/
;*    enforce-atom-arity ...                                           */
;*---------------------------------------------------------------------*/
(define (enforce-atom-arity arity procedure)
   `(cif ,(abstract 'procedure-correct-arity? procedure arity)
	 ,procedure
	 (failure ,(list 'quote (current-function))
		  ,(abstract-cstring->bstring
		    "Wrong number of arguments for")
		  ,(list 'quote (shape procedure)))))

;*---------------------------------------------------------------------*/
;*    enforcer ...                                                     */
;*---------------------------------------------------------------------*/
(define (enforcer checker type-name)
   (lambda (exp)
      (if *unsafe-type*
	  exp
	  (check checker
		 exp
		 type-name))))

;*---------------------------------------------------------------------*/
;*    check ...                                                        */
;*---------------------------------------------------------------------*/
(define (check checker exp type)
   (define (check-atom exp)
      (let ((check (checker exp)))
	 `(cif ,(cast check (type-of check) *bool*)
	       ,exp
	       (failure ,(list 'quote (current-function))
			,(abstract-type-error (list 'quote type)
					      (list 'quote (shape exp)))
			,exp))))
   (if (pair? exp)
       (let ((aux (get-type-aux-var exp)))
	  `(let ((,aux ,exp))
	      ,(check-atom aux)))
       (check-atom exp)))

;*---------------------------------------------------------------------*/
;*    get-type-aux-var ...                                             */
;*---------------------------------------------------------------------*/
(define (get-type-aux-var exp)
   (let ((type-aux-name (cond
			   ((global? exp)
			    (global-name exp))
			   ((local? exp)
			    (local-name exp))
			   (else
			    'type-aux))))
      (cdar (allocate-local-variables (list type-aux-name)))))
      
