;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/bigloo1.7/comptime1.7/Type/app.scm ...                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 24 17:11:36 1993                          */
;*    Last change :  Thu Aug 11 11:33:56 1994 (serrano)                */
;*                                                                     */
;*    On type une application (c'est la que ca se corse...)            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_application
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "Foreign/type.sch")
   (import  type_enforce
	    type_cast
	    type_expression
	    type_type
	    foreign_atomic
	    tools_error
	    tools_shape
	    heap_abstract
	    scan_lexical)
   (export  (type-atom-application exp to)
	    (type-unknown-bigloo-application exp to)
	    (type-foreign-application exp from to)))

;*---------------------------------------------------------------------*/
;*    type-atom-application ...                                        */
;*---------------------------------------------------------------------*/
(define (type-atom-application exp to)
   (let ((fun (car exp))
	 class
	 value)
      (cond
	 ((global? fun)
	  (set! class (global-class fun))
	  (set! value (global-value fun)))
	 ((local? fun)
	  (set! class (local-class fun))
	  (set! value (local-value fun)))
	 (else
	  (partial-error "" "Illegal application" (shape exp))))
      (cond
	 ((eq? class 'foreign)
	  (type-foreign-application exp
				    (foreign-type value)
				    to))
	 ((eq? class 'function)
	  (type-known-bigloo-application exp value to))
	 ((eq? class 'return)
	  (type-return-application exp value to))
	 (else
	  (type-unknown-bigloo-application exp to)))))

;*---------------------------------------------------------------------*/
;*    type-known-bigloo-application ...                                */
;*    -------------------------------------------------------------    */
;*    Ici, on se contente de verifier que les arites sont correctes    */
;*    et eventuellement construire la liste d'appelle pour les         */
;*    fonctions a arite multiple.                                      */
;*---------------------------------------------------------------------*/
(define (type-known-bigloo-application exp fun to)
   (if (>=fx (function-arity fun) 0)
       (type-known-bigloo-fx-application exp fun to)
       (type-known-bigloo-va-application exp fun to)))

;*---------------------------------------------------------------------*/
;*    type-known-fx-application ...                                    */
;*---------------------------------------------------------------------*/
(define (type-known-bigloo-fx-application exp fun to)
   (if (not (=fx (function-arity fun) (length (cdr exp))))
       (partial-error "" "Wrong number of argument for" (shape (car exp)))
       (let loop ((hook (cdr exp)))
	  (if (null? hook)
		 ;; on n'a pas besoin de tester le `car' de `exp' car on
	      ;; sait deja que c'est une variable qui est liee a une
	      ;; fonction.
	      (cast exp *bobj* to)
	      (begin
		 (set-car! hook (type-expression (car hook) *bobj*))
		 (loop (cdr hook)))))))

;*---------------------------------------------------------------------*/
;*    type-known-bigloo-va-application ...                             */
;*---------------------------------------------------------------------*/
(define (type-known-bigloo-va-application exp fun to)
   ;; attention, c'est express que je mesure exp et non pas (cdr exp),
   ;; c'est pour m'eviter de rajouter 1 !! :-D
   (if (>fx (negfx (length exp)) (function-arity fun))
       (partial-error "" "Too few arguments provided" (shape (car exp)))
       (let loop ((hook    exp)
		  (counter (function-arity fun)))
	  (if (=fx counter -1) 
	      (let ((new (make-args-list (cdr hook))))
		 (if (null? (cdr hook))
		     (set-cdr! hook (cons new '()))
		     (begin
			(set-car! (cdr hook) new)
			(set-cdr! (cdr hook) '())))
		 (cast exp *bobj* to))
	      (begin
		 (set-car! (cdr hook) (type-expression (cadr hook) *bobj*))
		 (loop (cdr hook)
		       (+fx counter 1)))))))
	 
;*---------------------------------------------------------------------*/
;*    make-args-list ...                                               */
;*    -------------------------------------------------------------    */
;*    Afin que les listes construite ici puisse beneficier des         */
;*    optimisations ulterieur, il faut que l'arbre de syntaxe cree     */
;*    ici ait le meme aspect que s'il provenait d'un prgm source.      */
;*    Cela veut dire qu'il faut que les `cons' soient introduits       */
;*    au moyen de variables auxiliaires.                               */
;*---------------------------------------------------------------------*/
(define (make-args-list actuals)
   ;; on construit (en syntaxe abstraite) une serie de cons.
   (let loop ((actuals  (reverse actuals))
	      (previous (abstract-nil)))
      (if (null? actuals)
	  previous
	  (let ((aux (allocate-local-variable 'va-arg)))
	     `(let ((,aux ,(abstract-cons
			    (type-expression (car actuals) *bobj*)
			    previous)))
		 ,(loop (cdr actuals) aux))))))

;*---------------------------------------------------------------------*/
;*    type-return-application ...                                      */
;*---------------------------------------------------------------------*/
(define (type-return-application exp fun to)
   (if (not (=fx 1 (length (cdr exp))))
       (partial-error "" "Wrong number of argument for" (shape (car exp)))
       (let loop ((hook (cdr exp)))
	  (if (null? hook)
	      (begin
		 (set-cdr! exp (cons (car exp) (cdr exp)))
		 (set-car! exp 'return-from)
		 (cast exp *bobj* to))
	      (begin
		 (set-car! hook (type-expression (car hook) *bobj*))
		 (loop (cdr hook)))))))
   
;*---------------------------------------------------------------------*/
;*    type-unknown-bigloo-application ...                              */
;*    -------------------------------------------------------------    */
;*    On pose les tests verfiant que c'est bien une fonction et on     */
;*    fait un appel calcule                                            */
;*    -------------------------------------------------------------    */
;*    On passe toujours un argument supplementaire lors d'un appel     */
;*    calcule pour que les va_list puisse etre examinee en faisant     */
;*    un `*++'.                                                        */
;*---------------------------------------------------------------------*/
(define (type-unknown-bigloo-application exp to)
   (trace type "type-unknown-bigloo-application: " (shape exp) #\Newline)
   (if (null? (cdr exp))
       (begin
	  (set-car! exp (enforce-procedure (length (cdr exp))
					   (type-expression (car exp)
							    *bobj*)))
	  (set-cdr! exp (cons (abstract-eoa) '()))
	  (cast (cons 'funcall exp) *bobj* to))
       (let loop ((hook (cdr exp)))
	  (if (null? (cdr hook))
	      (begin
		 (set-car! hook (type-expression (car hook) *bobj*))
		 (set-car! exp (enforce-procedure (length (cdr exp))
						  (type-expression (car exp)
								   *bobj*)))
		 (set-cdr! hook (cons (abstract-eoa) '()))
		 (cast (cons 'funcall exp) *bobj* to))
	      (begin
		 (set-car! hook (type-expression (car hook) *bobj*))
		 (loop (cdr hook)))))))
 
;*---------------------------------------------------------------------*/
;*    type-foreign-application ...                                     */
;*    -------------------------------------------------------------    */
;*    On pose les tests de verfication de type et on pose les casts.   */
;*---------------------------------------------------------------------*/
(define (type-foreign-application exp from to)
   (trace type "type-foreign-application: " (shape exp) #\Newline)
   (let ((fun       (car exp)))
      (if (not (eq? (type-type from) 'function))
	  (begin
	     (partial-error ""
			    "Illegal application of foreign variable"
			    (shape fun))
	     exp)
	  (let ((type-res  (car (type-exp from)))
		(type-args (cdr (type-exp from))))
	     (if (eq? (type-type type-res) 'function)
		 (begin
		    (partial-error
		     ""
		     "Foreign functions returning functions are forbidden"
		     (shape exp))
		    exp)
		 (let loop ((hook  (cdr exp))
			    (types type-args))
		    (cond
		       ((null? hook)
			(cond
			   ((null? types)
			    (cast exp type-res to))
			   ((not (pair? types))
			    (cast exp type-res to))
			   (else
			    (partial-error
			     ""
			     "Too few arguments provided to foreign function"
			     (shape fun)))))
		       ((null? types)
			(partial-error
			 ""
			 "Too many arguments provided to foreign function"
			 (shape fun))
			exp)
		       ((not (pair? types))
			;; c'est une fonction a arite variable ...
			(let laap ((hook hook))
			   (if (null? hook)
			       (cast exp type-res to)
			       (begin
				  (set-car! hook
					    (type-expression (car hook) types))
				  (laap (cdr hook))))))
		       (else
			(begin
			   (set-car! hook (type-expression (car hook)
							   (car types)))
			   (loop (cdr hook)
				 (cdr types)))))))))))


