;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Stack/tail.scm ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jun 19 10:08:12 1994                          */
;*    Last change :  Thu Jun 23 16:06:48 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Le module contenant l'implementation de la propriete `tail'.     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module stack_tail
   (include "Stack/property.sch"
	    "Tools/trace.sch"
	    "Var/variable.sch")
   (import  tools_shape
	    tools_error
	    engine_param
	    stack_result)
   (export  (tailly-callable? fun)
	    (set-current-function! var)))

;*---------------------------------------------------------------------*/
;*    La fonction courrante                                            */
;*---------------------------------------------------------------------*/
(define *current-function* (unspecified))

;*---------------------------------------------------------------------*/
;*    set-current-function! ...                                        */
;*---------------------------------------------------------------------*/
(define (set-current-function! var)
   (set! *current-function* var))

;*---------------------------------------------------------------------*/
;*    tailly-callable? ...                                             */
;*    -------------------------------------------------------------    */
;*    Est-ce qu'une fonction peut-etre invoquer sans consommation de   */
;*    pile ? Dans l'implentation vers C seules les selfs-recursions et */
;*    les recursions locales peuvent-etre `tailly-callble?'.           */
;*---------------------------------------------------------------------*/
(define (tailly-callable? fun)
   (let ((res (cond
		 ((eq? *current-function* fun)
		  #t)
		 ((local? fun)
		  #t)
		 (*full-tail-recursion?*
		  #t)
		 (else
		  #f))))
      (trace (stack loop) "tailly-callable?: " (shape fun) " : " res #\Newline)
      res))




