;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Stack/result.scm ...     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jun 18 19:45:18 1994                          */
;*    Last change :  Mon Jul  4 17:52:15 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Ce fichier contient l'implantation du predicat `result?' qui     */
;*    retourne vrai si une variable peut-etre le resultat d'une        */
;*    expression. Le predicat est au sens large puisqu'il doit tenir   */
;*    compte des alias introduit par des `let'. Mais ce predicat ne    */
;*    tient pas compte des structures de donnees.                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module stack_result
   (include "Stack/property.sch"
            "Tools/trace.sch"
            "Var/variable.sch")
   (import  heap_abstract
	    tools_shape
            stack_expression
            stack_tail)
   (export  (is-the-temporary-a-result? local let-exp tail? depth)))

;*---------------------------------------------------------------------*/
;*    is-the-formal-a-result ...                                       */
;*    -------------------------------------------------------------    */
;*    Est-ce qu'un parametre formel d'une fonction peut en etre        */
;*    un resultat ?                                                    */
;*---------------------------------------------------------------------*/
(define (is-the-formal-a-result formal-num var)
   (trace (stack loop) "is-the-formal-a-result: " formal-num " " (shape var)
          #\Newline)
   (if (global? var)
       (is-the-formal-of-global-a-result? formal-num var)
       (is-the-formal-of-function-a-result? formal-num (local-value var))))

;*---------------------------------------------------------------------*/
;*    is-the-formal-of-global-a-result? ...                            */
;*---------------------------------------------------------------------*/
(define (is-the-formal-of-global-a-result? formal-num var)
   (trace (stack loop)
          "is-the-formal-of-global-a-result?: " formal-num
          #\Newline)
   (cond
      ((eq? (global-class var) 'foreign)
       (is-the-formal-a-pragma-result formal-num var))
      ((not (null? (global-library? var)))
       (is-the-formal-a-pragma-result formal-num var))
      ((eq? (global-import var) 'import)
       #t)
      (else
       (is-the-formal-of-function-a-result? formal-num (global-value var)))))

;*---------------------------------------------------------------------*/
;*    is-the-formal-a-pragma-result ...                                */
;*---------------------------------------------------------------------*/
(define (is-the-formal-a-pragma-result num var)
   (trace (stack loop)
          "is-the-formal-a-pragma-result: " num
          #\Newline)
   (if (memq '_dont_return_ (global-pragma var))
       #f
       (let ((but (memq '_dont_return_but_ (global-pragma var))))
          (if (not (pair? but))
              #t
              (let ((as (assq num (cadr but))))
                 (if (pair? as)
                     (cdr as)
                     #f))))))

;*---------------------------------------------------------------------*/
;*    is-the-formal-of-function-a-result? ...                          */
;*---------------------------------------------------------------------*/
(define (is-the-formal-of-function-a-result? formal-num function)
   (trace (stack loop) "is-the-formal-of-function-a-result: "
          formal-num #\Newline)
   (let ((formal (list-ref (function-args function) formal-num)))
      (if (and (s-property? (local-info formal))
               (boolean? (s-property-returned? (local-info formal))))
          (s-property-returned? (local-info formal))
          (begin
             (if (not (s-property? (local-info formal)))
                 (begin
                    (local-info-set! formal (default-s-property))
                    ;; on met a jour les champs de `s-property'
                    (s-property-depth-set! (local-info formal) 0)))
             (let ((result (result? formal (function-body function) #t 0)))
                (s-property-returned?-set! (local-info formal) result)
                result)))))

;*---------------------------------------------------------------------*/
;*    is-the-temporary-a-result? ...                                   */
;*    -------------------------------------------------------------    */
;*    Est-ce qu'une variable locale liee dans un let peut-etre         */
;*    le resultat de ce `let' ?                                        */
;*---------------------------------------------------------------------*/
(define (is-the-temporary-a-result? local let-exp tail? depth)
   (if (and (s-property? (local-info local))
            (boolean? (s-property-returned? (local-info local))))
       (s-property-returned? (local-info local))
       (begin
          (let ((result (result? local (caddr let-exp) tail? depth)))
             (s-property-returned?-set! (local-info local) result)
             result))))

;*---------------------------------------------------------------------*/
;*    *current-local-variable* ...                                     */
;*---------------------------------------------------------------------*/
(define *current-local-variable* '())

;*---------------------------------------------------------------------*/
;*    result? ...                                                      */
;*    var x exp -> { #t, #f }                                          */
;*    -------------------------------------------------------------    */
;*    Est-ce que `var' peut-etre rendue comme resultat de `exp' ?      */
;*---------------------------------------------------------------------*/
(define (result? var exp tail? depth)
   (if (memq var *current-local-variable*)
       #f
       (begin
          (set! *current-local-variable* (cons var *current-local-variable*))
          (let ((res (results? (list var) exp tail? tail? depth)))
             (set! *current-local-variable* (cdr *current-local-variable*))
             res))))

;*---------------------------------------------------------------------*/
;*    results? ...                                                     */
;*    var * x exp x { #t, #f } x { #t, #f } x integer -> { #t, #f }    */
;*    -------------------------------------------------------------    */
;*    retourne vrai si une (au moins) des variables peut-etre          */
;*    retournee.                                                       */
;*    -------------------------------------------------------------    */
;*    - vars est la liste des variables verfiees.                      */
;*    - exp est l'expression dans laquelle ont fait la recherche.      */
;*    - local-tail? indique si localement on est en position tail (que */
;*      cette variable soit vrai n'est pas suffisant pour que les      */
;*      appels tail-rec soient bloquants (contrairement a `real-tail?')*/
;*    - real-tail? est-on vraiment en position tail-rec ?              */
;*    - depth est la profondeur des liaisons                           */
;*    -------------------------------------------------------------    */
;*    lorsqu'on evalue la partie gauche d'une liaison `let',           */
;*    local-tail est est vrai alors que real-tail est fausse. Ainsi    */
;*    les cas comme : (let ((v (cons 1 2)))                            */
;*                       (let ((u (begin 1 2 v)))                      */
;*                          1                                          */
;*                          (self u)))                                 */
;*    sont bien traites (il y a la meme procede lors d'appels          */
;*    fonctionnels).                                                   */
;*---------------------------------------------------------------------*/
(define (results? vars exp local-tail? real-tail? depth)
   (trace (stack loop) "results?    : "
          (shape vars)
          #\Newline
          "              : " (shape exp)
          #\Newline
          "  local-tail? : " local-tail?
          #\Newline
          "  real-tail?  : " real-tail?
          #\Newline)
   (if (not (pair? exp))
       (and local-tail? 
            (local? exp)
            (pair? (memq exp vars)))
       (case (car exp)
          ((quote)
           #f)
          ((begin pragma failure)
           (results*? vars exp local-tail? real-tail? depth))
	  ((cast)
	   (results? vars (caddr exp) local-tail? real-tail? depth))
          ((cif)
           (cond
              ((results? vars (cadr exp) #f #f depth)
               #t)
              ((results? vars (caddr exp) local-tail? real-tail? depth)
               #t)
              (else
               (results? vars (cadddr exp) local-tail? real-tail? depth))))
          ((set!)
           (result-as? (cadr exp) (caddr exp) vars depth))
          ((function function-extra-light function-light)
           ;; c'est presque le meme cas que pour les atoms ...
           (and local-tail?
                (local? (cadr exp))
                (pair? (memq (cadr exp) vars))))
          ((typed-case)
           (or (results? vars (caddr exp) #f #f depth)
               (let loop ((clauses (cdddr exp)))
                  (cond
                     ((null? clauses)
                      #f)
                     ((results? vars
                                (cadr (car clauses))
                                local-tail?
                                real-tail?
                                depth)
                      #t)
                     (else
                      (loop (cdr clauses)))))))
          ((let)
           (let loop ((vars     vars)
                      (bindings (cadr exp)))
              (if (null? bindings)
                  (results? vars
                            (caddr exp)
                            local-tail?
                            real-tail?
                            (+fx depth 1))
                  (let* ((binding (car bindings))
                         (local   (car binding)))
                     (if (not (s-property? (local-info local)))
                         (begin
                            (local-info-set! local (default-s-property))
                            ;; on met a jour les champs de `s-property'
                            (s-property-depth-set! (local-info local) depth)
                            (s-property-let-binding-set!   (local-info local)
                                                           exp)
                            (s-property-tail-binding?-set! (local-info local)
                                                           real-tail?)))
                     (if (results? vars (cadr binding) #t #f (+fx depth 1))
                         ;; c'est ici que local-tail? et real-tail? se
                         ;; separent (c.f. commentaire initial)
                         (loop (cons (car binding) vars)
                               (cdr bindings))
                         (loop vars
                               (cdr bindings)))))))
          ((labels)
           (results? vars (caddr exp) local-tail? real-tail? (+fx depth 1)))
          ((block return-from)
           #t)
	  ((apply)
	   (apply-results? vars exp local-tail? real-tail? depth))
	  ((funcall funcall-light)
	   (funcall-results? vars exp local-tail? real-tail? depth))
          (else
	   (if (pair? (car exp))
	       (funcall-extra-light-results? vars
					     exp
					     local-tail?
					     real-tail?
					     depth)
	       (application-results? vars
				     exp
				     local-tail?
				     real-tail?
				     depth))))))

;*---------------------------------------------------------------------*/
;*    funcall-extra-light-results? ...                                 */
;*---------------------------------------------------------------------*/
(define (funcall-extra-light-results? vars exp local-tail? real-tail? depth)
   (let* ((fun     (cdar exp))
	  (tailly? (and real-tail? (tailly-callable? fun))))
      ;; on fait une chose particuliere pour le premier argument
      (if (results? vars (car (cdr exp)) #t #f depth)
	  #t
	  ;; on se pose le pbm du return
	  (let* ((function (if (local? fun)
			       (local-value fun)
			       (global-value fun)))
		 (actuals (cddr exp)))
	     (let loop ((fnum    0)
			(actuals actuals))
		(cond
		   ((null? actuals)
		    #f)
		   ((and (null? (cdr actuals))
			 (abstract-eoa? (car actuals)))
		    #f)
		   ((results? vars (car actuals) #t #f depth)
		    ;; meme remarque que dans le `let', `real-tail?' et
		    ;; `local-tail?' se separent ici.
		    (if tailly?
			#t
			(let ((as (is-the-formal-a-result fnum fun)))
			   (cond
			      ((integer? as)
			       (if (not (result-as? (list-ref (cdr exp) as)
						    (car actuals)
						    vars
						    depth))
				   (loop (+fx fnum 1)
					 (cdr actuals))
				   #t))
			      ((not as)
			       (loop (+fx fnum 1)
				     (cdr actuals)))
			      (else
			       #t)))))
		   (else
		    (loop (+fx fnum 1)
			  (cdr actuals)))))))))

;*---------------------------------------------------------------------*/
;*    application-results? ...                                         */
;*---------------------------------------------------------------------*/
(define (application-results? vars exp local-tail? real-tail? depth)
   (let* ((fun     (car exp))
	  (tailly? (and real-tail? (tailly-callable? fun))))
      ;; on se pose le pbm du return
      (let* ((function (if (local? fun)
			   (local-value fun)
			   (global-value fun)))
	     (actuals (cdr exp)))
	 (let loop ((fnum    0)
		    (actuals actuals))
	    (if (null? actuals)
		#f
	       (let ((r (results? vars (car actuals) #t #f depth)))
		  (cond
		     ((eq? r 'capture)
		      #t)
		     (r
		      ;; meme remarque que dans le `let', `real-tail?' et
		      ;; `local-tail?' se separent ici.
		      (if tailly?
			  #t
			  (let ((as (is-the-formal-a-result fnum fun)))
			     (cond
				((integer? as)
				 (let ((r-as? (result-as? (list-ref (cdr exp)
								    as)
							  (car actuals)
							  vars
							  depth)))
				    (if (not r-as?)
					(loop (+fx fnum 1)
					      (cdr actuals))
					r-as?)))
				((not as)
				 (loop (+fx fnum 1)
				       (cdr actuals)))
				(else
				 #t)))))
		     (else
		      (loop (+fx fnum 1)
			    (cdr actuals))))))))))

;*---------------------------------------------------------------------*/
;*    funcall-results? ...                                             */
;*---------------------------------------------------------------------*/
(define (funcall-results? vars exp local-tail? real-tail? depth)
   (let loop ((actuals (cdddr exp)))
      ;; on prends juste le `cdddr' car il faut sauter l'environnement
      ;; systematiquement passe en argument a la fermeture.
      (cond
	 ((null? actuals)
	  #f)
	 ((results? vars (car actuals) #t #f depth)
	  'capture)
	 (else
	  (loop (cdr actuals))))))
	  
;*---------------------------------------------------------------------*/
;*    apply-results? ...                                               */
;*---------------------------------------------------------------------*/
(define (apply-results? vars exp local-tail? real-tail? depth)
   (let loop ((actuals (cdr exp)))
      (cond
	 ((null? actuals)
	  #f)
	 ((results? vars (car actuals) #t #f depth)
	  'capture)
	 (else
	  (loop (cdr actuals))))))
	  
;*---------------------------------------------------------------------*/
;*    results*? ...                                                    */
;*---------------------------------------------------------------------*/
(define (results*? vars exp local-tail? real-tail? depth)
   (let loop ((exp exp))
      (cond
         ((null? exp)
          #f)
         ((null? (cdr exp))
          (results? vars (car exp) local-tail? real-tail? depth))
         (else
          (if (results? vars (car exp) #f #f depth)
              #t
              (loop (cdr exp)))))))

;*---------------------------------------------------------------------*/
;*    result-as? ...                                                   */
;*---------------------------------------------------------------------*/
(define (result-as? as-var value vars depth)
   (trace (stack loop) "result-as?: " (shape as-var) " " (shape value) " "
          (shape vars) " " (shape *current-local-variable*)
          #\Newline)
   ;; lors d'un let, je fait une approximation grossiere:
   ;; soit la variable est definie avant dans la pile alors,
   ;; je repond vraie, soit elle est definie plus tard alors
   ;; dans ce cas, je regarde si elle est le resultat de son `let'
   (if (results? vars value #t #f depth)
       (cond
          ((global? as-var)
           'capture)
          ((not (local? as-var))
           'capture)
          ((older-variable? as-var (car *current-local-variable*))
           'capture)
          (else
           (result? as-var
                    (s-property-let-binding (local-info as-var))
                    (s-property-tail-binding? (local-info as-var))
                    (s-property-depth (local-info as-var)))))
       #f))

;*---------------------------------------------------------------------*/
;*    older-variable? ...                                              */
;*---------------------------------------------------------------------*/
(define (older-variable? var1 var2)
   (trace (stack loop) "older-variable?: " (shape var1) " " (shape var2)
	  #\Newline)
   (if (not (global? var1))
       (begin
	  (trace (stack loop) "depth( " (shape var1) " ): "
		 (s-property-depth (local-info var1))
		 #\Newline)
	  (trace (stack loop) "depth( " (shape var2) " ): "
		 (s-property-depth (local-info var2))
		 #\Newline)))
   (or (global? var1)
       (<=fx (s-property-depth (local-info var1))
             (s-property-depth (local-info var2)))))


