;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.7/Scan/lexical.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar 21 11:13:05 1993                          */
;*    Last change :  Tue Jul 26 13:15:08 1994 (serrano)                */
;*                                                                     */
;*    Les manipulations de l'environment lexical                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_lexical
   (include "Var/variable.sch")
   (import  tools_args
	    foreign_atomic)
   (export  (allocate-local-variables args)
	    (allocate-local-variable  args)
	    (allocate-local-functions args)
	    (allocate-local-return    arg)
	    (copy-local-variable      var)
	    get-new-key
	    (lookup? name lexical-env)
	    (re-lookup-value)))

;*---------------------------------------------------------------------*/
;*    get-new-key ...                                                  */
;*---------------------------------------------------------------------*/
(define get-new-key
   (let ((key (- 1)))
      (lambda ()
	 (set! key (+fx key 1))
	 key)))
      
;*---------------------------------------------------------------------*/
;*    allocate-local-variables ...                                     */
;*---------------------------------------------------------------------*/
(define (allocate-local-variables args)
   (map-on-args (lambda (arg)
		   (cons arg (allocate-local-variable arg)))
		args))

;*---------------------------------------------------------------------*/
;*    allocate-local-variable ...                                      */
;*---------------------------------------------------------------------*/
(define (allocate-local-variable arg)
   (let ((local (make-local)))
      (if (not (symbol? arg))
	  (error "allocate-local-variable" "Illegal variable name" arg))
      (local-name-set! local arg)
      (local-key-set!  local (get-new-key))
      (local-type-set! local *bobj*)
      local))
		       
;*---------------------------------------------------------------------*/
;*    allocate-local-functions ...                                     */
;*---------------------------------------------------------------------*/
(define (allocate-local-functions args)
   (map (lambda (arg)
	   (let ((local (make-local)))
	      (if (not (symbol? arg))
		  (error "allocate-local-functions"
			 "Illegal variable name"
			 arg))
	      (local-name-set!   local arg)
	      (local-key-set!    local (get-new-key))
	      (local-class-set!  local 'function)
	      (local-value-set!  local (make-function))
	      (local-type-set!   local *bobj*)
	      (function-invocations-set! (local-value local) 0)
	      (function-escape?-set!     (local-value local) #f)
	      (function-type-res-set!    (local-value local) *bobj*)
	      (cons arg local)))
	args))

;*---------------------------------------------------------------------*/
;*    allocate-local-return ...                                        */
;*---------------------------------------------------------------------*/
(define (allocate-local-return arg)
   (let ((local (make-local)))
      (if (not (symbol? arg))
	  (error "allocate-local-functions"
		 "Illegal variable name"
		 arg))
      (local-name-set!   local arg)
      (local-key-set!    local (get-new-key))
      (local-class-set!  local 'return)
      (local-value-set!  local (make-return))
      (local-type-set!   local *bobj*)
      (return-escape?-set! (local-value local) #f)
      local))

;*---------------------------------------------------------------------*/
;*    *re-lookup-value*                                                */
;*---------------------------------------------------------------------*/
(define *re-lookup-value* #f)

;*---------------------------------------------------------------------*/
;*    lookup? ...                                                      */
;*---------------------------------------------------------------------*/
(define (lookup? name lexical-env)
   (let ((cell (assq name lexical-env)))
      (if (pair? cell)
	  (begin
	     (set! *re-lookup-value* (cdr cell))
	     #t)
	  (begin
	     (set! *re-lookup-value* #f)
	     #f))))

;*---------------------------------------------------------------------*/
;*    re-lookup-value ...                                              */
;*---------------------------------------------------------------------*/
(define (re-lookup-value)
   *re-lookup-value*)

;*---------------------------------------------------------------------*/
;*    copy-local-variable ...                                          */
;*---------------------------------------------------------------------*/
(define (copy-local-variable old)
   (let ((new (make-local)))
      (local-name-set!   new (local-name old))
      (local-key-set!    new (get-new-key))
      (local-class-set!  new (local-class old))
      (local-value-set!  new (local-value old))
      (local-access-set! new (local-access old))
      (local-type-set!   new *bobj*)
      new))
	      
