;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.7/Lift/labels.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 31 13:33:46 1993                          */
;*    Last change :  Wed Aug 31 16:13:55 1994 (serrano)                */
;*                                                                     */
;*    On lift les formes `(labels ...)'                                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_labels
   (include "Var/variable.sch"
	    "Lift/lift.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    engine_param
	    heap_abstract
	    lift_closure
	    lift_expression
	    lift_interface)
   (export (lift-labels exp fun)))

;*---------------------------------------------------------------------*/
;*    lift-labels ...                                                  */
;*    -------------------------------------------------------------    */
;*    Il y a quates sortes de fonctions locales:                       */
;*       1/   { Fi } = { Fi | E( Fi ) }                                */
;*       2/   { Fr } = { Fr | G( Fr ) ^ not( E( Fr ) ) }               */
;*       3/   { Fj } = { Fj | not( G( Fj ) ) ^ not( out( Fj ) ) }      */
;*       4/   { Fo } = { Fo | not( G( Fj ) ) ^ out( Fj ) }             */
;*    On commence donc par calculer ces ensembles.                     */
;*---------------------------------------------------------------------*/
(define (lift-labels exp fun)
   (trace (lift loop) "lift-labels: " (shape exp) #\Newline)
   (set-car! (cddr exp) (lift-expression (caddr exp) fun))
   (let loop ((defs (cadr exp))
	      (Fi   '())
	      (Fj   '()))
      (if (null? defs)
	  (cond
	     ((null? Fi)
	      (if (null? Fj)
		  (caddr exp)
		  (begin
		     (set-car! (cdr exp) (lift-declarations Fj fun))
		     (trace (lift loop) "fin de lift-declaration"
			    #\Newline)
		     exp)))
	     ((null? Fj)
	      (E-let Fi (caddr exp)))
	     (else
	      (set-car! (cdr exp) (lift-declarations Fj fun))
	      (E-let Fi exp)))
	  (let* ((pr    (car defs))
		 (local (car pr)))
	     (cond
		((function-escape? (local-value local))
		 ;; 1/
		 (loop (cdr defs) (cons pr Fi) Fj))
		((lift-G? (local-info local))
		 ;; 2/
		 (loop (cdr defs) Fi Fj))
		((or (null? (lift-integrator (local-info local)))
		     (eq? (lift-integrator (local-info local)) fun))
		 ;; 3/
		 (loop (cdr defs) Fi (cons pr Fj)))
		(else
		 ;; 4/
		 (loop (cdr defs) Fi Fj)))))))

;*---------------------------------------------------------------------*/
;*    lift-declarations ...                                            */
;*---------------------------------------------------------------------*/
(define (lift-declarations Fj fun)
   (trace (lift loop) "lift-declaration: " (shape (map car Fj))
	  #\Newline)
   (let loop ((F Fj))
      (trace (lift loop) "lift-declaration (loop): " (shape (map car F))
	     #\Newline)
      (if (null? F)
	  Fj
	  (let ((pr (car F)))
	     (set-car! (cddr pr) (lift-expression (caddr pr) fun))
	     (function-body-set! (local-value (car pr)) (caddr pr))
	     (let liip ((formals (cadr pr))
			(hook    (cddr pr)))
		(if (null? formals)
		    (let ((old (cddr pr)))
		      (set-cdr! (cdr pr)
				(cons (cons 'begin old) '()))
		      'ok)
		    (let ((pr (car formals)))
		       (if (and (eq? (local-access pr) 'write)
				(or  (lift-kaptured? (local-info pr))
				     *call/cc?*))
			   (begin
			      (set-cdr! hook (cons (car hook) (cdr hook)))
			      (add-celled! pr)
			      (set-car! hook `(set! ,pr
						    ,(abstract-make-cell pr)))
			      (liip (cdr formals) hook))
			   (liip (cdr formals) hook)))))
	     (loop (cdr F))))))

;*---------------------------------------------------------------------*/
;*    E-let ...                                                        */
;*---------------------------------------------------------------------*/
(define (E-let Fi exp)
   (trace (lift loop) "E-let: " (shape Fi) #\Newline)
   (let ((Fdeclared (map (lambda (f) (the-closure (car f))) Fi)))
      (let loop ((Fi    Fi)
		 (decls '())
		 (sets  '()))
	 (if (null? Fi)
	     `(let ,decls ,(if (null? sets)
			       exp
			       `(begin ,@sets ,exp)))
	     (let ((local (car (car Fi))))
		(if (not (eq? (lift-0cfa-strength (local-info local))
			      'strong))
		    (loop (cdr FI)
			  (cons (make-0cfa-strength-decls local Fdeclared)
				decls)
			  (append (make-0cfa-strength-sets local) sets))
		    (loop (cdr Fi)
			  (cons (make-decls local) decls)
			  (append (make-sets local) sets))))))))

;*---------------------------------------------------------------------*/
;*    make-decls ...                                                   */
;*---------------------------------------------------------------------*/
(define (make-decls local)
   (list (the-closure local)
	 (if (<fx (function-arity (local-value local)) 0)
	     (abstract-make-va-procedure
	      local
	      (function-arity (local-value local))
	      (length (lift-kaptured (local-info local))))
	     (abstract-make-fx-procedure
	      local
	      (function-arity (local-value local))
	      (length (lift-kaptured
		       (local-info local)))))))

;*---------------------------------------------------------------------*/
;*    make-0cfa-strength-decls ...                                     */
;*---------------------------------------------------------------------*/
(define (make-0cfa-strength-decls local Fdeclared)
   (if (eq? (lift-0cfa-strength (local-info local)) 'extra-light)
       (make-0cfa-strength-extra-light-decls local Fdeclared)
       (make-0cfa-strength-light-decls local)))

;*---------------------------------------------------------------------*/
;*    make-0cfa-strength-extra-light-decls ...                         */
;*---------------------------------------------------------------------*/
(define (make-0cfa-strength-extra-light-decls local Fdeclared)
   (let ((kaptured (lift-kaptured (local-info local))))
      (list (the-closure local)
	    (cond
	       ((null? kaptured)
		(abstract-unspecified))
	       ((null? (cdr kaptured))
		(trace (lift loop)
		       "Change-je : " (shape (car kaptured)) #\Newline
		       "  declared: " (shape Fdeclared)
		       #\Newline)
		(let ((res
		(let loop ((k (car kaptured)))
		   (if (or (not (local? k))
			   (not (memq k Fdeclared))
			   (null? (lift-closure-of (local-info k))))
		       k
		       (let ((clo (lift-closure-of (local-info k))))
			  (if (or (not (eq? (lift-0cfa-strength
					     (local-info clo))
					    'extra-light))
				  (null? (lift-kaptured (local-info clo)))
				  (not (null? (cdr (lift-kaptured (local-info
								   clo))))))
			      k
			      (loop
			       (car (lift-kaptured (local-info clo)))))))))
		      )
		   (trace (lift loop)
			  "Je change: " (shape (car kaptured))
			  "   en  " (shape res) #\Newline
			  "Fdeclared: " (shape Fdeclared)
			  #\Newline)
		   res))
	       (else
		(abstract-make-extra-light-procedure (length kaptured)))))))

;*---------------------------------------------------------------------*/
;*    make-0cfa-strength-light-decls ...                               */
;*---------------------------------------------------------------------*/
(define (make-0cfa-strength-light-decls local)
   (let ((kaptured (lift-kaptured (local-info local))))
      (list (the-closure local)
	    (abstract-make-light-procedure
	     local
	     (length (lift-kaptured (local-info local)))))))

;*---------------------------------------------------------------------*/
;*    make-sets ...                                                    */
;*---------------------------------------------------------------------*/
(define (make-sets local)
   (let ((closure (the-closure local)))
      (let loop ((var (lift-kaptured (local-info local)))
		 (i   0)
		 (acc '()))
	 (if (null? var)
	     acc
	     (loop (cdr var)
		   (+fx i 1)
		   (cons (abstract-procedure-env-set! closure i (car var))
			 acc))))))

;*---------------------------------------------------------------------*/
;*    make-0cfa-strength-sets ...                                      */
;*---------------------------------------------------------------------*/
(define (make-0cfa-strength-sets local)
   (if (and (eq? (lift-0cfa-strength (local-info local)) 'extra-light)
	    (=fx (length (lift-kaptured (local-info local))) 1))
       '()
       (let ((env-set! (if (eq? (lift-0cfa-strength (local-info local))
				'extra-light)
			   abstract-procedure-extra-light-env-set!
			   abstract-procedure-light-env-set!)))
	  (let ((closure (the-closure local)))
	     (let loop ((var (lift-kaptured (local-info local)))
			(i   0)
			(acc '()))
		(if (null? var)
		    acc
		    (loop (cdr var)
			  (+fx i 1)
			  (cons (env-set! closure i (car var))
				acc))))))))




