;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Lift/block.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 31 13:24:43 1993                          */
;*    Last change :  Tue Apr 27 13:12:14 1993  (serrano)               */
;*                                                                     */
;*    On lift les expressions `(block ...)'                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_block
   (include "Var/variable.sch"
	    "Lift/lift.sch")
   (import  lift_expression
	    lift_closure)
   (export  (lift-block exp fun)
	    (lift-return-from exp fun)))

;*---------------------------------------------------------------------*/
;*    lift-block ...                                                   */
;*---------------------------------------------------------------------*/
(define (lift-block exp fun)
   (if (lift-G? (local-info (cadr exp)))
       `(,(cadr exp) ,@(lift-kaptured (local-info (cadr exp))))
       (begin
	  (set-car! (cddr exp) (lift-expression (caddr exp) fun))
	  exp)))

;*---------------------------------------------------------------------*/
;*    lift-return-from ...                                             */
;*---------------------------------------------------------------------*/
(define (lift-return-from exp fun)
   (set-car! (cddr exp) (lift-expression (caddr exp) fun))
   (if (lift-G? (local-info (cadr exp)))
       (begin
	  (set-car! (cdr exp) (the-continue (cadr exp)))
	  (set-car! exp 'continue)))
   exp)
