;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Lift/alpha.scm ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jul  4 10:47:53 1994                          */
;*    Last change :  Mon Jul 11 14:34:35 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Une alpha conversion specifique pour la passe Lift.              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_alpha
   (include "Var/variable.sch"
	    "Lift/lift.sch"
	    "Tools/trace.sch")
   (import  scan_lexical
	    lift_closure
	    tools_shape)
   (export  (lift-alphatize! exp old-vars new-vars)))

;*---------------------------------------------------------------------*/
;*    prepare-variables! ...                                           */
;*    -------------------------------------------------------------    */
;*    On prepare les variables qui vont etre alpha-converties.         */
;*---------------------------------------------------------------------*/
(define (prepare-variables! old-vars new-vars stamp)
   (for-each (lambda (old-local new-local)
		(lift-alpha-stamp-set! (local-info old-local) stamp)
		(lift-alpha-set! (local-info old-local) new-local))
	     old-vars
	     new-vars))

;*---------------------------------------------------------------------*/
;*    lift-alphatize! ...                                              */
;*    -------------------------------------------------------------    */
;*    Attention, cette passe de fait d'alpha-conversion ni sur         */
;*    les parametres formels des fonctions locales (labels) ni sur les */
;*    liaisons locales introduites par des `let'.                      */
;*---------------------------------------------------------------------*/
(define (lift-alphatize! exp old-vars new-vars)
   (let ((stamp (gensym)))
      ;; on commence par preparer les variables locales.
      (prepare-variables! old-vars new-vars stamp)
      ;; on boucle sur le corps pour faire l'alpha-conversion.
      (let loop ((exp exp))
	 (trace (lift loop) "lift: " (shape exp)
		#\Newline)
	 (match-case exp
;*--- nil -------------------------------------------------------------*/
	    (()
	     exp)
;*--- atom ------------------------------------------------------------*/
	    ((atom ?-)
	     (if (and (local? exp)
		      (lift? (local-info exp))
		      (eq? (lift-alpha-stamp (local-info exp)) stamp)
		      (local? (lift-alpha (local-info exp))))
		 (lift-alpha (local-info exp))
		 exp))
;*--- set! ------------------------------------------------------------*/
	     ((set! . ?-)
	      (set-car! (cdr exp) (loop (cadr exp)))
	      (set-car! (cddr exp) (loop (caddr exp)))
	      exp)
;*--- function --------------------------------------------------------*/
	     (((or function function-extra-light function-light) ?var)
	      (loop (the-closure var)))
;*--- quote -----------------------------------------------------------*/
	     ((quote ?-)
	      exp)
;*--- pragma ----------------------------------------------------------*/
	     ((pragma ?-)
	      exp)
;*--- cast ------------------------------------------------------------*/
	     ((cast ?- ?rest)
	      (set-car! (cddr exp) (loop rest))
	      exp)
;*--- failure ---------------------------------------------------------*/
	     ((failure . ?-)
	      (set-car! (cdr exp) (loop (cadr exp)))
	      (set-car! (cddr exp) (loop (caddr exp)))
	      (set-car! (cdddr exp) (loop (cadddr exp)))
	      exp)
;*--- cif -------------------------------------------------------------*/
	     ((cif . ?-)
	      (set-car! (cdr exp) (loop (cadr exp)))
	      (set-car! (cddr exp) (loop (caddr exp)))
	      (set-car! (cdddr exp) (loop (cadddr exp)))
	      exp)
;*--- typed-case ------------------------------------------------------*/
	     ((typed-case ?- ?test . ?clauses)
	      (set-car! (cddr exp) (loop test))
	      (let liip ((hook clauses))
		 (if (null? hook)
		     exp
		     (begin
			(set-car! (cdar hook) (loop (cadr (car hook))))
			(liip (cdr hook))))))
;*--- begin -----------------------------------------------------------*/
	     ((begin . ?body)
	      (let liip ((hook body))
		 (if (null? hook)
		     exp
		     (begin
			(set-car! hook (loop (car hook)))
			(liip (cdr hook))))))
;*--- let -------------------------------------------------------------*/
	     ((let . ?-)
	      ;; on lift le body
	      (set-car! (cddr exp) (loop (caddr exp)))
	      ;; on alphatize les bindings
	      (let liip ((bindings (cadr exp)))
		 (if (null? bindings)
		     exp
		     (let ((binding (car bindings)))
			(set-car! (cdr binding) (loop (cadr binding)))
			(liip (cdr bindings))))))
;*--- labels ----------------------------------------------------------*/
	     ((labels . ?-)
	      ;; on alphatize le body
	      (set-car! (cddr exp) (loop (caddr exp)))
	      (for-each (lambda (binding)
			   (set-car! (cddr binding)
				     (loop (caddr binding))))
			(cadr exp))
	      exp)
;*--- block -----------------------------------------------------------*/
	     ((block . ?-)
	      (set-car! (cddr exp) (loop (caddr exp)))
	      exp)
;*--- return-from -----------------------------------------------------*/
	     ((return-from . ?-)
	      (set-car! (cddr exp) (loop (caddr exp)))
	      exp)
;*--- apply -----------------------------------------------------------*/
	     (((or apply funcall funcall-medium funcall-light). ?-)
	      (let liip ((hook (cdr exp)))
		 (if (null? hook)
		     exp
		     (begin
			(set-car! hook (loop (car hook)))
			(liip (cdr hook))))))
;*--- funcall-extra-light ---------------------------------------------*/
	     (((funcall-extra-light . ?var) . ?-)
	      (set-cdr! (car exp) (loop var))
	      (let liip ((hook (cdr exp)))
		 (if (null? hook)
		     exp
		     (begin
			(set-car! hook (loop (car hook)))
			(liip (cdr hook))))))
;*--- application -----------------------------------------------------*/
	     (else
	      ;; on lift les arguments
	      (let liip ((hook exp))
		 (if (null? hook)
		     exp
		     (begin
			(set-car! hook (loop (car hook)))
			(liip (cdr hook)))))))))))
