;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.7/Expand/let.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun 19 08:29:58 1992                          */
;*    Last change :  Fri Dec 30 08:20:40 1994 (serrano)                */
;*                                                                     */
;*    L'expansion des differents `let's                                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_let
   (import  tools_progn
	    tools_args
	    tools_error
	    expand_lambda
	    expand_eps)
   (export  (expand-let*   x e)
	    (expand-let    x e)
	    (expand-letrec x e)
	    (expand-labels x e)))

;*---------------------------------------------------------------------*/
;*    expand-let* ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-let* x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      (e `(let () ,(normalize-progn body)) e))
		     ((?- ?bindings . (and ?body (not ())))
		      (e `(let (,(car bindings))
			     (let* ,(cdr bindings)
				,(normalize-progn body))) e))
		     (else
		      (error "let*" "Illegal `let*' form" x)))))
	 (set! internal-definition? old-internal)
	 res)))

;*---------------------------------------------------------------------*/
;*    expand-let ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-let x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      (e (normalize-progn body) e))
		     ((?- (and (? symbol?) ?loop)
			  ?bindings . (and ?body (not ())))
		      (if (not (or (null? bindings)
				   (pair? bindings)))
			  (error "let" "Illegal `let' form" x)
			  (e `(labels ((,loop ,(map
						(lambda (b)
						   (if (pair? b)
						       (car b)
						       (error
							"expand-let"
							"Illegal `let' form"
							x)))
						    bindings)
					      ,(normalize-progn body)))
				 (,loop ,@(map (lambda (b)
						  (normalize-progn (cdr b)))
					       bindings)))
			     e)))
		     ((?- (and (? pair?) ?bindings) . (and ?body (not ())))
		      (with-lexical
		       (map (lambda (v) (if (pair? v) (car v) v)) bindings)
		       (lambda ()
			  `(let ,(let loop ((bindings bindings)
					    (acc      '()))
				    (if (null? bindings)
					acc
					(let ((pr (car bindings)))
					   (if (not (pair? pr))
					       (loop (cdr bindings)
						     (cons (list
							    pr
							    '(unspecified))
							   acc))
					       (loop (cdr bindings)
						     (cons (list
							    (car pr)
							    (e (normalize-progn
								(cdr pr)) e))
							   acc))))))
			      ,(e (normalize-progn body) e)))))
		     (else
		      (error "let" "Illegal `let' form" x)))))
	 (set! internal-definition? old-internal)
	 res)))

;*---------------------------------------------------------------------*/
;*    expand-letrec ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-letrec x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      (e `(let () ,(normalize-progn body)) e))
		     ((?- (and (? pair?) ?bindings) . (and ?body (not ())))
		      (with-lexical
		       (map (lambda (v) (if (pair? v) (car v) v)) bindings)
		       (lambda ()
			  `(letrec ,(let loop ((bindings bindings)
					       (acc      '()))
				       (if (null? bindings)
					   acc
					   (let ((pr (car bindings)))
					      (if (not (pair? pr))
						  (error
						   "letrec"
						   "Illegal `letrec' form"
						   x)
						  (loop
						   (cdr bindings)
						   (cons (list
							  (car pr)
							  (e (normalize-progn
							      (cdr pr)) e))
							 acc))))))
			      ,(e (normalize-progn body) e)))))
		     (else
		      (error "letrec" "Illegal `letrec' form" x)))))
	 (set! internal-definition? old-internal)
	 res)))
	 
;*---------------------------------------------------------------------*/
;*      expand-labels ...                                              */
;*---------------------------------------------------------------------*/
(define (expand-labels x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      (e `(let () ,(normalize-progn body)) e))
		     ((?- ?bindings . (and ?body (not ())))
		      (with-lexical
		       (map car bindings)
		       (lambda ()
			  (let ((new
				 (let loop ((bindings bindings))
				    (cond
				       ((null? bindings)
					'())
				       ((not (pair? bindings))
					(error "labels"
						       "Illegal `labels' form"
						       x))
				       (else
					(match-case (car bindings)
					   ((?name ?args . ?lbody)
					    (with-lexical
					     (args*->args-list args)
					     (lambda ()
						(cons
						 `(,name
						   ,args
						   ,(e (normalize-progn lbody)
						       e))
						 (loop (cdr bindings))))))
					   (else
					    (error
					     "labels"
					     "Illegal `labels' form"
					     x))))))))
			     `(labels ,new ,(e (normalize-progn body) e))))))
		     (else
		      (error "labels" "Illegal `labels' form" x)))))
	 (set! internal-definition? old-internal)
	 res)))
