;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Expand/if.scm ...        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec  3 09:26:51 1994                          */
;*    Last change :  Mon Dec  5 16:37:08 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La macro-expansion des `if'.                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_if
   (include "Tools/trace.sch")
   (import  tools_progn
	    tools_shape)
   (export  (expand-if <expression> <expander>)))

;*---------------------------------------------------------------------*/
;*    expand-test ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-test x e)
   (if *nil*
       (e x e)
       (let ((aux (gensym)))
	  `(let ((,aux ,(e x e)))
	      (if ,aux
		  (if (null? aux)
		      #f
		      #t)
		  #f)))))

;*---------------------------------------------------------------------*/
;*    expand-if ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-if x e)
   (match-case x
      ((?- ?test ?alors ?sinon)
       (let ((exp `(if ,(expand-if-with expand-test test e #t)
		       ,(expand-if-with e alors e #t)
		       ,(expand-if-with e sinon e #f))))
	  (if *case-enabled?*
	      (let ((new-exp (find-case-exp exp)))
		 (if new-exp
		     (let ((new-new-exp (e (if->case! new-exp) e)))
			(set-car! (car new-exp) (car new-new-exp))
			(set-cdr! (car new-exp) (cdr new-new-exp))
			exp)
		     exp))
	      exp)))
      ((?- ?test ?alors)
       `(if ,(expand-if-with expand-test test e #t)
	    ,(expand-if-with e alors e #t)
	    #f))
      (else
       (error "if" "Illegal `if' form" x))))

;*---------------------------------------------------------------------*/
;*    *case-enable?* ...                                               */
;*---------------------------------------------------------------------*/
(define *case-enabled?* #t)

;*---------------------------------------------------------------------*/
;*    expand-if-with ...                                               */
;*---------------------------------------------------------------------*/
(define (expand-if-with e1 x e2 case?)
   (let ((case-enabled? *case-enabled?*))
      (set! *case-enabled?* case?)
      (let ((res (e1 x e2)))
	 (set! *case-enabled?* case-enabled?)
	 res)))

;*---------------------------------------------------------------------*/
;*    find-case-exp ...                                                */
;*    -------------------------------------------------------------    */
;*    On recherche un case possible dans une cascade de if. On         */
;*    descend recursivement dans les branches `sinon' jusqu'a          */
;*    qu'on en trouve une.                                             */
;*---------------------------------------------------------------------*/
(define (find-case-exp exp)
   (trace eps "is-case?: " exp " --> " (is-case? exp) #\Newline)
   (let ((is-case (is-case? exp)))
      (if is-case
	  is-case
	  (match-case exp
	     ((if ?- ?- ?sinon)
	      (find-case-exp sinon))
	     (else
	      #f)))))
   
;*---------------------------------------------------------------------*/
;*    is-case? ...                                                     */
;*    -------------------------------------------------------------    */
;*    Est-ce qu'une cascade de `if' peut-etre compile comme un         */
;*    case ?.                                                          */
;*    -------------------------------------------------------------    */
;*    Il faut pour cela que tous les tests soient de la forme          */
;*    `(eq? x k)' ou `(eq? k x)' ou `(memq x k-list)' ou encore        */
;*    `(=fx x k)' et que k soit :                                      */
;*       . un entier                                                   */
;*       . un caracter                                                 */
;*       . une constante.                                              */
;*---------------------------------------------------------------------*/
(define (is-case? exp)
   (let loop ((var        '())
	      (exp'       exp)
	      (nb-clauses 1))
      (match-case exp'
	 ((if ?test ?- ?sinon)
	  (match-case test
	     (((or eq? =fx) ?exp1 ?exp2)
	      (cond
		 ((is-a-valid-constant? exp1)
		  (cond
		     ((null? var)
		      (loop exp2 sinon (+fx nb-clauses 1)))
		     ((eq? var exp2)
		      (loop exp2 sinon (+fx nb-clauses 1)))
		     (else
		      (if (>fx nb-clauses 3)
			  (list exp var exp')
			  #f))))
		 ((is-a-valid-constant? exp2)
		  (cond
		     ((null? var)
		      (loop exp1 sinon (+fx nb-clauses 1)))
		     ((eq? var exp1)
		      (loop exp1 sinon (+fx nb-clauses 1)))
		     (else
		      (if (>fx nb-clauses 3)
			  (list exp var exp')
			  #f))))
		 (else
		  #f)))
	     ((memq ?new-var ((kwote quote) ?exp1))
	      (cond
		 ((and (pair? exp1)
		       (let loop ((exp1 exp1))
			  (cond
			     ((null? exp1)
			      #t)
			     ((is-a-valid-constant? (car exp1))
			      (loop (cdr exp1)))
			     (else
			      #f))))
		  (cond
		     ((null? var)
		      (loop new-var sinon (+fx nb-clauses 1)))
		     ((eq? new-var var)
		      (loop new-var sinon (+fx nb-clauses 1)))
		     (else
		      (if (>fx nb-clauses 3)
			  (list exp var exp')
			  #f))))
		 (else
		  (if (>fx nb-clauses 3)
		      (list exp var exp')
		      #f))))))
	 (else
	  (if (>fx nb-clauses 3)
	      (list exp var exp')
	      #f)))))

;*---------------------------------------------------------------------*/
;*    is-a-valid-constant? ...                                         */
;*    -------------------------------------------------------------    */
;*    Est-ce une constante qu'on peut mettre dans un `case' ?          */
;*---------------------------------------------------------------------*/
(define (is-a-valid-constant? cnst)
   (or (integer? cnst)
       (char? cnst)
       (cnst? cnst)))

;*---------------------------------------------------------------------*/
;*    if->case! ...                                                    */
;*    -------------------------------------------------------------    */
;*    L'argument recu est une liste a trois elements. Le premier       */
;*    est l'expression a reecrire. Le second est la variable testee.   */
;*    La troisieme est l'expression a mettre dans le `else'.           */
;*---------------------------------------------------------------------*/
(define (if->case! exp.var.end)
   (trace eps "if->case: " exp.var.end #\Newline)
   (let* ((exp     (car exp.var.end))
	  (var     (cadr exp.var.end))
	  (end-exp (caddr exp.var.end))
	  (new-exp `(case ,var
		       ,@(let loop ((exp     exp)
				    (clauses '()))
			    (trace eps "   loop(if->case): " exp #\Newline
				   "          end-exp: " end-exp #\Newline
				   "          clauses: " clauses #\Newline)
			    (if (eq? exp end-exp)
				(reverse! (cons `(else ,end-exp) clauses))
				(match-case exp
				   ((if ?test ?alors ?sinon)
				    (loop sinon
					  (cons (make-clause var test alors)
						clauses)))))))))
      (trace eps "if->case: new-exp" new-exp #\Newline)
      (set-car! exp (car new-exp))
      (set-cdr! exp (cdr new-exp))
      (trace eps "new-exp: " exp #\Newline)
      exp))

;*---------------------------------------------------------------------*/
;*    make-clause ...                                                  */
;*---------------------------------------------------------------------*/
(define (make-clause var test alors)
   (match-case test
      (((or eq? =fx) ?exp1 ?exp2)
       (if (eq? exp1 var)
	   `((,exp2) ,alors)
	   `((,exp1) ,alors)))
      ((memq ?- ((kwote quote) ?exp))
       `(,exp ,alors))))
		 

	      
	  
