;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../expander.scm ...                                             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 19 08:59:27 1993                          */
;*    Last change :  Thu Nov  3 11:44:46 1994 (serrano)                */
;*                                                                     */
;*    La (petite) manipulation des expander                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_expander
   (include "Expand/expander.sch")
   (import  var_env
	    tools_shape)
   (export  (install-O-comptime-expander keyword function)
	    (expander-create             name)
	    (expander-pp                 port expander)))

;*---------------------------------------------------------------------*/
;*    install-O-comptime-expander ...                                  */
;*    -------------------------------------------------------------    */
;*    Les O-expanders sont des expanseurs d'optimisation. La difference*/
;*    avec les expanseurs normaux est que si une fonction portent le   */
;*    meme nom qu'eux, il sont retires de l'environment.               */
;*---------------------------------------------------------------------*/
(define (install-O-comptime-expander keyword function)
   (declare-expander! keyword function *Oenv*))

;*---------------------------------------------------------------------*/
;*    declare-expander! ...                                            */
;*---------------------------------------------------------------------*/
(define (declare-expander! keyword expander Genv)
   (let ((new (bind-in-global-environment! keyword Genv)))
      (expander-expander-set! new expander)))
   
;*---------------------------------------------------------------------*/
;*    expander-create ...                                              */
;*---------------------------------------------------------------------*/
(define (expander-create name)
   (let ((new (make-expander)))
      (expander-name-set! new name)
      new))

;*---------------------------------------------------------------------*/
;*    expander-pp  ...                                                 */
;*---------------------------------------------------------------------*/
(define (expander-pp port expander)
   (if (not (expander? expander))
       (error "expander-pp" "Not an expander" (shape expander))
       (begin
	  (fprint port (expander-name expander) ":")
	  (fprint port (make-string (string-length
				     (symbol->string (expander-name expander)))
				    #\-))
	  (fprint port "   expander: " (shape (expander-expander expander))))))
	  


