;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.7/Expand/eps.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 17 17:05:31 1992                          */
;*    Last change :  Thu Nov 24 08:14:17 1994 (serrano)                */
;*                                                                     */
;*    L'expansion des macros. Ce code est tres largement inspire de    */
;*    << Expansion-Passing Style: Beyond Conventional Macro >>,        */
;*    Dybvig, Friedman & Haynes  -- ACM 1986 (LFP) page 143            */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_eps
   (include "Var/variable.sch"
	    "Expand/expander.sch"
	    "Tools/trace.sch")
   (import  var_env
	    tools_hash
	    tools_speek
	    tools_error
	    tools_progn
	    expand_expander)
   (export  (with-lexical                new thunk)
	    (add-macro!                  form)
	    (comptime-expand             x)
	    (comptime-expand-once        x)
	    (expand-code                 l)))

;*---------------------------------------------------------------------*/
;*    La liste des macros que l'utilisateur s'est definie              */
;*---------------------------------------------------------------------*/
(define *macro* '())

;*---------------------------------------------------------------------*/
;*    add-macro! ...                                                   */
;*---------------------------------------------------------------------*/
(define (add-macro! form)
   (set! *macro* (cons form *macro*)))

;*---------------------------------------------------------------------*/
;*    *lexical-stack                                                   */
;*    -------------------------------------------------------------    */
;*    Cette variable global nous sert a simuler une pile pour savoir   */
;*    quand une variable locale `sur-definie' une `O-macro'. C'est     */
;*    moins jolie qu'un argument supplementaire a `expand' mais        */
;*    c'est moins penible !                                            */
;*---------------------------------------------------------------------*/
(define *lexical-stack* '())

;*---------------------------------------------------------------------*/
;*    with-lexical ...                                                 */
;*---------------------------------------------------------------------*/
(define (with-lexical new thunk)
   (let ((old-lexical-stack *lexical-stack*))
      (set! *lexical-stack* (append new *lexical-stack*))
      (let ((res (thunk)))
	 (set! *lexical-stack* old-lexical-stack)
	 res)))
    
;*---------------------------------------------------------------------*/
;*    expand-code ...                                                  */
;*    -------------------------------------------------------------    */
;*    Non seulement on expand tout le code local mais on est egalement */
;*    oblige de faire l'expansion des inlines qu'on a recupere.        */
;*---------------------------------------------------------------------*/
(define (expand-code schemes)
   (verbose "   . Expand" #\Newline)
   ;; les macros de l'utilisateur
   (for-each comptime-expand (reverse! *macro*))
   ;; les erreurs locales
   (start-partial-error "Expand")
   ;; les inlines importees qui ne sont pas definie dans le tas doivent
   ;; etre expansee. Ce n'est pas la peine de le faire pour les fonctions
   ;; librairie car l'expansion leur a deja ete applique.
   (define handler (lambda (escape proc mes obj)
		      (partial-error proc mes obj)
		      '()))
   (walk-on-hash-table!
    (lambda (bucket)
       (let loop ((bucket bucket))
	  (if (null? bucket)
	      'done
	      (let ((var (car bucket)))
		 (if (and (eq? (global-class var) 'function)
			  (eq? (global-import var) 'import)
			  (null? (global-library? var))
			  (boolean? (function-inline? (global-value var)))
			  (function-inline? (global-value var)))
		     (begin
			(enter-function (global-name var)) 
			(trace eps "J'expanse le code de: " (global-name var)
			       " " (function-body (global-value var))
			       #\Newline)
			(let ((new-body (try
					 (force-progn
					  (comptime-expand
					   (function-body
					    (global-value var))))
					 handler)))
			   (function-body-set! (global-value var) new-body))
			(trace eps " ==> " (function-body (global-value var))
			       #\Newline)
			(leave-function)))
		 (loop (cdr bucket))))))
    *Genv*
    'Genv)
   ;; le code local
   (let ((res (let loop ((schemes schemes)
			 (res     '()))
		 (if (null? schemes)
		     res
		     (match-case (car schemes)
			((define-macro . ?-)
			 (try (comptime-expand (car schemes)) handler)
			 (loop (cdr schemes)
			       res))
			((define-expander . ?-)
			 (try (comptime-expand (car schemes)) handler)
			 (loop (cdr schemes)
			       res))
			(else
			 (let ((new-body (try (comptime-expand (car schemes))
					      handler)))
			    (loop (cdr schemes)
				  (cons new-body
					res)))))))))
      (fail-if-partial-error)
      (reverse! res)))
      
;*---------------------------------------------------------------------*/
;*    comptime-expand ...                                              */
;*---------------------------------------------------------------------*/
(define (comptime-expand x)
   (initial-expander x initial-expander))

;*---------------------------------------------------------------------*/
;*    initial-expander ...                                             */
;*---------------------------------------------------------------------*/
(define (initial-expander x e)
   (trace eps "initial-expander: " x #\Newline)
   (let ((e1 (cond
		((symbol? x)
		 *identifier-expander*)
		((null? x)
		 (error "()" "Illegal form" '()))
		((not (pair? x))
		 (lambda (x e) x))
		((symbol? (car x))
		 (let (b)
		    (cond
		       ((begin
			   (set! b (get-compiler-expander (car x)))
			   b)
			b)
		       ((begin
			   (set! b (get-eval-expander (car x)))
			   b)
			b)
		       ((memq (car x) *lexical-stack*)
			 *application-expander*)
		       ((begin
			   (set! b (find-in-global-environment (car x)
							       *Oenv*))
			   b)
			(expander-expander b))
		       (else
			*application-expander*))))
		(else
		 *application-expander*))))
      (e1 x e)))

;*---------------------------------------------------------------------*/
;*    (comptime-expand-once ...                                        */
;*---------------------------------------------------------------------*/
(define (comptime-expand-once x)
   (initial-expander x (lambda (x e) x)))

;*---------------------------------------------------------------------*/
;*    *identifier-expander* ...                                        */
;*---------------------------------------------------------------------*/
(define (*identifier-expander* x e)
   x)

;*---------------------------------------------------------------------*/
;*    *application-expander* ...                                       */
;*---------------------------------------------------------------------*/
(define (*application-expander* x e)
   (let loop ((x* x))
      (cond
	 ((pair? x*)
	  (cons (e (car x*) e) (loop (cdr x*))))
	 ((null? x*)
	  '())
	 (else
	  (error "application" "Illegal form" x)))))
