;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.3/Effect/walk.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 25 16:26:07 1993                          */
;*    Last change :  Wed Jul  7 17:14:43 1993  (serrano)               */
;*                                                                     */
;*    On part a la recherche des effets de bords et mutations.         */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module effect_walk
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    effect_cgraph
	    effect_fix)
   (export  (effect-walk tree)))

;*---------------------------------------------------------------------*/
;*    effect-walk ...                                                  */
;*---------------------------------------------------------------------*/
(define (effect-walk tree)
   (verbose "   . Effect" #\Newline)
   (start-partial-error "Effect")
   ;; on construit le graph d'appel en calculant les effets de bords
   ;; terminaux
   (let loop ((walk tree)
	      (W    '()))
      (if (null? walk)
	   (begin
	      (iterate-to-fixpoint W)
	      (fail-if-partial-error)
	      tree)
	   (let ((var (car walk)))
	      (enter-function (shape var))
	      (get-info var)
	      (let ((value (cond
			      ((global? var)
			       (global-value var))
			      ((local? var)
			       (error "effect-walk" "Not a global"
				      (shape var)))
			      (else
			       (error "effect-walk"
				      "Not a variable"
				      (shape var))))))
		 (let ((W (call-graph! (function-body value) var W)))
		    (leave-function)
		    (loop (cdr walk) W)))))))

