;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../cgraph.scm ...                                               */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr 30 09:35:07 1993                          */
;*    Last change :  Thu Oct 21 10:05:29 1993 (serrano)                */
;*                                                                     */
;*    Le calcul du graphe d'appel                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module effect_cgraph
   (include "Var/variable.sch"
	    "Effect/temp.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    var_pragma)
   (export  (call-graph! body owner W)
	    (get-info    var)
	    (get-all-functions)))

;*---------------------------------------------------------------------*/
;*    *all-functions*                                                  */
;*    -------------------------------------------------------------    */
;*    La liste des toutes les fonctions manipulees.                    */
;*---------------------------------------------------------------------*/
(define *all-functions* '())

;*---------------------------------------------------------------------*/
;*    get-all-functions ...                                            */
;*---------------------------------------------------------------------*/
(define (get-all-functions)
   *all-functions*)

;*---------------------------------------------------------------------*/
;*    call-graph! ...                                                  */
;*---------------------------------------------------------------------*/
(define (call-graph! exp owner W)
   (trace (loop effect) "call-graph!: " (shape exp) #\Newline)
   (match-case exp
;*--- nil -------------------------------------------------------------*/
      (()
       W)
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       W)
;*--- function --------------------------------------------------------*/
      ((function ?-)
       W)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       W)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       W)
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       (call-hook-graph! (cdr exp) owner W))
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       ;; cas trivial
       (let ((temp (get-info owner)))
	  (if (not (temp-seter temp))
	      (begin
		 (temp-seter-set! temp #t)
		 (call-graph! (caddr exp) owner (cons owner W)))
	      (call-graph! (caddr exp) owner W))))
;*--- cif -------------------------------------------------------------*/
      ((cif . ?-)
       (call-hook-graph! (cdr exp) owner W))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?- ?test . ?clauses)
       (let loop ((G       (call-graph! test owner W))
		  (clauses clauses))
	  (if (null? clauses)
	      G
	      (loop (call-graph! (cadr (car clauses)) owner G)
		    (cdr clauses)))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?-)
       (call-hook-graph! (cdr exp) owner W))
;*--- let -------------------------------------------------------------*/
      ((let . ?-)
       (let loop ((hook (cadr exp))
		  (W   W))
	  (if (null? hook)
	      (call-graph! (caddr exp) owner W)
	      (loop (cdr hook)
		    (call-graph! (cadr (car hook)) owner W)))))
;*--- labels ----------------------------------------------------------*/
      ((labels . ?-)
       ;; on definie les temp de toutes les liaisons
       (for-each (lambda (b) (make-local-temp (car b))) (cadr exp))
       ;; on boucle sur toutes les liaisons
       (let loop ((hook (cadr exp))
		  (W   W))
	  (if (null? hook)
	      (call-graph! (caddr exp) owner W)
	      (begin
		 (loop (cdr hook)
		       (call-graph! (caddr (car hook))
				    (car (car hook))
				    W))))))
;*--- block -----------------------------------------------------------*/
      ((block . ?-)
       (call-graph! (caddr exp) owner W))
;*--- return-from -----------------------------------------------------*/
      ((return-from . ?-)
       (call-graph! (caddr exp) owner W))
;*--- apply & funcall -------------------------------------------------*/
      (((or apply funcall) . ?args)
       ;; un appel etranger signifie effet de bord !
       (let ((temp (get-info owner)))
	  (if (not (temp-seter temp))
	      (begin
		 (temp-seter-set! temp #t)
		 (call-hook-graph! args owner (cons owner W)))
	      (call-hook-graph! args owner W))))
;*--- application -----------------------------------------------------*/
      ((?fun . ?args)
       (call-hook-graph! args owner (save-call! owner fun w)))))

;*---------------------------------------------------------------------*/
;*    call-hook-graph! ...                                             */
;*---------------------------------------------------------------------*/
(define (call-hook-graph! exp owner W)
   (if (null? exp)
       W
       (call-hook-graph! (cdr exp) owner (call-graph! (car exp) owner W))))

;*---------------------------------------------------------------------*/
;*    save-call!                                                       */
;*---------------------------------------------------------------------*/
(define (save-call! owner callee w)
   (trace (loop effect)
	  "save-call!: " (shape owner) " <-> " (shape callee) #\Newline)
   (let ((w (if (global? callee)
		(if (mark-global-side-effect!? owner callee)
		    (cons owner W)
		    W)
		W)))
      (if (and (global? callee)
	       (or (eq? (global-import callee) 'import)
		   (eq? (global-import callee) 'foreign)))
	  ;; on ne marque pas ce genre d'application
	  W
	  (let ((owner-temp  (get-info owner))
		(callee-temp (get-info callee)))
	     (if (not (memq owner (temp-cfrom callee-temp)))
		 (begin
		    (temp-cfrom-set! callee-temp
				     (cons owner (temp-cfrom callee-temp)))
		    (temp-cto-set! owner-temp
				   (cons callee (temp-cto owner-temp)))))
	     W))))
   
;*---------------------------------------------------------------------*/
;*    mark-global-side-effect!? ...                                    */
;*---------------------------------------------------------------------*/
(define (mark-global-side-effect!? owner callee)
   (cond
      ((and (not (eq? (global-import callee) 'import))
	    (not (eq? (global-import callee) 'foreign)))
       #f)
      ((pragma-no-side-effect? callee)
       #f)
      (else
       (let ((info (get-info owner)))
	  (if (temp-seter info)
	      #f
	      (begin
		 (temp-seter-set! info #t)
		 #t))))))

;*---------------------------------------------------------------------*/
;*    get-info ...                                                     */
;*---------------------------------------------------------------------*/
(define (get-info var)
   (cond
      ((local? var)
       (if (temp? (local-info var))
	   (local-info var)
	   (make-local-temp var)))
      ((global? var)
       (if (temp? (global-info var))
	   (global-info var)
	   (make-global-temp var)))
      (else
       (error "get-info" "Not a variable" (shape var)))))
   
;*---------------------------------------------------------------------*/
;*    make-local-temp ...                                              */
;*---------------------------------------------------------------------*/
(define (make-local-temp local)
   (let ((new (make-temp)))
      (set! *all-functions* (cons local *all-functions*))
      (temp-seter-set! new   #f)
      (local-info-set! local new)
      new))

;*---------------------------------------------------------------------*/
;*    make-global-temp ...                                             */
;*---------------------------------------------------------------------*/
(define (make-global-temp global)
   (let ((new (make-temp)))
      (set! *all-functions* (cons global *all-functions*))
      (temp-seter-set!  new    #f)
      (global-info-set! global new)
      new))

