;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/bigloo1.7/comptime1.7/Curry/exp.scm ...                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 12 10:14:33 1993                          */
;*    Last change :  Sun Aug  7 14:03:44 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On decurryfie une expression                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module curry_exp
   (foreign (int get-hash-number (string) "get_hash_number"))
   (include "Curry/curry.sch"
	    "Var/variable.sch")
   (import  curry_let
	    curry_walk
	    var_env
	    tools_shape)
   (export  (curry-expression exp)
	    (get-curry-info nested depth)
	    (find-curry-depth arity arg body)))

;*---------------------------------------------------------------------*/
;*    create-curry ...                                                 */
;*---------------------------------------------------------------------*/
(define (create-curry depth args body)
   (let ((new (make-curry)))
      (curry-depth-set! new   depth)
      (curry-args-set!  new   args)
      (curry-body-set!  new   body)
      new))
 
;*---------------------------------------------------------------------*/
;*    find-curry-depth ...                                             */
;*---------------------------------------------------------------------*/
(define (find-curry-depth arity arg _body)
   (if (not (=fx arity 1))
       #f
       (let loop ((body  _body)
		  (args  '())
		  (depth 1))
	  (match-case body
	     ((or (begin (labels ((?fun (?a) ?new-body))
			    ?fun))
		  (labels ((?fun (?a) ?new-body))
		     ?fun))
	      (if (not (null? (local-info fun)))
		  (if (=fx depth 1)
		      #f
		      (create-curry depth (cons arg (reverse! args)) body))
		  (loop new-body
			(cons a args)
			(+fx 1 depth))))
	     (else
	      (if (=fx depth 1)
		  #f
		  (create-curry depth (cons arg (reverse! args)) body)))))))

;*---------------------------------------------------------------------*/
;*    curry-expression ...                                             */
;*---------------------------------------------------------------------*/
(define (curry-expression exp)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?atom)
       exp)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       exp)
;*--- pragma ----------------------------------------------------------*/
      ((pragma (? string?))
       exp)
;*--- assert ----------------------------------------------------------*/
      ((assert ?- ?- ?formals ?body)
       (let loop ((formals formals))
	  (if (null? formals)
	      'done
	      (begin
		 (set-car! formals (curry-expression (car formals)))
		 (loop (cdr formals))))
	  (set-car! (cddddr exp) (curry-expression body))
	  exp))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (set-cdr! exp (curry-expression* body))
       exp)
;*--- set! ------------------------------------------------------------*/
      ((set! ?var ?val)
       (set-car! (cdr exp) (curry-expression var))
       (set-car! (cddr exp) (curry-expression val))
       exp)
;*--- let -------------------------------------------------------------*/
      ((let ?- ?-)
       (curry-let exp))
;*--- labels ----------------------------------------------------------*/
      ((labels ?- ?-)
       (curry-labels exp))
;*--- failure ---------------------------------------------------------*/
      ((failure ?proc ?msg ?obj)
       (set-car! (cdr exp) (curry-expression proc))
       (set-car! (cddr exp) (curry-expression msg))
       (set-car! (cdddr exp) (curry-expression obj))
       exp)
;*--- bind-exit -------------------------------------------------------*/
      ((bind-exit (?a) ?body)
       (set-car! (cddr exp) (curry-expression body))
       exp)
;*--- apply -----------------------------------------------------------*/
      ((apply ?proc ?arg)
       (set-car! (cdr exp) (curry-expression proc))
       (set-car! (cddr exp) (curry-expression arg))
       exp)
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (curry-expression test))
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! (cdr (car hook))
			   (curry-expression (cadr (car hook))))
		 (loop (cdr hook))))))
;*--- if --------------------------------------------------------------*/
      ((if ?si ?alors ?sinon)
       (set-car! (cdr exp) (curry-expression si))
       (set-car! (cddr exp) (curry-expression alors))
       (set-car! (cdddr exp) (curry-expression sinon))
       exp)
;*--- application -----------------------------------------------------*/
      (else
       (curry-application exp))))

;*---------------------------------------------------------------------*/
;*    curry-expression* ...                                            */
;*---------------------------------------------------------------------*/
(define (curry-expression* exp)
   (let loop ((hook exp))
      (cond
	 ((null? hook)
	  exp)
	 ((not (pair? hook))
	  exp)
	 (else
	  (set-car! hook (curry-expression (car hook)))
	  (loop (cdr hook))))))
   
;*---------------------------------------------------------------------*/
;*    curry-application ...                                            */
;*    -------------------------------------------------------------    */
;*    Dans cette fonction, on fait la transformation:                  */
;*       `((...(foo x1) x2) ... xn)' => `(foo x1 ... xn)'              */
;*    S'il s'agit d'une application totale (si n est l'arite totale    */
;*    de foo).                                                         */
;*---------------------------------------------------------------------*/
(define (curry-application exp)
   (let ((fun (car exp)))
      ;; c'est une application directe
      (if (not (pair? fun))
	  (begin
	     (curry-expression* (cdr exp))
	     exp)
	  ;; c'est une application composee
	  (let (nested-depth nested nested-args)
	     (let loop ((fun   fun)
			(args  '())
			(depth 1))
		(if (or (not (pair? fun))
			(not (pair? (cdr  fun)))
			(not (null? (cddr fun))))
		    (begin
		       (set! nested-depth depth)
		       (set! nested-args  args)
		       (set! nested       fun))
		    (loop (car fun)
			  (cons (cadr fun) args)
			  (+fx 1 depth))))
	     (if (or (and (not (global? nested))
			  (not (local? nested)))
		     (not (integer? nested-depth)))
		 (begin
		    (curry-expression* (cdr exp))
		    exp)
		 (let ((curry (get-curry-info nested nested-depth)))
		    (if (or (not (curry? curry))
			    (not (=fx nested-depth (curry-depth curry))))
			;; si ce n'est pas une application totale, on laisse
			;; tomber et on n'optimise rien du tout.
			(curry-expression* exp)
			(let* ((new-fun (curry-new-fun curry))
			       (value   (if (local? new-fun)
					    (local-value new-fun)
					    (global-value new-fun)))
			       (nvalue  (if (local? nested)
					    (local-value nested)
					    (global-value nested))))
			   ;; on change les invocations, il faut donc
			   ;; tenir a jour les champs `invocations'.
			   (function-invocations-set!
			    value
			    (+fx (function-invocations value) 1))
			   (function-invocations-set!
			    nvalue
			    (-fx (function-invocations nvalue) 1))
			   (set-car! exp new-fun)
			   (set-cdr! exp (append (curry-expression*
						  nested-args)
						 (curry-expression*
						  (cdr exp))))
			   exp))))))))

;*---------------------------------------------------------------------*/
;*    get-curry-info ...                                               */
;*---------------------------------------------------------------------*/
(define (get-curry-info nested depth)
   (if (global? nested)
       (if (not (null? (global-info nested)))
	   (global-info nested)
	   (let* ((try-name    (curryfied-name (global-name nested)
					       depth))
		  (try-to-find (find-in-global-environment try-name *Genv*)))
	      (if (global? try-to-find)
		  (let ((curry (create-curry depth '() '())))
		     (curry-new-fun-set! curry try-to-find)
		     (curry-depth-set!   curry depth)
		     (mark-curry-info! nested curry)
		     curry))))
       (local-info nested)))
		  
;*---------------------------------------------------------------------*/
;*    curryfied-name ...                                               */
;*---------------------------------------------------------------------*/
(define (curryfied-name old-name arity)
   (let ((pname (if (string? old-name)
		    old-name
		    (symbol->string old-name))))
   (string->symbol (string-append (integer->string arity)
				  "-"
				  (integer->string
				   (get-hash-number (string-upcase
						     pname)))
				  "-"
				  pname))))

