;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Cse/walk.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 25 16:26:07 1993                          */
;*    Last change :  Thu Jun  2 14:42:32 1994 (serrano)                */
;*                                                                     */
;*    L'elimination des sous expressions communes.                     */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cse_walk
   (include "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    cse_cse)
   (export  (cse-walk tree)))

;*---------------------------------------------------------------------*/
;*    cse-walk ...                                                     */
;*---------------------------------------------------------------------*/
(define (cse-walk tree)
   (verbose "   . Cse" #\Newline)
   (start-partial-error "Cse")
   (let loop ((walk tree))
      (if (null? walk)
	   (begin
	      (fail-if-partial-error)
	      tree)
	   (let ((var (car walk)))
	      (enter-function (shape var))
	      (let ((value (cond
			      ((global? var)
			       (global-value var))
			      ((local? var)
			       (error "cse-walk" "Not a global" (shape var)))
			      (else
			       (error "cse-walk"
				      "Not a variable"
				      (shape var))))))
		 (for-each (lambda (local)
			      (local-info-set! local '()))
			   (function-args value))
		 (function-body-set! value
				     (cse (function-body value)
					  #f
					  '() '() '() '()))
		 (leave-function)
		 (loop (cdr walk)))))))

